/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui;

import com.google.common.collect.Lists;
import ivorius.ivtoolkit.blocks.BlockStates;
import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.gui.editstructure.transformers.TableDataSourceBTNatural;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCells;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.cell.TableCell;
import ivorius.reccomplex.gui.table.cell.TableCellButton;
import ivorius.reccomplex.gui.table.cell.TableCellEnum;
import ivorius.reccomplex.gui.table.cell.TableCellIntSlider;
import ivorius.reccomplex.gui.table.cell.TableCellMulti;
import ivorius.reccomplex.gui.table.cell.TableCellString;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TableDataSourceBlockState
extends TableDataSourceSegmented {
    private String block = "";
    private int meta;
    private Consumer<IBlockState> consumer;
    private String blockTitle;
    private String metadataTitle;
    private TableCellString idCell;
    private TableCellIntSlider metaCell;
    private TableNavigator navigator;
    private TableDelegate delegate;
    private boolean showExtendedProperties;

    public TableDataSourceBlockState(IBlockState state, Consumer<IBlockState> consumer, TableNavigator navigator, TableDelegate delegate, String blockTitle, String metadataTitle) {
        this.setBlockState(state);
        this.consumer = consumer;
        this.blockTitle = blockTitle;
        this.metadataTitle = metadataTitle;
        this.navigator = navigator;
        this.delegate = delegate;
        this.addSegment(0, () -> {
            TableCellString cell = this.idCell = TableDataSourceBTNatural.cellForBlock("block", this.block);
            cell.addListener(p -> this.valueChanged());
            return new TitledCell("blockID", blockTitle, cell);
        }, () -> {
            TableCellIntSlider cell = this.metaCell = new TableCellIntSlider("metadata", this.meta, 0, 15);
            cell.addListener(p -> this.valueChanged());
            return new TitledCell("blockMeta", metadataTitle, cell);
        });
    }

    public TableDataSourceBlockState(IBlockState state, Consumer<IBlockState> consumer, TableNavigator navigator, TableDelegate delegate) {
        this(state, consumer, navigator, delegate, IvTranslations.get((String)"reccomplex.gui.block"), IvTranslations.get((String)"reccomplex.gui.metadata"));
    }

    public boolean isShowExtendedProperties() {
        return this.showExtendedProperties;
    }

    public TableDataSourceBlockState setShowExtendedProperties(boolean showExtendedProperties) {
        this.showExtendedProperties = showExtendedProperties;
        return this;
    }

    @Override
    public int numberOfSegments() {
        return this.showExtendedProperties ? 3 : 2;
    }

    @Override
    public int sizeOfSegment(int segment) {
        switch (segment) {
            case 1: {
                IBlockState state = this.computeBlockState();
                return state != null ? this.getSortedPropertyNames(state, false).size() : 0;
            }
            case 2: {
                IBlockState state = this.computeBlockState();
                return state != null ? this.getSortedPropertyNames(state, true).size() : 0;
            }
        }
        return super.sizeOfSegment(segment);
    }

    @Override
    public TableCell cellForIndexInSegment(GuiTable table, int index, int segment) {
        switch (segment) {
            case 1: {
                return this.getPropertyElement(index, false);
            }
            case 2: {
                return this.getPropertyElement(index, true);
            }
        }
        return super.cellForIndexInSegment(table, index, segment);
    }

    @Nonnull
    protected <T extends Comparable<T>> TitledCell getPropertyElement(int index, boolean extended) {
        IBlockState state = this.computeBlockState();
        IProperty<?> name = this.getSortedPropertyNames(state, extended).get(index);
        List<?> properties = this.getSortedProperties(name);
        Comparable currentProperty = state.func_177229_b(name);
        if (properties.size() <= 4) {
            List buttons = properties.stream().map(property -> {
                TableCellButton button = new TableCellButton(null, null, name.func_177702_a(property));
                button.setEnabled(!extended);
                button.addAction(() -> {
                    this.setBlockStateAndNotify(state.func_177226_a(name, property));
                    this.delegate.reloadData();
                });
                if (property == currentProperty) {
                    button.setEnabled(false);
                }
                return button;
            }).collect(Collectors.toList());
            return new TitledCell(name.func_177701_a(), new TableCellMulti(buttons));
        }
        ArrayList sorted = Lists.newArrayList((Iterable)name.func_177700_c());
        Collections.sort(sorted);
        TableCellEnum<Comparable> cell = new TableCellEnum<Comparable>(null, state.func_177229_b(name), sorted.stream().map(t1 -> new TableCellEnum.Option<Comparable>((Comparable)t1, name.func_177702_a(currentProperty))).collect(Collectors.toList()));
        cell.addListener(t -> {
            this.setBlockStateAndNotify(state.func_177226_a(name, t));
            this.delegate.reloadData();
        });
        cell.setEnabled(!extended);
        return new TitledCell(name.func_177701_a(), cell);
    }

    protected <T extends Comparable<T>> List<T> getSortedProperties(IProperty<T> name) {
        ArrayList values = Lists.newArrayList((Iterable)name.func_177700_c());
        Collections.sort(values);
        return values;
    }

    @Nonnull
    protected List<IProperty<?>> getSortedPropertyNames(IBlockState state, boolean extended) {
        ArrayList names = Lists.newArrayList((Iterable)state.func_177227_a());
        names.removeIf(name -> name.func_177700_c().stream().mapToInt(obj -> BlockStates.toMetadata((IBlockState)state.func_177226_a(name, obj))).distinct().count() < 2L != extended);
        names.sort(Comparator.comparing(IProperty::func_177701_a));
        return names;
    }

    public void valueChanged() {
        IBlockState before = this.computeBlockState();
        this.block = (String)this.idCell.getPropertyValue();
        this.meta = (Integer)this.metaCell.getPropertyValue();
        TableDataSourceBTNatural.setStateForBlockTextfield(this.idCell);
        IBlockState state = this.computeBlockState();
        this.setBlockStateAndNotify(state);
        if (state != before) {
            TableCells.reloadExcept(this.delegate, "blockID", "blockMeta");
        }
    }

    protected void setBlockStateAndNotify(IBlockState c) {
        if (c != null) {
            this.consumer.accept(c);
            this.setBlockState(c);
        }
    }

    public void setBlockState(IBlockState state) {
        this.block = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c())).toString();
        this.meta = BlockStates.toMetadata((IBlockState)state);
    }

    public IBlockState computeBlockState() {
        try {
            Block block = RecurrentComplex.mcRegistry.blockFromID(new ResourceLocation(this.block));
            return block != null ? BlockStates.fromMetadata((Block)block, (int)this.meta) : null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

