/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.tweaks.misc.loadsound;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.config.UTConfigTweaks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="universaltweaks", value={Side.CLIENT})
public class UTLoadSound {
    private static final Random random = new Random();
    private static final List<SoundEvent> soundListMC = new ArrayList<SoundEvent>();
    private static final List<SoundEvent> soundListWorld = new ArrayList<SoundEvent>();
    private static final List<Float> pitchListMC = new ArrayList<Float>();
    private static final List<Float> pitchListWorld = new ArrayList<Float>();
    private static final List<Float> volumeListMC = new ArrayList<Float>();
    private static final List<Float> volumeListWorld = new ArrayList<Float>();
    private static boolean playedMenu = false;
    private static boolean playedWorld = false;

    public static void initLists() {
        Float volume;
        Float pitch;
        SoundEvent soundEvent;
        String[] soundEntries;
        soundListMC.clear();
        soundListWorld.clear();
        pitchListMC.clear();
        pitchListWorld.clear();
        volumeListMC.clear();
        volumeListWorld.clear();
        for (String sound : UTConfigTweaks.MISC.LOAD_SOUNDS.utLoadSoundMC) {
            soundEntries = sound.split(";");
            soundEvent = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(soundEntries[0]));
            if (soundEvent != null) {
                pitch = Float.valueOf(1.0f);
                volume = Float.valueOf(1.0f);
                try {
                    pitch = new Float(soundEntries[1]);
                    volume = new Float(soundEntries[2]);
                }
                catch (Exception e) {
                    UniversalTweaks.LOGGER.warn("Unable to parse sound properties for {}", (Object)new ResourceLocation(soundEntries[0]));
                }
                soundListMC.add(soundEvent);
                pitchListMC.add(pitch);
                volumeListMC.add(volume);
                continue;
            }
            UniversalTweaks.LOGGER.warn("Unable to find sound: {}", (Object)new ResourceLocation(soundEntries[0]));
        }
        for (String sound : UTConfigTweaks.MISC.LOAD_SOUNDS.utLoadSoundWorld) {
            soundEntries = sound.split(";");
            soundEvent = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(soundEntries[0]));
            if (soundEvent != null) {
                pitch = Float.valueOf(1.0f);
                volume = Float.valueOf(1.0f);
                try {
                    pitch = new Float(soundEntries[1]);
                    volume = new Float(soundEntries[2]);
                }
                catch (Exception e) {
                    UniversalTweaks.LOGGER.warn("Unable to parse sound properties for {}", (Object)new ResourceLocation(soundEntries[0]));
                }
                soundListWorld.add(soundEvent);
                pitchListWorld.add(pitch);
                volumeListWorld.add(volume);
                continue;
            }
            UniversalTweaks.LOGGER.warn("Unable to find sound: {}", (Object)new ResourceLocation(soundEntries[0]));
        }
        UniversalTweaks.LOGGER.info("Load Sound lists initialized");
    }

    public static void playRandomSoundMC() {
        if (soundListMC.isEmpty()) {
            return;
        }
        int randomIndex = random.nextInt(soundListMC.size());
        SoundEvent soundEvent = soundListMC.get(randomIndex);
        Float pitch = pitchListMC.get(randomIndex);
        Float volume = volumeListMC.get(randomIndex);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(soundEvent.func_187503_a(), SoundCategory.MASTER, volume.floatValue(), pitch.floatValue(), false, 0, ISound.AttenuationType.NONE, 0.0f, 0.0f, 0.0f));
    }

    public static void playRandomSoundWorld() {
        if (soundListMC.isEmpty()) {
            return;
        }
        int randomIndex = random.nextInt(soundListWorld.size());
        SoundEvent soundEvent = soundListWorld.get(randomIndex);
        Float pitch = pitchListWorld.get(randomIndex);
        Float volume = volumeListWorld.get(randomIndex);
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(soundEvent.func_187503_a(), SoundCategory.MASTER, volume.floatValue(), pitch.floatValue(), false, 0, ISound.AttenuationType.NONE, (float)player.field_70165_t, (float)player.field_70163_u, (float)player.field_70161_v));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void utMenuSound(GuiOpenEvent event) {
        if (!playedMenu && event.getGui() instanceof GuiMainMenu) {
            if (UTConfigTweaks.MISC.LOAD_SOUNDS.utLoadSoundMode == UTConfigTweaks.MiscCategory.LoadSoundsCategory.EnumSoundModes.MINECRAFT || UTConfigTweaks.MISC.LOAD_SOUNDS.utLoadSoundMode == UTConfigTweaks.MiscCategory.LoadSoundsCategory.EnumSoundModes.MINECRAFT_AND_WORLD) {
                UTLoadSound.playRandomSoundMC();
            }
            playedMenu = true;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void utWorldSound(EntityJoinWorldEvent event) {
        if (!playedWorld && event.getEntity() instanceof EntityPlayerSP) {
            if (UTConfigTweaks.MISC.LOAD_SOUNDS.utLoadSoundMode == UTConfigTweaks.MiscCategory.LoadSoundsCategory.EnumSoundModes.WORLD || UTConfigTweaks.MISC.LOAD_SOUNDS.utLoadSoundMode == UTConfigTweaks.MiscCategory.LoadSoundsCategory.EnumSoundModes.MINECRAFT_AND_WORLD) {
                UTLoadSound.playRandomSoundWorld();
            }
            playedWorld = true;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void utWorldSoundReset(PlayerEvent.PlayerLoggedOutEvent event) {
        playedWorld = false;
    }
}

