/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.mods.abyssalcraft.mixin;

import com.shinoow.abyssalcraft.api.transfer.ItemTransferConfiguration;
import com.shinoow.abyssalcraft.api.transfer.caps.IItemTransferCapability;
import com.shinoow.abyssalcraft.api.transfer.caps.ItemTransferCapability;
import com.shinoow.abyssalcraft.common.entity.EntitySpiritItem;
import com.shinoow.abyssalcraft.common.handlers.ItemTransferEventHandler;
import mod.acgaming.universaltweaks.config.UTConfigMods;
import mod.acgaming.universaltweaks.mods.abyssalcraft.worlddata.UTWorldDataCapability;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemTransferEventHandler.class}, remap=false)
public class UTItemTransferEventHandlerMixin {
    @Inject(method={"onTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void utOnTick(TickEvent.WorldTickEvent event, CallbackInfo ci) {
        if (!UTConfigMods.ABYSSALCRAFT.utOptimizedItemTransferToggle) {
            return;
        }
        ci.cancel();
        if (event.side == Side.SERVER && event.type == TickEvent.Type.WORLD && event.phase == TickEvent.Phase.END) {
            World world = event.world;
            if (world.func_82737_E() % 20L != 0L) {
                return;
            }
            if (UTWorldDataCapability.getCap(world).isEmpty()) {
                return;
            }
            UTWorldDataCapability.getCap(world).getFlattenedView().forEach((pos, tile) -> {
                if (!world.func_175667_e(pos)) {
                    return;
                }
                if (tile == null) {
                    tile = world.func_175625_s(pos);
                    UTWorldDataCapability.getCap(world).updateConfigured(world.func_175726_f(pos), (BlockPos)pos, (TileEntity)tile);
                }
                if (!this.hasCap((TileEntity)tile)) {
                    return;
                }
                IItemTransferCapability cap = ItemTransferCapability.getCap((TileEntity)tile);
                for (ItemTransferConfiguration cfg : cap.getTransferConfigurations()) {
                    IItemHandler exitInv;
                    BlockPos exitPos;
                    TileEntity te;
                    IItemHandler inventory = ItemTransferEventHandler.getInventory((TileEntity)tile, (EnumFacing)cfg.getExitFacing());
                    if (inventory == null) continue;
                    boolean hasFilter = !cfg.getFilter().isEmpty() && cfg.getFilter().stream().anyMatch(i -> !i.func_190926_b());
                    ItemStack stack = ItemStack.field_190927_a;
                    int slot = -1;
                    for (int i2 = 0; i2 < inventory.getSlots(); ++i2) {
                        stack = inventory.getStackInSlot(i2);
                        if (stack.func_190926_b() || hasFilter && !this.isInFilter((NonNullList<ItemStack>)cfg.getFilter(), stack, cfg.filterByNBT())) continue;
                        stack = inventory.extractItem(i2, 1, true);
                        slot = i2;
                        break;
                    }
                    if (stack.func_190926_b() || slot <= -1 || (te = world.func_175625_s(exitPos = cfg.getRoute()[cfg.getRoute().length - 1])) == null || (exitInv = ItemTransferEventHandler.getInventory((TileEntity)te, (EnumFacing)cfg.getEntryFacing())) == null || !ItemHandlerHelper.insertItem((IItemHandler)exitInv, (ItemStack)stack, (boolean)true).func_190926_b()) continue;
                    stack = inventory.extractItem(slot, 1, false);
                    EntitySpiritItem spirit = new EntitySpiritItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, stack.func_77946_l());
                    spirit.setRoute(cfg.getRoute());
                    spirit.setFacing(cfg.getEntryFacing());
                    world.func_72838_d((Entity)spirit);
                }
            });
        }
    }

    @Shadow
    private boolean hasCap(TileEntity te) {
        return false;
    }

    @Shadow
    private boolean isInFilter(NonNullList<ItemStack> filter, ItemStack stack, boolean nbt) {
        return false;
    }
}

