/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.config;

import com.cleanroommc.configanytime.ConfigAnytime;
import java.util.HashMap;
import java.util.Map;
import mod.acgaming.universaltweaks.core.UTLoadingPlugin;
import mod.acgaming.universaltweaks.tweaks.blocks.breakablebedrock.UTBreakableBedrock;
import mod.acgaming.universaltweaks.tweaks.items.parry.UTParry;
import mod.acgaming.universaltweaks.tweaks.items.rarity.UTCustomRarity;
import mod.acgaming.universaltweaks.tweaks.items.useduration.UTCustomUseDuration;
import mod.acgaming.universaltweaks.tweaks.misc.armorcurve.UTArmorCurve;
import mod.acgaming.universaltweaks.tweaks.misc.incurablepotions.UTIncurablePotions;
import mod.acgaming.universaltweaks.tweaks.misc.loadsound.UTLoadSound;
import mod.acgaming.universaltweaks.tweaks.misc.swingthroughgrass.UTSwingThroughGrassLists;
import mod.acgaming.universaltweaks.tweaks.misc.timeouts.UTTimeoutManager;
import mod.acgaming.universaltweaks.tweaks.performance.autosave.UTAutoSaveOFCompat;
import mod.acgaming.universaltweaks.tweaks.performance.entityradiuscheck.UTEntityRadiusCheck;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="universaltweaks", name="Universal Tweaks - Tweaks")
public class UTConfigTweaks {
    @Config.LangKey(value="cfg.universaltweaks.config.blocks")
    @Config.Name(value="Blocks")
    public static final BlocksCategory BLOCKS = new BlocksCategory();
    @Config.LangKey(value="cfg.universaltweaks.config.entities")
    @Config.Name(value="Entities")
    public static final EntitiesCategory ENTITIES = new EntitiesCategory();
    @Config.LangKey(value="cfg.universaltweaks.config.items")
    @Config.Name(value="Items")
    public static final ItemsCategory ITEMS = new ItemsCategory();
    @Config.LangKey(value="cfg.universaltweaks.config.misc")
    @Config.Name(value="Misc")
    public static final MiscCategory MISC = new MiscCategory();
    @Config.LangKey(value="cfg.universaltweaks.config.performance")
    @Config.Name(value="Performance")
    public static final PerformanceCategory PERFORMANCE = new PerformanceCategory();
    @Config.LangKey(value="cfg.universaltweaks.config.world")
    @Config.Name(value="World")
    public static final WorldCategory WORLD = new WorldCategory();

    static {
        ConfigAnytime.register(UTConfigTweaks.class);
        UTTimeoutManager.init();
    }

    @Mod.EventBusSubscriber(modid="universaltweaks")
    public static class EventHandler {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("universaltweaks")) {
                ConfigManager.sync((String)"universaltweaks", (Config.Type)Config.Type.INSTANCE);
                if (UTConfigTweaks.BLOCKS.BREAKABLE_BEDROCK.utBreakableBedrockToggle) {
                    UTBreakableBedrock.initToolList();
                }
                if (UTConfigTweaks.MISC.ARMOR_CURVE.utArmorCurveToggle) {
                    UTArmorCurve.initExpressions();
                }
                if (UTConfigTweaks.MISC.SWING_THROUGH_GRASS.utSwingThroughGrassToggle) {
                    UTSwingThroughGrassLists.initLists();
                }
                if (UTConfigTweaks.MISC.INCURABLE_POTIONS.utIncurablePotionsToggle) {
                    UTIncurablePotions.initPotionList();
                }
                if (UTConfigTweaks.PERFORMANCE.ENTITY_RADIUS_CHECK.utEntityRadiusCheckCategoryToggle) {
                    if (UTConfigTweaks.PERFORMANCE.ENTITY_RADIUS_CHECK.utReduceSearchSizeToggle) {
                        UTEntityRadiusCheck.initSearchTargets();
                    }
                    if (UTConfigTweaks.PERFORMANCE.ENTITY_RADIUS_CHECK.utLessCollisionsToggle) {
                        UTEntityRadiusCheck.initCollisionTargets();
                    }
                }
                if (UTConfigTweaks.ITEMS.utCustomRarities.length > 0) {
                    UTCustomRarity.initItemRarityMap();
                }
                if (UTConfigTweaks.ITEMS.utCustomUseDurations.length > 0) {
                    UTCustomUseDuration.initItemUseMaps();
                }
                if (UTConfigTweaks.ITEMS.PARRY.utParryToggle) {
                    UTParry.initProjectileList();
                }
                if (UTLoadingPlugin.isClient) {
                    if (UTConfigTweaks.MISC.LOAD_SOUNDS.utLoadSoundMode != MiscCategory.LoadSoundsCategory.EnumSoundModes.NOTHING) {
                        UTLoadSound.initLists();
                    }
                    UTAutoSaveOFCompat.updateOFConfig();
                }
            }
        }
    }

    public static class WorldCategory {
        @Config.LangKey(value="cfg.universaltweaks.tweaks.world.cavegen")
        @Config.Name(value="Cave Generation")
        public final CaveGenCategory CAVE_GEN = new CaveGenCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.world.chunkgenlimit")
        @Config.Name(value="Chunk Gen Limit")
        public final ChunkGenLimitCategory CHUNK_GEN_LIMIT = new ChunkGenLimitCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.world.dimensionunload")
        @Config.Name(value="Dimension Unload")
        public final DimensionUnloadCategory DIMENSION_UNLOAD = new DimensionUnloadCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.world.voidfog")
        @Config.Name(value="Void Fog")
        public final VoidFogCategory VOID_FOG = new VoidFogCategory();
        @Config.RequiresMcRestart
        @Config.Name(value="Sea Level")
        @Config.Comment(value={"Sets the default height of the overworld's sea level", "Supported world types: Default, Biomes O' Plenty", "Vanilla default is 63"})
        public int utSeaLevel = 63;
        @Config.RequiresMcRestart
        @Config.Name(value="Stronghold Enforcement")
        @Config.Comment(value={"Enforces stronghold generation to generate all blocks, regardless of air"})
        public boolean utStrongholdToggle = true;
        @Config.Name(value="Tidy Chunk")
        @Config.Comment(value={"Tidies newly generated chunks by removing scattered item entities"})
        public boolean utTidyChunkToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Village Distance")
        @Config.Comment(value={"Sets the village generation distance in chunks", "Vanilla default is 32"})
        public int utVillageDistance = 32;

        public static class VoidFogCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Void Fog Toggle")
            @Config.Comment(value={"Re-implements pre-1.8 void fog and void particles"})
            public boolean utVoidFogToggle = false;
            @Config.Name(value="[2] Dimension List")
            @Config.Comment(value={"List of dimensions concerning void fog and particles", "Behavior depends on the list mode", "Can be dimension name or ID"})
            public String[] utVoidFogDimensionList = new String[]{"overworld"};
            @Config.Name(value="[3] Dimension List Mode")
            @Config.Comment(value={"Blacklist Mode: Dimensions that don't have void fog and particles enabled, others do", "Whitelist Mode: Dimensions that have void fog and particles enabled, others don't"})
            public EnumLists utVoidFogDimensionListMode = EnumLists.WHITELIST;
            @Config.Name(value="[4] Fog In Creative/Spectator")
            @Config.Comment(value={"Renders void fog in creative and spectator mode"})
            public boolean utVoidFogCreativeSpectator = false;
            @Config.Name(value="[5] Fog In Superflat")
            @Config.Comment(value={"Renders void fog in the superflat world type"})
            public boolean utVoidFogSuperflat = false;
            @Config.Name(value="[6] Fog On Night Vision")
            @Config.Comment(value={"Renders void fog when the player has night vision"})
            public boolean utVoidFogNightVision = false;
            @Config.Name(value="[7] Particles In Creative/Spectator")
            @Config.Comment(value={"Renders void particles in creative and spectator mode"})
            public boolean utVoidParticlesCreativeSpectator = true;
            @Config.Name(value="[8] Particles In Superflat")
            @Config.Comment(value={"Renders void particles in the superflat world type"})
            public boolean utVoidParticlesSuperflat = false;
            @Config.Name(value="[9] Particle Spawn Y Level")
            @Config.Comment(value={"Determines the maximum Y level of the player at which void particles are spawned"})
            public int utVoidParticleSpawnYLevel = 8;
            @Config.Name(value="[10] Particle Spawn Iterations")
            @Config.Comment(value={"Determines the amount of iterations for checking void particle spawns per animate tick"})
            public int utVoidParticleSpawnIterations = 1000;
        }

        public static class DimensionUnloadCategory {
            @Config.Name(value="[1] Dimension Unload Toggle")
            @Config.Comment(value={"Unloads dimensions not in use to free up resources"})
            public boolean utUnloaderToggle = true;
            @Config.Name(value="[2] Interval")
            @Config.Comment(value={"Time (in ticks) to wait before checking dimensions"})
            public int utUnloaderInterval = 600;
            @Config.Name(value="[3] Blacklist")
            @Config.Comment(value={"List of dimensions which should not be unloaded", "Can be dimension name or ID", "Uses regular expressions"})
            public String[] utUnloaderBlacklist = new String[]{"0", "overworld"};
        }

        public static class ChunkGenLimitCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Chunk Gen Limit Toggle")
            @Config.Comment(value={"Limits maximum chunk generation per tick for improved server performance"})
            public boolean utChunkGenLimitToggle = false;
            @Config.Name(value="[2] Ticks")
            @Config.Comment(value={"Maximum chunks to generate per tick per dimension"})
            public int utChunkGenLimitTicks = 2;
            @Config.Name(value="[3] Time")
            @Config.Comment(value={"Maximum time in ms to spend generating chunks per tick per dimension"})
            public int utChunkGenLimitTime = 5;
        }

        public static class CaveGenCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Cave Generation Toggle")
            @Config.Comment(value={"Sets custom values for the vanilla cave generation"})
            public boolean utCaveGenToggle = false;
            @Config.Name(value="[2] Cave Size")
            @Config.Comment(value={"Size of cave systems", "40 for pre-1.7 generation", "15 for vanilla default"})
            public int utCaveGenSize = 15;
            @Config.Name(value="[3] Cave Rarity")
            @Config.Comment(value={"Chance for generating cave systems", "15 for pre-1.7 generation", "7 for vanilla default"})
            public int utCaveGenRarity = 7;
        }
    }

    public static class PerformanceCategory {
        @Config.LangKey(value="cfg.universaltweaks.tweaks.performance.entityradiuscheck")
        @Config.Name(value="Entity Radius Check")
        public final EntityRadiusCheckCategory ENTITY_RADIUS_CHECK = new EntityRadiusCheckCategory();
        @Config.RequiresMcRestart
        @Config.Name(value="Auto Save Interval")
        @Config.Comment(value={"Determines the interval in ticks between world auto saves"})
        public int utAutoSaveInterval = 900;
        @Config.RequiresMcRestart
        @Config.Name(value="Check Animated Models")
        @Config.Comment(value={"Improves model load times by checking if an animated model exists before trying to load it"})
        public boolean utCheckAnimatedModelsToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Crafting Cache")
        @Config.Comment(value={"Adds an IRecipe cache to improve recipe performance in larger modpacks", "Incompatible with KemonoCraft"})
        public boolean utCraftingCacheToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Disable Audio Debug")
        @Config.Comment(value={"Improves loading times by removing debug code for missing sounds and subtitles"})
        public boolean utDisableAudioDebugToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Disable Fancy Missing Model")
        @Config.Comment(value={"Improves rendering performance by removing the resource location text on missing models"})
        public boolean utDisableFancyMissingModelToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Disable Mob Spawner Entity")
        @Config.Comment(value={"Improves rendering performance by disabling rendering the entity inside mob spawners"})
        public boolean utDisableMobSpawnerRendering = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Disable Rain Particles")
        @Config.Comment(value={"Prevents Rain and Snow Particles from rendering when Raining or Thundering"})
        public boolean utDisableRainParticles = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Faster Background Startup")
        @Config.Comment(value={"Fixes slow background startup edge case caused by checking tooltips during the loading process", "May have side effects concerning tooltips"})
        public boolean utFasterBackgroundStartupToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Fast Dye Blending")
        @Config.Comment(value={"Replaces color lookup for sheep to check a predefined table rather than querying the recipe registry"})
        public boolean utDyeBlendingToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Fast Prefix Checking")
        @Config.Comment(value={"Optimizes Forge's ID prefix checking and removes prefix warnings impacting load time"})
        public boolean utPrefixCheckToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Fast World Loading")
        @Config.Comment(value={"Skips initial world chunk loading & garbage collection to speed up world loading", "May have side effects such as slower chunk generation"})
        public boolean utWorldLoadingToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Improve Language Switching Speed")
        @Config.Comment(value={"Improves the speed of switching languages in the Language GUI", "Incompatible with OptiFine"})
        public boolean utImproveLanguageSwitchingSpeed = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Improve Server Connection Speed")
        @Config.Comment(value={"Improves the speed of connecting to servers by setting the InetAddress host name to the IP in situations", "where it can be represented as the IP address, preventing getHostFromNameService from being to be run"})
        public boolean utImproveServerConnectionSpeed = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Mute Advancement Errors")
        @Config.Comment(value={"Silences advancement errors"})
        public boolean utAdvancementCheckToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Mute Ore Dictionary Errors")
        @Config.Comment(value={"Silences ore dictionary errors"})
        public boolean utOreDictionaryCheckToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Mute Texture Map Errors")
        @Config.Comment(value={"Silences texture map errors"})
        public boolean utTextureMapCheckToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="No Pathfinding Chunk Loading")
        @Config.Comment(value={"Disables mob pathfinding from loading new/unloaded chunks when building chunk caches"})
        public boolean utPathfindingChunkCacheFixToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="No Redstone Lighting")
        @Config.Comment(value={"Disables lighting of active redstone, repeaters, and comparators to improve performance"})
        public boolean utRedstoneLightingToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Uncap FPS")
        @Config.Comment(value={"Removes the hardcoded 30 FPS limit in screens like the main menu"})
        public boolean utUncapFPSToggle = true;

        public static class EntityRadiusCheckCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Entity Radius Check Toggle")
            @Config.Comment(value={"Toggles all tweaks in this category", "IMPORTANT: These tweaks are only effective if you have mod(s) that increase World.MAX_ENTITY_RADIUS!", "(Lycanites Mobs, Advanced Rocketry, Immersive Railroading, etc.)"})
            public boolean utEntityRadiusCheckCategoryToggle = true;
            @Config.Name(value="[2] Reduce Search Size Toggle")
            @Config.Comment(value={"Reduces the search size of various AABB functions for specified entity types"})
            public boolean utReduceSearchSizeToggle = true;
            @Config.Name(value="[3] Reduce Search Size Targets")
            @Config.Comment(value={"The entity types to reduce the search size for", "Syntax - modid:name"})
            public String[] utReduceSearchSizeTargets = new String[]{"minecraft:item", "minecraft:player"};
            @Config.Name(value="[4] Less Collisions Toggle")
            @Config.Comment(value={"Reduces size of collision checks for most vanilla and specified entity types"})
            public boolean utLessCollisionsToggle = true;
            @Config.Name(value="[5] Less Collisions Extra Targets")
            @Config.Comment(value={"The extra entity types to reduce the size of collision checks for", "Syntax - modid:name;radius", "Vanilla ids aren't allowed because they are already included", "Most types should be specified with the vanilla default radius: 2.0"})
            public String[] utLessCollisionsExtraTargets = new String[0];
        }
    }

    public static class MiscCategory {
        @Config.LangKey(value="cfg.universaltweaks.tweaks.misc.advancements")
        @Config.Name(value="Advancements")
        public final AdvancementsCategory ADVANCEMENTS = new AdvancementsCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.misc.armorcurve")
        @Config.Name(value="Armor Curve")
        public final ArmorCurveCategory ARMOR_CURVE = new ArmorCurveCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.misc.chat")
        @Config.Name(value="Chat")
        public final ChatCategory CHAT = new ChatCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.misc.timeouts")
        @Config.Name(value="Connection Timeouts")
        public final TimeoutsCategory TIMEOUTS = new TimeoutsCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.misc.incurablepotions")
        @Config.Name(value="Incurable Potions")
        public final IncurablePotionsCategory INCURABLE_POTIONS = new IncurablePotionsCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.misc.lightning")
        @Config.Name(value="Lightning")
        public final LightningCategory LIGHTNING = new LightningCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.misc.loadsounds")
        @Config.Name(value="Load Sounds")
        public final LoadSoundsCategory LOAD_SOUNDS = new LoadSoundsCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.misc.pickupnotification")
        @Config.Name(value="Pickup Notification")
        public final PickupNotificationCategory PICKUP_NOTIFICATION = new PickupNotificationCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.misc.smoothscrolling")
        @Config.Name(value="Smooth Scrolling")
        public final SmoothScrollingCategory SMOOTH_SCROLLING = new SmoothScrollingCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.misc.stg")
        @Config.Name(value="Swing Through Grass")
        public final SwingThroughGrassCategory SWING_THROUGH_GRASS = new SwingThroughGrassCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.misc.toastcontrol")
        @Config.Name(value="Toast Control")
        public final ToastControlCategory TOAST_CONTROL = new ToastControlCategory();
        @Config.Name(value="Accurate Potion Duration")
        @Config.Comment(value={"Always displays the actual potion duration instead of `**:**`"})
        public boolean utPotionDurationToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Always Return to Main Menu")
        @Config.Comment(value={"Always returns the player to the main menu when quitting the game"})
        public boolean utReturnToMainMenu = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Copy World Seed")
        @Config.Comment(value={"Enables clicking of `/seed` world seed in chat to copy to clipboard", "Required on server AND client"})
        public boolean utCopyWorldSeedToggle = true;
        @Config.Name(value="Damage Tilt")
        @Config.Comment(value={"Restores feature to tilt the camera when damaged"})
        public boolean utDamageTiltToggle = true;
        @Config.Name(value="Default Difficulty")
        @Config.Comment(value={"Sets the default difficulty for newly generated worlds"})
        public EnumDifficulty utDefaultDifficulty = EnumDifficulty.NORMAL;
        @Config.RequiresMcRestart
        @Config.Name(value="Disable Advancements")
        @Config.Comment(value={"Prevents the advancement system from loading entirely"})
        public boolean utDisableAdvancementsToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Disable Narrator")
        @Config.Comment(value={"Disables the narrator functionality entirely"})
        public boolean utDisableNarratorToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Disable Text Shadows")
        @Config.Comment(value={"Disables all text shadowing, where text has a darker version of itself rendered behind the normal text, changing the appearance and can improve fps on some screens"})
        public boolean utDisableTextShadow = false;
        @Config.RequiresMcRestart
        @Config.Name(value="End Portal Parallax")
        @Config.Comment(value={"Re-implements parallax rendering of the end portal from 1.10 and older"})
        public boolean utEndPortalParallaxToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Infinite Music")
        @Config.Comment(value={"Lets background music play continuously without delays"})
        public boolean utInfiniteMusicToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="LAN Server Properties")
        @Config.Comment(value={"Enhance the vanilla 'Open to LAN' GUI for listening port customization, removal of enforced authentication and more"})
        public boolean utLANServerProperties = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Better Ping Display")
        @Config.Comment(value={"Displays the ping in milliseconds of players when viewing the server list"})
        public boolean utBetterPing = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Disable Glint Overlay on Potions")
        @Config.Comment(value={"Disables the glint overlay on potions"})
        public boolean utDisablePotionGlint = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Disable Glint Overlay on Enchantment Books")
        @Config.Comment(value={"Disables the glint overlay on enchantment books"})
        public boolean utDisableEnchantmentBookGlint = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Disable Hotbar Scroll Wrapping")
        @Config.Comment(value={"Disables using the scroll wheel to change hotbar slots wrapping"})
        public boolean utDisableHotbarScrollWrapping = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Prevent Keybinds from Overflowing Screen")
        @Config.Comment(value={"Always indent keybind entries from the screen edge, preventing them from overflowing off the left side when particularly long keybind names are present"})
        public boolean utPreventKeybindingEntryOverflow = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Linear XP Amount")
        @Config.Comment(value={"Sets the amount of XP needed for each level, effectively removing the increasing level scaling", "0 for vanilla default"})
        public int utLinearXP = 0;
        @Config.RequiresMcRestart
        @Config.Name(value="More Banner Layers")
        @Config.Comment(value={"Sets the amount of applicable pattern layers for banners", "6 for vanilla default"})
        public int utBannerLayers = 6;
        @Config.RequiresMcRestart
        @Config.Name(value="No Night Vision Flash")
        @Config.Comment(value={"Disables the flashing effect when the night vision potion effect is about to run out"})
        public boolean utNightVisionFlashToggle = false;
        @Config.Name(value="No Potion Shift")
        @Config.Comment(value={"Disables the inventory shift when potion effects are active"})
        public boolean utPotionShiftToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Hide Personal Effect Particles")
        @Config.Comment(value={"Disables potion effect particles emitting from yourself"})
        public boolean utPoVEffectParticles = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Particle Limit")
        @Config.Comment(value={"Limits particles to a set amount. Should not be set too low, as it will cause particles to appear for a single tick before vanishing", "Vanilla default is 16384", "Less than or equal to 0 is set to the default"})
        public int utParticleLimit = -1;
        @Config.RequiresMcRestart
        @Config.Name(value="No Smelting XP")
        @Config.Comment(value={"Disables the experience reward when smelting items in furnaces"})
        public boolean utSmeltingXPToggle = false;
        @Config.Name(value="Offhand Improvement")
        @Config.Comment(value={"Prevents placing offhand blocks when blocks or food are held in the mainhand"})
        public boolean utOffhandToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Overlay Message Height")
        @Config.Comment(value={"Sets the Y value of the overlay message (action bar), displayed for playing records etc.", "-4 for vanilla default"})
        public int utOverlayMessageHeight = -4;
        @Config.RequiresMcRestart
        @Config.Name(value="Remove 3D Anaglyph Button")
        @Config.Comment(value={"Removes the 3D Anaglyph button from the video settings menu", "Incompatible with OptiFine"})
        public boolean ut3DAnaglyphButtonToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Remove Realms Button")
        @Config.Comment(value={"Removes the redundant Minecraft Realms button from the main menu and silences notifications", "Incompatible with RandomPatches"})
        public boolean utRealmsButtonToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Remove Recipe Book")
        @Config.Comment(value={"Removes the recipe book button from GUIs"})
        public boolean utRecipeBookToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Remove Snooper")
        @Config.Comment(value={"Forcefully turns off the snooper and hides the snooper settings button from the options menu"})
        public boolean utSnooperToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Selected Item Tooltip Height")
        @Config.Comment(value={"Sets the Y value of the selected item tooltip, displayed when held items are changed", "59 for vanilla default"})
        public int utSelectedItemTooltipHeight = 59;
        @Config.RequiresMcRestart
        @Config.Name(value="Skip Credits")
        @Config.Comment(value={"Skips the credits screen after the player goes through the end podium portal"})
        public boolean utSkipCreditsToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Skip Missing Registry Entries Screen")
        @Config.Comment(value={"Automatically confirms the 'Missing Registry Entries' screen on world load", "Identical to the launch parameter `-Dfml.queryResult=confirm`"})
        public boolean utSkipRegistryScreenToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Use Separate Dismount Key")
        @Config.Comment(value={"Makes the dismount keybind separate from LSHIFT, allowing it to be rebound independently"})
        public boolean utUseSeparateDismountKey = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Use Separate Narrator Key")
        @Config.Comment(value={"Allows using a custom Narrator key, instead of being stuck with CTRL+B"})
        public boolean utUseCustomNarratorKeybind = false;
        @Config.Name(value="Toggle Cheats Button")
        @Config.Comment(value={"Adds a button to the pause menu to toggle cheats"})
        public boolean utToggleCheatsToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="XP Level Cap")
        @Config.Comment(value={"Sets the maximum experience level players can reach", "0 to effectively disable gaining of experience", "-1 for vanilla default"})
        public int utXPLevelCap = -1;

        public static class ToastControlCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Toast Control Toggle")
            @Config.Comment(value={"Enables the control of toasts (pop-up text boxes)"})
            public boolean utToastControlToggle = true;
            @Config.Name(value="[2] Disable Advancement Toasts")
            @Config.Comment(value={"Determines if advancement toasts are blocked. Enabling will block ALL advancements."})
            public boolean utToastControlAdvancementsToggle = false;
            @Config.Name(value="[3] Disable Recipe Toasts")
            @Config.Comment(value={"Determines if recipe unlock toasts are blocked. Blocks \"you have unlocked a new recipe\" toasts."})
            public boolean utToastControlRecipesToggle = true;
            @Config.Name(value="[4] Disable System Toasts")
            @Config.Comment(value={"Determines if system toasts are blocked. This is used only for the narrator toggle notification right now."})
            public boolean utToastControlSystemToggle = true;
            @Config.RequiresMcRestart
            @Config.Name(value="[5] Disable Tutorial Toasts")
            @Config.Comment(value={"Determines if tutorial toasts are blocked. Blocks useless things like use WASD to move."})
            public boolean utToastControlTutorialToggle = true;
            @Config.Name(value="[6] Toast Control List")
            @Config.Comment(value={"List of class names of Toasts to prevent displaying", "Behavior depends on the list mode", "Syntax: full class name"})
            public String[] utToastControlClassList = new String[0];
            @Config.Name(value="[7] List Mode")
            @Config.Comment(value={"Blacklist Mode: Toast classes which can't be added to the queue, others can", "Whitelist Mode: Toast classes which can be added to the queue, others can't"})
            public EnumLists utToastControlClassListMode = EnumLists.BLACKLIST;
            @Config.Name(value="[8] Debug Logging")
            @Config.Comment(value={"Enables debug logging to log class names of displayed toasts to the log"})
            public boolean utToastNameLogging = false;
            @Config.Name(value="[9] Clear Toast Keybind")
            @Config.Comment(value={"Enables a keybind (default: CTRL+0) to clear all active toasts"})
            public boolean utClearToastKeybind = true;
        }

        public static class TimeoutsCategory {
            @Config.Name(value="[1] Connection Timeouts Toggle")
            @Config.Comment(value={"Allows configuring read/login timeouts.", "If you are having trouble logging into a server of a large modpack, try changing the timeouts below."})
            public boolean utTimeoutsToggle = true;
            @Config.Name(value="[2] Read Timeout")
            @Config.Comment(value={"The connection read timeout in seconds.", "This value is used on both client and server.", "On the server, also extends the time allowed to respond to a KeepAlive packet."})
            public int utReadTimeout = 90;
            @Config.Name(value="[3] Login Timeout")
            @Config.Comment(value={"The login timeout in seconds. (Vanilla default: 600 ticks, or 30 secs)", "Only used on the server."})
            public int utLoginTimeout = 90;
        }

        public static class SwingThroughGrassCategory {
            @Config.Name(value="[1] Swing Through Grass Toggle")
            @Config.Comment(value={"Allows hitting entities through grass instead of breaking it"})
            public boolean utSwingThroughGrassToggle = true;
            @Config.Name(value="[2] Blacklist")
            @Config.Comment(value={"Excludes blocks from the swing through grass tweak", "Syntax: modid:block"})
            public String[] utSwingThroughGrassBlacklist = new String[0];
            @Config.Name(value="[3] Whitelist")
            @Config.Comment(value={"Includes blocks in the swing through grass tweak", "Syntax: modid:block"})
            public String[] utSwingThroughGrassWhitelist = new String[0];
            @Config.Name(value="[4] Item Blacklist")
            @Config.Comment(value={"Excludes items from the swing through grass tweak", "Syntax: modid:item"})
            public String[] utSwingThroughGrassItemBlacklist = new String[]{"erebus:wand_of_animation"};
        }

        public static class SmoothScrollingCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Smooth Scrolling Toggle")
            @Config.Comment(value={"Adds smooth scrolling to in-game lists"})
            public boolean utSmoothScrollingToggle = true;
            @Config.Name(value="[2] Bounce Back Multiplier")
            public double utSmoothScrollingBounce = 0.24;
            @Config.Name(value="[3] Scroll Duration")
            public int utSmoothScrollingDuration = 600;
            @Config.Name(value="[4] Scroll Step")
            public double utSmoothScrollingStep = 19.0;
        }

        public static class PickupNotificationCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[01] Pickup Notification Toggle")
            @Config.Comment(value={"Displays notifications when the player obtains or loses items"})
            public boolean utPickupNotificationToggle = false;
            @Config.Name(value="[02] Display Item Additions")
            @Config.Comment(value={"Displays item additions when a player obtains an item"})
            public boolean utPUNItemAdditions = true;
            @Config.Name(value="[03] Display Item Removals")
            @Config.Comment(value={"Displays item removals when a player loses an item"})
            public boolean utPUNItemRemovals = true;
            @Config.Name(value="[04] Display Experience")
            @Config.Comment(value={"Displays changes in player experience"})
            public boolean utPUNExperience = true;
            @Config.Name(value="[05] Display Icon")
            @Config.Comment(value={"Displays the icon of the respective item"})
            public boolean utPUNDisplayIcon = true;
            @Config.Name(value="[06] Display Name")
            @Config.Comment(value={"Displays the name of the respective item"})
            public boolean utPUNDisplayName = true;
            @Config.Name(value="[07] Display Background")
            @Config.Comment(value={"Displays a dark rectangle behind changed items"})
            public boolean utPUNDisplayBackground = false;
            @Config.Name(value="[08] Display Offset Horizontal")
            @Config.Comment(value={"Sets the horizontal offset of the notification"})
            public int utPUNOffsetHorizontal = 0;
            @Config.Name(value="[09] Display Offset Vertical")
            @Config.Comment(value={"Sets the vertical offset of the notification"})
            public int utPUNOffsetVertical = 18;
            @Config.Name(value="[10] Snap Position")
            @Config.Comment(value={"Sets the edge/corner of the screen to use as the base location"})
            public EnumDrawPosition utPUNSnapPosition = EnumDrawPosition.BOTTOM_RIGHT;
            @Config.Name(value="[11] Name Scale")
            @Config.Comment(value={"Sets the scaling of item names"})
            public double utPUNScaleName = 0.8;
            @Config.Name(value="[12] Icon Scale")
            @Config.Comment(value={"Sets the scaling of item icons"})
            public double utPUNScaleIcon = 0.8;
            @Config.Name(value="[13] Soft Limit")
            @Config.Comment(value={"Sets the maximum number of items in the queue before they start fading out artificially"})
            public int utPUNSoftLimit = 6;
            @Config.Name(value="[14] Fade Limit")
            @Config.Comment(value={"Sets the number of items that will be faded out after the soft limit is reached"})
            public int utPUNFadeLimit = 3;
            @Config.Name(value="[15] Display Duration")
            @Config.Comment(value={"Sets the duration in ticks how long the notification will be displayed"})
            public int utPUNDisplayDuration = 120;
            @Config.Name(value="[16] Fade Duration")
            @Config.Comment(value={"Sets the duration in ticks how long the notification fades out"})
            public int utPUNFadeDuration = 20;
            @Config.Name(value="[17] Blacklist: Ignore Item Changes")
            @Config.Comment(value={"List of item registry names to ignore when displaying changes", "Syntax: modid:item"})
            public String[] utPUNBlacklistItem = new String[0];
            @Config.Name(value="[18] Blacklist: Ignore Subitem Changes")
            @Config.Comment(value={"List of item registry names for which to ignore subitem changes", "Syntax: modid:item"})
            public String[] utPUNBlacklistSubitem = new String[0];

            public static enum EnumDrawPosition {
                BOTTOM_RIGHT,
                BOTTOM,
                BOTTOM_LEFT,
                LEFT,
                TOP_LEFT,
                TOP,
                TOP_RIGHT,
                RIGHT,
                CENTER;

            }
        }

        public static class LoadSoundsCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Mode")
            @Config.Comment(value={"Play load sound on..."})
            public EnumSoundModes utLoadSoundMode = EnumSoundModes.NOTHING;
            @Config.Name(value="[2] Minecraft Loaded Sounds")
            @Config.Comment(value={"Sounds to play when Minecraft is loaded", "Syntax: eventname;pitch;volume"})
            public String[] utLoadSoundMC = new String[]{"entity.experience_orb.pickup;1.0;1.0", "entity.player.levelup;1.0;1.0"};
            @Config.Name(value="[3] World Loaded Sounds")
            @Config.Comment(value={"Sounds to play when the world is loaded", "Syntax: eventname;pitch;volume"})
            public String[] utLoadSoundWorld = new String[]{"entity.experience_orb.pickup;1.0;1.0", "entity.player.levelup;1.0;1.0"};

            public static enum EnumSoundModes {
                NOTHING,
                MINECRAFT,
                WORLD,
                MINECRAFT_AND_WORLD;

            }
        }

        public static class LightningCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Lightning Damage")
            @Config.Comment(value={"Sets the damage lightning bolts deal to entities"})
            public double utLightningDamage = 5.0;
            @Config.RequiresMcRestart
            @Config.Name(value="Lightning Fire Ticks")
            @Config.Comment(value={"Sets the duration in ticks lightning bolts set entities on fire"})
            public int utLightningFireTicks = 8;
            @Config.RequiresMcRestart
            @Config.Name(value="No Lightning Fire")
            @Config.Comment(value={"Disables the creation of fire around lightning strikes"})
            public boolean utLightningFireToggle = false;
            @Config.RequiresMcRestart
            @Config.Name(value="No Lightning Flash")
            @Config.Comment(value={"Disables the flashing of skybox and ground brightness on lightning bolt strikes"})
            public boolean utLightningFlashToggle = false;
            @Config.RequiresMcRestart
            @Config.Name(value="No Lightning Item Destruction")
            @Config.Comment(value={"Prevents lightning bolts from destroying items"})
            public boolean utLightningItemDestructionToggle = false;
        }

        public static class IncurablePotionsCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Incurable Potions Toggle")
            @Config.Comment(value={"Determines if potion effects are curable with curative items like buckets of milk"})
            public boolean utIncurablePotionsToggle = true;
            @Config.Name(value="[2] Potion Effect List")
            @Config.Comment(value={"Syntax: modid:potioneffect"})
            public String[] utIncurablePotionsList = new String[0];
            @Config.Name(value="[3] List Mode")
            @Config.Comment(value={"Blacklist Mode: Potion effects incurable by curative items, others are curable", "Whitelist Mode: Potion effects curable by curative items, others are incurable"})
            public EnumLists utIncurablePotionsListMode = EnumLists.BLACKLIST;
        }

        public static class ChatCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Chat Lines")
            @Config.Comment(value={"Sets the maximum number of chat lines to display", "100 is the vanilla default", "0 or less functionally disables the chat"})
            public int utChatLines = 100;
            @Config.RequiresMcRestart
            @Config.Name(value="[2] Keep Sent Messages")
            @Config.Comment(value={"Don't clear sent message history on leaving the world"})
            public boolean utKeepSentMessageHistory = false;
            @Config.RequiresMcRestart
            @Config.Name(value="[3] Compact Messages")
            @Config.Comment(value={"Removes duplicate messages and instead put a number behind the message how often it was repeated"})
            public boolean utCompactMessagesToggle = false;
        }

        public static class ArmorCurveCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Armor Curve Toggle")
            @Config.Comment(value={"Adjusts the armor scaling and degradation formulae for mobs and players"})
            public boolean utArmorCurveToggle = false;
            @Config.Name(value="[2] Armor Damage Reduction Formula")
            @Config.Comment(value={"Configure how much armor does against damage", "Valid values are 'armor', 'damage', and 'toughness'", "Set to 1 to not modify damage at this step"})
            public String utArmorCurveArmor = "damage-(damage>(40/(toughness+1)))*((40/(toughness+1)))/2";
            @Config.Name(value="[3] Armor Toughness Damage Reduction Formula")
            @Config.Comment(value={"Configure sudden death protection for armor toughness", "Valid values are 'armor', 'damage', and 'toughness'", "Set to 1 to not modify damage at this step"})
            public String utArmorCurveArmorToughness = "damage*MAX(10/(10+armor),0.2)";
            @Config.Name(value="[4] Enchantment Damage Reduction Formula")
            @Config.Comment(value={"Configure the efficiency of protection enchantments", "Valid values are 'enchant' and 'damage'", "Set to 1 to not modify damage at this step"})
            public String utArmorCurveEnchantments = "damage*10/(10+enchant)";
            @Config.Name(value="[5] Armor Degradation Formula")
            @Config.Comment(value={"Configure how armor degrades", "Valid values are 'remaining' and 'max'", "Set to 1 to disable"})
            public String utArmorCurveDegradation = "remaining/MAX(max,1)";
            @Config.Name(value="[6] Debug Logging")
            @Config.Comment(value={"Enables debug logging for easier config validation"})
            public boolean utArmorCurveLogging = false;
        }

        public static class AdvancementsCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[01] Advancements Toggle")
            @Config.Comment(value={"Enables Advancement GUI Tweaks"})
            public boolean utAdvancementsToggle = false;
            @Config.Name(value="[02] Size Toggle")
            @Config.Comment(value={"Enables the Vertical and Horizontal Margin settings"})
            public boolean utSizeToggle = true;
            @Config.Name(value="[03] Vertical Margin")
            @Config.Comment(value={"Sets the minimum Vertical Margin of the Advancement GUI. Too high a number may cause the advancement box to render incorrectly, depending on screen size and GUI scale"})
            public int utVerticalMargin = 50;
            @Config.Name(value="[04] Horizontal Margin")
            @Config.Comment(value={"Sets the minimum Horizontal Margin of the Advancement GUI. Too high a number may cause the advancement box to render incorrectly, depending on screen size and GUI scale"})
            public int utHorizontalMargin = 50;
            @Config.Name(value="[05] Move Arrow Buttons")
            @Config.Comment(value={"Move the Arrow Buttons visible to change focused advancement page from above the advancement box to in the empty top corners, preventing them from going offscreen and being unusable on most vertical margin settings"})
            public boolean utMoveArrowButtons = true;
            @Config.Name(value="[06] Hide Page Header")
            @Config.Comment(value={"Hides the page number header, as it will go offscreen and be unusable on most vertical margin settings, and is rarely needed due to the increased page size"})
            public boolean utHidePageHeader = false;
            @Config.Name(value="[07] Hide Invalid Arrow Buttons")
            @Config.Comment(value={"Hides page switching buttons when at the maximum/minimum page count"})
            public boolean utHideInvalidArrowButtons = true;
            @Config.Name(value="[08] Disable Background Fade on Hover")
            @Config.Comment(value={"Disables the background fading when hovering over an advancement"})
            public boolean utDisableFadeOnHover = true;
            @Config.Name(value="[09] Add Advancement Tab Title to Header")
            @Config.Comment(value={"Makes the focused Advancement Tab Title be added to the header, which otherwise is just 'Advancements' for every tab"})
            public boolean utAddFocusedTabTitleToHeader = true;
        }
    }

    public static class ItemsCategory {
        @Config.LangKey(value="cfg.universaltweaks.tweaks.items.attackcooldown")
        @Config.Name(value="Attack Cooldown")
        public final AttackCooldownCategory ATTACK_COOLDOWN = new AttackCooldownCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.items.infinity")
        @Config.Name(value="Mending")
        public final InfinityCategory INFINITY = new InfinityCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.items.itementities")
        @Config.Name(value="Item Entities")
        public final ItemEntitiesCategory ITEM_ENTITIES = new ItemEntitiesCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.items.mending")
        @Config.Name(value="Mending")
        public final MendingCategory MENDING = new MendingCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.items.parry")
        @Config.Name(value="Shield Parry")
        public final ParryCategory PARRY = new ParryCategory();
        @Config.Name(value="Always Eat")
        @Config.Comment(value={"Allows the consumption of food at any time, regardless of the hunger bar"})
        public boolean utAlwaysEatToggle = false;
        @Config.Name(value="Auto Switch Tools")
        @Config.Comment(value={"Switches the selected hotbar slot to a proper tool if required"})
        public boolean utAutoSwitchToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="No Crafting Repair")
        @Config.Comment(value={"Disables crafting recipes for repairing tools"})
        public boolean utCraftingRepairToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Hardcore Buckets")
        @Config.Comment(value={"Prevents placing of liquid source blocks in the world"})
        public boolean utHardcoreBucketsToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Prevent Placing Buckets in Portals")
        @Config.Comment(value={"Prevents placing of liquid source blocks overriding portal blocks"})
        public boolean utPreventBucketPlacingInPortal = false;
        @Config.RequiresMcRestart
        @Config.Name(value="No Leftover Breath Bottles")
        @Config.Comment(value={"Disables dragon's breath from being a container item and leaving off empty bottles when a stack is brewed with"})
        public boolean utLeftoverBreathBottleToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Glass Bottle Consumes Water Source")
        @Config.Comment(value={"Causes Glass Bottles to consume the source block of water"})
        public boolean utGlassBottlesConsumeWaterSource = false;
        @Config.Name(value="Custom Rarity")
        @Config.Comment(value={"Sets custom rarities for items, affecting tooltip colors", "Syntax: modid:item:meta;rarity", "'meta' is optional and defaults to 0", "Available rarities: common, uncommon, rare, epic", "Example -> minecraft:diamond;rare"})
        public String[] utCustomRarities = new String[]{"minecraft:dragon_breath;uncommon", "minecraft:elytra;uncommon", "minecraft:experience_bottle;uncommon", "minecraft:nether_star;uncommon", "minecraft:skull:0;uncommon", "minecraft:skull:1;uncommon", "minecraft:skull:2;uncommon", "minecraft:skull:3;uncommon", "minecraft:skull:4;uncommon", "minecraft:skull:5;uncommon", "minecraft:totem_of_undying;uncommon", "minecraft:beacon;rare", "minecraft:end_crystal;rare", "minecraft:barrier;epic", "minecraft:chain_command_block;epic", "minecraft:command_block;epic", "minecraft:command_block_minecart;epic", "minecraft:dragon_egg;epic", "minecraft:knowledge_book;epic", "minecraft:repeating_command_block;epic", "minecraft:structure_block;epic", "minecraft:structure_void;epic", "thaumcraft:thaumium_axe;uncommon", "thaumcraft:thaumium_hoe;uncommon", "thaumcraft:thaumium_pick;uncommon", "thaumcraft:thaumium_shovel;uncommon", "thaumcraft:thaumium_sword;uncommon", "thaumcraft:void_axe;uncommon", "thaumcraft:void_hoe;uncommon", "thaumcraft:void_pick;uncommon", "thaumcraft:void_shovel;uncommon", "thaumcraft:void_sword;uncommon", "thaumcraft:primal_crusher;epic"};
        @Config.RequiresMcRestart
        @Config.Name(value="Custom Use Duration")
        @Config.Comment(value={"Sets custom use durations for items like shields, affecting the maximum block time", "Syntax: modid:item:meta;duration;cooldown", "'meta' and 'cooldown' are optional and default to 0, 'duration' and 'cooldown' in ticks", "Examples -> minecraft:shield;69", "         -> custommod:customshield:1;42;69"})
        public String[] utCustomUseDurations = new String[0];
        @Config.RequiresMcRestart
        @Config.Name(value="Smart Eat")
        @Config.Comment(value={"Requires the hunger bar to be missing food points equal to or more than the amount restored by the food"})
        public boolean utSmartEatToggle = false;
        @Config.Name(value="Super Hot Torch")
        @Config.Comment(value={"Enables one-time ignition of entities by hitting them with a torch"})
        public boolean utSuperHotTorchToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="XP Bottle Amount")
        @Config.Comment(value={"Sets the amount of experience spawned by bottles o' enchanting", "-1 for vanilla default"})
        public int utXPBottleAmount = -1;
        @Config.RequiresMcRestart
        @Config.Name(value="Prevent Mob Eggs from Changing Spawners")
        @Config.Comment(value={"Prevents using Mob Spawner Eggs to change what a Spawner is spawning"})
        public boolean utPreventMobEggsFromChangingSpawner = false;

        public static class ParryCategory {
            @Config.Name(value="[01] Shield Parry Toggle")
            @Config.Comment(value={"Allows parrying of projectiles with shields"})
            public boolean utParryToggle = false;
            @Config.Name(value="[02] Arrow Time Window")
            @Config.Comment(value={"Determines the amount of time an arrow can be parried after raising the shield", "Measured in ticks"})
            public int utParryArrowTimeWindow = 40;
            @Config.Name(value="[03] Fireball Time Window")
            @Config.Comment(value={"Determines the amount of time a fireball can be parried after raising the shield", "Measured in ticks"})
            public int utParryFireballTimeWindow = 40;
            @Config.Name(value="[04] Throwable Time Window")
            @Config.Comment(value={"Determines the amount of time a throwable can be parried after raising the shield", "Measured in ticks"})
            public int utParryThrowableTimeWindow = 40;
            @Config.Name(value="[05] Projectile List")
            @Config.Comment(value={"Syntax:  modid:entity", "Example: minecraft:arrow"})
            public String[] utParryProjectileList = new String[0];
            @Config.Name(value="[06] List Mode")
            @Config.Comment(value={"Blacklist Mode: Projectiles which can't be parried, others can be parried", "Whitelist Mode: Projectiles which can be parried, others can't be parried"})
            public EnumLists utParryProjectileListMode = EnumLists.BLACKLIST;
            @Config.Name(value="[07] Indication Sound")
            @Config.Comment(value={"Plays an indication sound effect when projectiles are parried"})
            public boolean utParrySound = false;
            @Config.Name(value="[08] Rebound Enchantment")
            @Config.Comment(value={"Adds the Rebound enchantment for extended parry time windows"})
            public boolean utParryReboundToggle = true;
            @Config.Name(value="[09] Rebound Treasure Enchantment")
            @Config.Comment(value={"Makes the Rebound enchantment exclusive to enchanted books as loot"})
            public boolean utParryReboundTreasure = false;
            @Config.Name(value="[10] Rebound Max Level")
            @Config.Comment(value={"Maximum enchantment level for the Rebound enchantment"})
            public int utParryReboundMaxLevel = 5;
            @Config.Name(value="[11] Rebound Multiplier")
            @Config.Comment(value={"Multiplier for the parry time windows"})
            public double utParryReboundMultiplier = 0.25;
            @Config.Name(value="[12] Require Rebound Enchantment")
            @Config.Comment(value={"Requires the rebound enchantment for parrying"})
            public boolean utParryReboundRequire = false;
        }

        public static class MendingCategory {
            @Config.Name(value="[1] Mending Toggle")
            @Config.Comment(value={"Implements modern mending behavior to only repair damaged equipment with XP"})
            public boolean utMendingToggle = true;
            @Config.Name(value="[2] Ratio")
            @Config.Comment(value={"Determines the amount of durability mending will repair, on average, per point of experience"})
            public double utMendingRatio = 2.0;
            @Config.Name(value="[3] Overpowered")
            @Config.Comment(value={"Repairs damaged items from the entire inventory with XP"})
            public boolean utMendingOPToggle = false;
        }

        public static class ItemEntitiesCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[01] Item Entities Toggle")
            @Config.Comment(value={"Enables the modification of item entity properties"})
            public boolean utItemEntitiesToggle = true;
            @Config.Name(value="[02] Physics")
            @Config.Comment(value={"Adds physical aspects such as collision boxes to item entities"})
            public boolean utIEPhysicsToggle = false;
            @Config.Name(value="[03] Automatic Pickup")
            @Config.Comment(value={"Item entities can be picked up automatically", "When disabled, item entities can be picked up by right-clicking (requires 'Physics' option)"})
            public boolean utIEAutomaticPickupToggle = true;
            @Config.Name(value="[04] Sneaking Pickup")
            @Config.Comment(value={"Item entities can only be picked up when sneaking"})
            public boolean utIESneakingPickupToggle = false;
            @Config.Name(value="[05] Collection Tool")
            @Config.Comment(value={"Tools which enable picking up items automatically", "Example -> minecraft:bucket"})
            public String[] utIECollectionTools = new String[0];
            @Config.Name(value="[06] Pickup Delay")
            @Config.Comment(value={"Determines the delay in ticks until item entities can be picked up", "-1 for vanilla default"})
            public int utIEPickupDelay = -1;
            @Config.Name(value="[07] Lifespan")
            @Config.Comment(value={"Determines the time in ticks until item entities get despawned", "-1 for vanilla default"})
            public int utIELifespan = -1;
            @Config.Name(value="[08] No Combination")
            @Config.Comment(value={"Stops combination of item entities"})
            public boolean utIENoCombinationToggle = false;
            @Config.Name(value="[09] Smart Combination")
            @Config.Comment(value={"Stops combination of item entities if their maximum stack size is reached"})
            public boolean utIESmartCombinationToggle = true;
            @Config.Name(value="[10] Smart Combination Radius")
            @Config.Comment(value={"The radius (in blocks) that dropped items should check around them for other dropped items to combine with", "Depends on the Smart Combination toggle"})
            public double utIESmartCombinationRadius = 2.0;
            @Config.Name(value="[11] Smart Combination Y-Axis Check")
            @Config.Comment(value={"Allows dropped items to also check above and below them for combination", "Depends on the Smart Combination toggle"})
            public boolean utIESmartCombinationYAxis = true;
            @Config.Name(value="[12] Rotation")
            @Config.Comment(value={"Enables the rotation effect"})
            public boolean utIERotationToggle = true;
            @Config.Name(value="[13] Bobbing")
            @Config.Comment(value={"Enables the bobbing effect"})
            public boolean utIEBobbingToggle = true;
            @Config.Name(value="[14] Clear Despawn")
            @Config.Comment(value={"Makes item entities flash when they're about to despawn"})
            public boolean utIEClearDespawnToggle = false;
            @Config.Name(value="[15] Clear Despawn: Flashing Time")
            @Config.Comment(value={"Determines the time in seconds item entities have left before despawn to start flashing"})
            public int utIEClearDespawnTime = 20;
            @Config.Name(value="[16] Clear Despawn: Urgent Flashing")
            @Config.Comment(value={"Makes item entities flash faster as they get closer to despawning"})
            public boolean utIEClearDespawnUrgentToggle = true;
            @Config.Name(value="[17] Slowed Movement")
            @Config.Comment(value={"Slows how often item entities update their position to improve performance"})
            public boolean utIEUpdateToggle = false;
        }

        public static class InfinityCategory {
            @Config.Name(value="[1] Arrowless Infinity")
            @Config.Comment(value={"Bows enchanted with Infinity no longer require arrows"})
            public boolean utBowInfinityToggle = true;
            @Config.Name(value="[2] Infinity Conflict")
            @Config.Comment(value={"Allows the Infinity Enchantment to be combined with Mending"})
            public boolean utInfinityEnchantmentConflicts = false;
            @Config.Name(value="[3] Infinity Affects All Arrows")
            @Config.Comment(value={"Allows the Infinity Enchantment to apply to all arrows (e.g. Tipped Arrows)"})
            public boolean utAllArrowsAreInfinite = false;
        }

        public static class AttackCooldownCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] No Attack Cooldown Toggle")
            @Config.Comment(value={"Disables the 1.9 combat update attack cooldown"})
            public boolean utAttackCooldownToggle = false;
            @Config.Name(value="[2] Only Affect Swords")
            @Config.Comment(value={"Only removes the attack cooldown of swords to balance other weapons like axes"})
            public boolean utAttackCooldownSwords = false;
            @Config.Name(value="[3] Hide Attack Speed Tooltip")
            @Config.Comment(value={"Hides attack speed tooltips of weapons"})
            public boolean utAttackCooldownTooltips = true;
        }
    }

    public static class EntitiesCategory {
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.attributes")
        @Config.Name(value="Attributes")
        public final AttributesCategory ATTRIBUTES = new AttributesCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.betterburning")
        @Config.Name(value="Better Burning")
        public final BetterBurningCategory BETTER_BURNING = new BetterBurningCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.chickenshedding")
        @Config.Name(value="Chicken Shedding")
        public final ChickenSheddingCategory CHICKEN_SHEDDING = new ChickenSheddingCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.cobwebslowness")
        @Config.Name(value="Cobweb Slowness")
        public final CobwebSlownessCategory COBWEB_SLOWNESS = new CobwebSlownessCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.creeperconfetti")
        @Config.Name(value="Creeper Confetti")
        public final CreeperConfettiCategory CREEPER_CONFETTI = new CreeperConfettiCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.damagevelocity")
        @Config.Name(value="Damage Velocity")
        public final DamageVelocityCategory DAMAGE_VELOCITY = new DamageVelocityCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.easybreeding")
        @Config.Name(value="Easy Breeding")
        public final EasyBreedingCategory EASY_BREEDING = new EasyBreedingCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.nogolems")
        @Config.Name(value="No Golems")
        public final NoGolemsCategory NO_GOLEMS = new NoGolemsCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.playerspeed")
        @Config.Name(value="Player Speed")
        public final PlayerSpeedCategory PLAYER_SPEED = new PlayerSpeedCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.rallyhealth")
        @Config.Name(value="Rally Health")
        public final RallyHealthCategory RALLY_HEALTH = new RallyHealthCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.sleeping")
        @Config.Name(value="Sleeping")
        public final SleepingCategory SLEEPING = new SleepingCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.spawncaps")
        @Config.Name(value="Spawn Caps")
        public final SpawnCapsCategory SPAWN_CAPS = new SpawnCapsCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.undeadhorses")
        @Config.Name(value="Undead Horses")
        public final UndeadHorsesCategory UNDEAD_HORSES = new UndeadHorsesCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.waterfalldamage")
        @Config.Name(value="Water Fall Damage")
        public final WaterFallDamageCategory WATER_FALL_DAMAGE = new WaterFallDamageCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.voidteleport")
        @Config.Name(value="Void Teleport")
        public final VoidTeleportCategory VOID_TELEPORT = new VoidTeleportCategory();
        @Config.Name(value="Adaptive XP Drops")
        @Config.Comment(value={"Scales dropped experience from entities based on their health", "Formula: max_health * factor", "0 for vanilla default"})
        public double utAdaptiveXPFactor = 0.0;
        @Config.RequiresMcRestart
        @Config.Name(value="AI Replacement")
        @Config.Comment(value={"Replaces entity AI for improved server performance"})
        public boolean utAIReplacementToggle = true;
        @Config.Name(value="AI Removal")
        @Config.Comment(value={"Removes entity AI for improved server performance"})
        public boolean utAIRemovalToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Armed Armor Stands")
        @Config.Comment(value={"Enables arms for armor stands by default"})
        public boolean utArmedArmorStandsToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Auto Jump Replacement")
        @Config.Comment(value={"Replaces auto jump with an increased step height (singleplayer only)"})
        public boolean utAutoJumpToggle = true;
        @Config.Name(value="Better Ignition")
        @Config.Comment(value={"Enables ignition of entities by right-clicking instead of awkwardly lighting the block under them"})
        public boolean utBetterIgnitionToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Boat Speed")
        @Config.Comment(value={"Sets the acceleration value for controlling boats"})
        public double utBoatSpeed = 0.04;
        @Config.Name(value="Burning Baby Zombies")
        @Config.Comment(value={"Lets baby zombies burn in daylight as in Minecraft 1.13+"})
        public boolean utBurningBabyZombiesToggle = true;
        @Config.Name(value="Burning Skeletons")
        @Config.Comment(value={"Lets skeletons burn in daylight"})
        public boolean utBurningSkeletonsToggle = true;
        @Config.Name(value="Burning Zombies")
        @Config.Comment(value={"Lets zombies burn in daylight"})
        public boolean utBurningZombiesToggle = true;
        @Config.Name(value="Creeper Charged Spawning Chance")
        @Config.Comment(value={"Sets the chance for creepers to spawn charged"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double utCreeperChargedChance = 0.0;
        @Config.RequiresMcRestart
        @Config.Name(value="Critical Arrow Damage")
        @Config.Comment(value={"Sets the additional damage that critical arrows deal", "-1 for vanilla random default"})
        public int utCriticalArrowDamage = -1;
        @Config.RequiresMcRestart
        @Config.Name(value="Disable Creeper Music Discs")
        @Config.Comment(value={"Disables creepers dropping music discs when slain by skeletons"})
        public boolean utCreeperMusicDiscsToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Disable Villager Trade Leveling")
        @Config.Comment(value={"Disables leveling of villager careers, only allowing base level trades"})
        public boolean utVillagerTradeLevelingToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Disable Villager Trade Restock")
        @Config.Comment(value={"Disables restocking of villager trades, only allowing one trade per offer"})
        public boolean utVillagerTradeRestockToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Disable Wither Targeting AI")
        @Config.Comment(value={"Disables withers targeting animals"})
        public boolean utWitherAIToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Weaken Wither Structure Requirements")
        @Config.Comment(value={"Allows creating Withers with non-air blocks in the bottom corners of the structure"})
        public boolean utWitherPlacement = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Weaken Golem Structure Requirements")
        @Config.Comment(value={"Allows creating Iron Golems with non-air blocks in the bottom corners of the structure"})
        public boolean utGolemPlacement = false;
        @Config.RequiresMcRestart
        @Config.Name(value="First Person Burning Overlay")
        @Config.Comment(value={"Sets the offset for the fire overlay in first person when the player is burning"})
        public double utFirstPersonBurningOverlay = -0.3;
        @Config.RequiresMcRestart
        @Config.Name(value="Third Person Ignores Non-solid Blocks")
        @Config.Comment(value={"When viewing in third person, don't stop the camera on non-solid blocks"})
        public boolean utThirdPersonIgnoresNonSolidBlocks = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Husk & Stray Spawning")
        @Config.Comment(value={"Lets husks and strays spawn underground like regular zombies and skeletons"})
        public boolean utHuskStraySpawningToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Mob Despawn Improvement")
        @Config.Comment(value={"Mobs carrying picked up items will drop their equipment and despawn properly"})
        public boolean utMobDespawnToggle = true;
        @Config.Name(value="Modern Knockback")
        @Config.Comment(value={"Backports 1.16+ knockback to 1.12: Knockback resistance is now a scale instead of a probability"})
        public boolean utModernKnockbackToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Minecart Drops Itself")
        @Config.Comment(value={"Replaces vanilla Minecarts dropping a Minecart and the contained item, and instead drop the combined item"})
        public boolean utMinecartDropsType = false;
        @Config.RequiresMcRestart
        @Config.Name(value="No Portal Spawning")
        @Config.Comment(value={"Prevents zombie pigmen spawning from nether portals"})
        public boolean utPortalSpawningToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="No Saddled Wandering")
        @Config.Comment(value={"Stops horses wandering around when saddled"})
        public boolean utSaddledWanderingToggle = true;
        @Config.Name(value="Rabbit Killer Spawning Chance")
        @Config.Comment(value={"Sets the chance for rabbits to spawn as the killer bunny variant"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double utRabbitKillerChance = 0.0;
        @Config.Name(value="Rabbit Toast Spawning Chance")
        @Config.Comment(value={"Sets the chance for rabbits to spawn as the Toast variant"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double utRabbitToastChance = 0.0;
        @Config.RequiresMcRestart
        @Config.Name(value="Riding Exhaustion")
        @Config.Comment(value={"Sets the exhaustion value per cm when riding mounts"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double utRidingExhaustion = 0.0;
        @Config.RequiresMcRestart
        @Config.Name(value="Soulbound Vexes")
        @Config.Comment(value={"Summoned vexes will also die when their summoner is killed"})
        public boolean utSoulboundVexesToggle = true;

        public static class VoidTeleportCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[01] Void Teleport Toggle")
            @Config.Comment(value={"Enables Void Teleport, where falling out below a dimension will teleport you to the top of the dimension"})
            public boolean utVoidTeleportToggle = false;
            @Config.Name(value="[02] Prevent Void Damage")
            @Config.Comment(value={"Prevents taking a tick of void damage before being teleported", "If this is false, entities will take 4 damage every time Void Teleport activates, preventing infinite looping"})
            public boolean utPreventVoidDamage = true;
            @Config.Name(value="[03] Target Y-Level")
            @Config.Comment(value={"Y-level to teleport the entity", "If the target Y-level is lower than the highest block in that coordinate, will teleport the entity to the highest location instead"})
            public int utTargetYLevel = 300;
            @Config.Name(value="[04] Apply Blindness on Teleport")
            @Config.Comment(value={"Applies the blindness effect for 3 seconds when teleporting"})
            public boolean utTeleportBlindness = true;
            @Config.Name(value="[05] Clamp Falling Speed")
            @Config.Comment(value={"Prevents Y motion from being less than this"})
            public double utClampSpeedTo = -1.0;
            @Config.Name(value="[06] Fall Distance Height")
            @Config.Comment(value={"Height to override the fallDistance variable with when landing after having teleported", "When set to less than 0, [07] Fall Damage Taken applies instead"})
            public float utFallHeight = -1.0f;
            @Config.Name(value="[07] Fall Damage Taken")
            @Config.Comment(value={"Amount of fall damage taken when landing on a block", "Negative numbers deal damage relative to the entity's max health", "Only applies if [06] Fall Distance Height is less than 0"})
            public float utFallDamageTaken = -1.0f;
            @Config.Name(value="[08] Allow Fall Damage Taken to Kill")
            @Config.Comment(value={"Sets if [07] Fall Damage Taken can kill entities", "Does not apply to fall damage taken due to [06] Fall Distance Height"})
            public boolean utAllowSpecificFallDamageToKill = true;
            @Config.Name(value="[09] Maximum Times to Teleport Consecutively")
            @Config.Comment(value={"Maximum number of times to teleport the entity without the entity landing before no longer teleporting. Used to prevent infinite loops"})
            public int utMaxCombo = 100;
            @Config.Name(value="[10] Apply Void Teleport to Players")
            @Config.Comment(value={"Controls if players are teleported by Void Teleport"})
            public boolean utForgivePlayers = true;
            @Config.Name(value="[11] Entity List")
            @Config.Comment(value={"List of the resource location names for entities concerning Void Teleport", "Behavior depends on the list mode"})
            public String[] utEntityList = new String[0];
            @Config.Name(value="[12] Entity List Mode")
            @Config.Comment(value={"Blacklist Mode: Entities that won't be impacted by Void Teleport, others will", "Whitelist Mode: Entities that will be impacted by Void Teleport, others won't"})
            public EnumLists utEntityListMode = EnumLists.WHITELIST;
            @Config.Name(value="[13] Dimension List")
            @Config.Comment(value={"List of dimensions concerning Void Teleport", "Behavior depends on the list mode", "Can be dimension name or ID"})
            public String[] utDimensionList = new String[0];
            @Config.Name(value="[14] Dimension List Mode")
            @Config.Comment(value={"Blacklist Mode: Dimensions that don't have Void Teleport enabled, others do", "Whitelist Mode: Dimensions that have Void Teleport enabled, others don't"})
            public EnumLists utDimensionListMode = EnumLists.BLACKLIST;
        }

        public static class WaterFallDamageCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Water Fall Damage Toggle")
            @Config.Comment(value={"Re-implements an improved version of pre-1.4 fall damage in water"})
            public boolean utFallDamageToggle = false;
            @Config.Name(value="[2] Damage Reduction")
            @Config.Comment(value={"How much fall damage gets reduced by water per tick"})
            public double utFallDamageValue = 2.0;
        }

        public static class UndeadHorsesCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="Burning Undead Horses")
            @Config.Comment(value={"Lets untamed undead horses burn in daylight"})
            public boolean utBurningUndeadHorsesToggle = true;
            @Config.RequiresMcRestart
            @Config.Name(value="Taming Undead Horses")
            @Config.Comment(value={"Allows taming of undead horses"})
            public boolean utTamingUndeadHorsesToggle = true;
        }

        public static class SpawnCapsCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Spawn Caps Toggle")
            @Config.Comment(value={"Sets maximum spawning limits for different entity types"})
            public boolean utSpawnCapsToggle = false;
            @Config.RequiresMcRestart
            @Config.Name(value="[2] Monster Cap")
            @Config.Comment(value={"Maximum amount of monsters (IMob)"})
            public int utSpawnCapsMonster = 70;
            @Config.RequiresMcRestart
            @Config.Name(value="[3] Creature Cap")
            @Config.Comment(value={"Maximum amount of creatures (EntityAnimal)"})
            public int utSpawnCapsCreature = 10;
            @Config.RequiresMcRestart
            @Config.Name(value="[4] Ambient Cap")
            @Config.Comment(value={"Maximum amount of ambients (EntityAmbientCreature)"})
            public int utSpawnCapsAmbient = 15;
            @Config.RequiresMcRestart
            @Config.Name(value="[5] Water Creature Cap")
            @Config.Comment(value={"Maximum amount of water creatures (EntityWaterMob)"})
            public int utSpawnCapsWaterCreature = 5;
        }

        public static class SleepingCategory {
            @Config.Name(value="Disable Sleeping")
            @Config.Comment(value={"Disables skipping night by using a bed while making it still able to set spawn"})
            public boolean utDisableSleepingToggle = false;
            @Config.RequiresMcRestart
            @Config.Name(value="Disable Sleeping Setting Spawn")
            @Config.Comment(value={"Disables setting the spawn point by using a bed while making it still able to sleep"})
            public boolean utDisableSettingSpawnToggle = false;
            @Config.Name(value="Sleeping Time")
            @Config.RangeInt(min=-1, max=23999)
            @Config.Comment(value={"Determines at which time of day sleeping is allowed in ticks (0 - 23999)", "-1 for vanilla default"})
            public int utSleepingTime = -1;
        }

        public static class RallyHealthCategory {
            @Config.Name(value="[1] Rally Health Toggle")
            @Config.Comment(value={"Adds Bloodborne's Rally system to Minecraft", "Regain lost health when attacking back within the risk time"})
            public boolean utRallyHealthToggle = false;
            @Config.Name(value="[2] Risk Time")
            @Config.Comment(value={"Determines the risk time in ticks"})
            public int utRallyHealthRiskTime = 60;
            @Config.Name(value="[3] Heal Chance")
            @Config.Comment(value={"Determines the chance to regain health in percent"})
            public int utRallyHealthHealChance = 80;
            @Config.Name(value="[4] Indication Sound")
            @Config.Comment(value={"Plays an indication sound effect when health is regained"})
            public boolean utRallyHealthSound = false;
        }

        public static class PlayerSpeedCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Player Speed Toggle")
            @Config.Comment(value={"Enables the modification of base and maximum player speeds"})
            public boolean utPlayerSpeedToggle = false;
            @Config.Name(value="[2] Walk Speed")
            @Config.Comment(value={"Determines the player's base walk speed"})
            public double utPlayerWalkSpeed = 0.1;
            @Config.Name(value="[3] Fly Speed")
            @Config.Comment(value={"Determines the player's base fly speed"})
            public double utPlayerFlySpeed = 0.05;
            @Config.Name(value="[4] Max Speed")
            @Config.Comment(value={"Determines the player's maximum speed", "Increase if you get the infamous 'Player moved too quickly' messages"})
            public double utPlayerMaxSpeed = 100.0;
            @Config.Name(value="[5] Max Elytra Speed")
            @Config.Comment(value={"Determines the player's maximum speed when flying with elytra", "Increase if you get the infamous 'Player moved too quickly' messages"})
            public double utPlayerMaxElytraSpeed = 300.0;
            @Config.Name(value="[6] Max Vehicle Speed")
            @Config.Comment(value={"Determines the player's maximum speed when riding a vehicle or mount", "Increase if you get the infamous 'Player moved too quickly' messages"})
            public double utPlayerVehicleSpeed = 100.0;
        }

        public static class NoGolemsCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Iron Golem Toggle")
            @Config.Comment(value={"Disables the manual creation of iron golems"})
            public boolean utNGIronGolemToggle = false;
            @Config.RequiresMcRestart
            @Config.Name(value="[2] Snow Golem Toggle")
            @Config.Comment(value={"Disables the manual creation of snow golems"})
            public boolean utNGSnowGolemToggle = false;
            @Config.RequiresMcRestart
            @Config.Name(value="[3] Wither Toggle")
            @Config.Comment(value={"Disables the manual creation of withers"})
            public boolean utNGWitherToggle = false;
        }

        public static class DamageVelocityCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Damage Velocity Toggle")
            @Config.Comment(value={"Enables the modification of damage sources that change the entity's velocity"})
            public boolean utDamageVelocityToggle = false;
            @Config.Name(value="[2] Damage Velocity List")
            @Config.Comment(value={"Syntax: damagetype"})
            public String[] utDamageVelocityList = new String[]{"inFire", "onFire"};
            @Config.Name(value="[3] List Mode")
            @Config.Comment(value={"Blacklist Mode: Damage sources that don't change velocity, others do", "Whitelist Mode: Damage sources that change velocity, others don't"})
            public EnumLists utDamageVelocityListMode = EnumLists.BLACKLIST;
        }

        public static class CreeperConfettiCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Creeper Confetti Chance")
            @Config.Comment(value={"Sets the chance to replace deadly creeper explosions with delightful confetti"})
            @Config.RangeDouble(min=0.0, max=1.0)
            public double utCreeperConfettiChance = 0.0;
            @Config.Name(value="[2] Creeper Confetti Damage")
            @Config.Comment(value={"Sets the damage dealt by confetti explosions"})
            public double utCreeperConfettiDamage = 0.0;
        }

        public static class CobwebSlownessCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Cobweb Slowness Toggle")
            @Config.Comment(value={"Modifies the applied slowness factor when entities are moving in cobwebs"})
            public boolean utCobwebSlownessToggle = false;
            @Config.Name(value="[2] Horizontal Slowness Factor")
            @Config.Comment(value={"The slowness factor that gets multiplied with the horizontal entity speed"})
            public double utCobwebSlownessFactorH = 0.25;
            @Config.Name(value="[3] Vertical Slowness Factor")
            @Config.Comment(value={"The slowness factor that gets multiplied with the vertical entity speed"})
            public double utCobwebSlownessFactorV = 0.05f;
        }

        public static class EasyBreedingCategory {
            @Config.Name(value="[1] Easy Breeding Toggle")
            @Config.Comment(value={"Enables easy breeding of animals by tossing food on the ground"})
            public boolean utEasyBreedingToggle = false;
            @Config.Name(value="[2] Search Distance")
            @Config.Comment(value={"Determines the distance for animals to search for food"})
            public double utEasyBreedingDistance = 10.0;
        }

        public static class ChickenSheddingCategory {
            @Config.Name(value="[1] Chicken Shedding")
            @Config.Comment(value={"Enables chickens to have a chance to shed a feather"})
            public boolean utChickenSheddingToggle = true;
            @Config.Name(value="[2] Shed Frequency")
            @Config.Comment(value={"How frequently feathers shed from chickens (lower means more)"})
            public int utChickenSheddingFrequency = 28000;
            @Config.Name(value="[3] Baby Chickens Shed Feathers")
            @Config.Comment(value={"Allows baby chickens to also shed feathers"})
            public boolean utChickenSheddingBabyToggle = false;
        }

        public static class BetterBurningCategory {
            @Config.Name(value="[1] Cooked Items")
            @Config.Comment(value={"Fixes some edge cases where fire damage sources won't cause mobs to drop their cooked items"})
            public boolean utBBCookedToggle = true;
            @Config.Name(value="[2] Extinguishing")
            @Config.Comment(value={"If entities have fire resistance, they get extinguished right away when on fire"})
            public boolean utBBExtinguishToggle = true;
            @Config.Name(value="[3] Fire Overlay")
            @Config.Comment(value={"Prevents the fire animation overlay from being displayed when the player is immune to fire"})
            public boolean utBBOverlayToggle = true;
            @Config.Name(value="[4] Flaming Arrows")
            @Config.Comment(value={"Allows skeletons to shoot flaming arrows when on fire (30% chance * regional difficulty)"})
            public boolean utBBArrowsToggle = true;
            @Config.Name(value="[5] Spreading Fire")
            @Config.Comment(value={"Allows fire to spread from entity to entity (30% chance * regional difficulty)"})
            public boolean utBBSpreadingToggle = true;
        }

        public static class AttributesCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[01] Attributes Toggle")
            @Config.Comment(value={"Sets custom ranges for entity attributes"})
            public boolean utAttributesToggle = true;
            @Config.Name(value="[02] Max Health Min")
            @Config.RangeDouble(min=0.0)
            public double utAttributeMaxHealthMin = 0.0;
            @Config.Name(value="[03] Max Health Max")
            public double utAttributeMaxHealthMax = 65536.0;
            @Config.Name(value="[04] Follow Range Min")
            @Config.RangeDouble(min=0.0)
            public double utAttributeFollowRangeMin = 0.0;
            @Config.Name(value="[05] Follow Range Max")
            public double utAttributeFollowRangeMax = 65536.0;
            @Config.Name(value="[06] Knockback Resistance Min")
            @Config.RangeDouble(min=0.0)
            public double utAttributeKnockbackResistanceMin = 0.0;
            @Config.Name(value="[07] Knockback Resistance Max")
            public double utAttributeKnockbackResistanceMax = 65536.0;
            @Config.Name(value="[08] Movement Speed Min")
            @Config.RangeDouble(min=0.0)
            public double utAttributeMovementSpeedMin = 0.0;
            @Config.Name(value="[09] Movement Speed Max")
            public double utAttributeMovementSpeedMax = 65536.0;
            @Config.Name(value="[10] Flying Speed Min")
            @Config.RangeDouble(min=0.0)
            public double utAttributeFlyingSpeedMin = 0.0;
            @Config.Name(value="[11] Flying Speed Max")
            public double utAttributeFlyingSpeedMax = 65536.0;
            @Config.Name(value="[12] Attack Damage Min")
            @Config.RangeDouble(min=0.0)
            public double utAttributeAttackDamageMin = 0.0;
            @Config.Name(value="[13] Attack Damage Max")
            public double utAttributeAttackDamageMax = 65536.0;
            @Config.Name(value="[14] Attack Speed Min")
            @Config.RangeDouble(min=0.0)
            public double utAttributeAttackSpeedMin = 0.0;
            @Config.Name(value="[15] Attack Speed Max")
            public double utAttributeAttackSpeedMax = 65536.0;
            @Config.Name(value="[16] Armor Min")
            @Config.RangeDouble(min=0.0)
            public double utAttributeArmorMin = 0.0;
            @Config.Name(value="[17] Armor Max")
            public double utAttributeArmorMax = 65536.0;
            @Config.Name(value="[18] Armor Toughness Min")
            @Config.RangeDouble(min=0.0)
            public double utAttributeArmorToughnessMin = 0.0;
            @Config.Name(value="[19] Armor Toughness Max")
            public double utAttributeArmorToughnessMax = 65536.0;
            @Config.Name(value="[20] Luck Min")
            public double utAttributeLuckMin = -65536.0;
            @Config.Name(value="[21] Luck Max")
            public double utAttributeLuckMax = 65536.0;
        }
    }

    public static class BlocksCategory {
        @Config.LangKey(value="cfg.universaltweaks.tweaks.blocks.betterplacement")
        @Config.Name(value="Better Placement")
        public final BetterPlacementCategory BETTER_PLACEMENT = new BetterPlacementCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.blocks.blockdispenser")
        @Config.Name(value="Block Dispenser")
        public final BlockDispenserCategory BLOCK_DISPENSER = new BlockDispenserCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.blocks.breakablebedrock")
        @Config.Name(value="Breakable Bedrock")
        public final BreakableBedrockCategory BREAKABLE_BEDROCK = new BreakableBedrockCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.blocks.finitewater")
        @Config.Name(value="Finite Water")
        public final FiniteWaterCategory FINITE_WATER = new FiniteWaterCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.blocks.overhaulbeacon")
        @Config.Name(value="Overhaul Beacon")
        public final OverhaulBeaconCategory OVERHAUL_BEACON = new OverhaulBeaconCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.blocks.sapling")
        @Config.Name(value="Sapling Behavior")
        public final SaplingBehaviorCategory SAPLING_BEHAVIOR = new SaplingBehaviorCategory();
        @Config.RequiresMcRestart
        @Config.Name(value="Bed Obstruction Replacement")
        @Config.Comment(value={"Replaces bed obstruction checks with an improved version"})
        public boolean utBedObstructionToggle = true;
        @Config.Name(value="Better Harvest")
        @Config.Comment(value={"Prevents breaking lower parts of sugar cane and cacti as well as unripe crops, unless sneaking"})
        public boolean utBetterHarvestToggle = false;
        @Config.Name(value="Farmland Trample")
        @Config.Comment(value={"Controls when and if farmland can be trampled into dirt", "Default: Farmland is trampled normally (vanilla default)", "Never: Farmland can never be trampled", "Only Player: Prevents farmland from being trampled by a non-EntityPlayer", "Not Player: Prevents farmland from being trampled by an EntityPlayer", "Feather Falling: Prevents farmland from being trampled if the entity has the Feather Falling enchantment on equipped boots"})
        public TrampleOptions utFarmlandTrample = TrampleOptions.DEFAULT;
        @Config.RequiresMcRestart
        @Config.Name(value="Block Hit Delay")
        @Config.Comment(value={"Sets the delay in ticks between breaking blocks"})
        public int utBlockHitDelay = 5;
        @Config.RequiresMcRestart
        @Config.Name(value="Cactus Size")
        @Config.Comment(value={"Determines how tall cacti can grow"})
        public int utCactusSize = 3;
        @Config.RequiresMcRestart
        @Config.Name(value="Explosion Block Drop Chance")
        @Config.Comment(value={"Determines the numerator of the block drop formula on explosions", "Formula: chance \u00f7 explosionSize"})
        public double utExplosionDropChance = 1.0;
        @Config.RequiresMcRestart
        @Config.Name(value="Falling Block Lifespan")
        @Config.Comment(value={"Determines how long falling blocks remain in ticks until they are dropped under normal circumstances"})
        public int utFallingBlockLifespan = 600;
        @Config.RequiresMcRestart
        @Config.Name(value="Improve Barrier Particle Display")
        @Config.Comment(value={"Causes Barrier Particles to always be displayed to players in Creative mode"})
        public boolean utBarrierParticleDisplay = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Prevent Observer Activating on Placement")
        @Config.Comment(value={"Controls if the observer activates itself on the first tick when it is placed"})
        public boolean utPreventObserverActivatesOnPlacement = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Render End Portal Bottom")
        @Config.Comment(value={"Controls if the End Portal renders its texture on the bottom face"})
        public boolean utRenderEndPortalBottom = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Fast Leaf Decay")
        @Config.Comment(value={"Makes leaves decay faster when trees are chopped"})
        public boolean utLeafDecayToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Fence/Wall Jump")
        @Config.Comment(value={"Allows the player to jump over fences and walls"})
        public boolean utFenceWallJumpToggle = true;
        @Config.RequiresMcRestart
        @Config.Name(value="Lenient Paths")
        @Config.Comment(value={"Allows the creation of grass paths everywhere (beneath fence gates, trapdoors, ...)"})
        public boolean utLenientPathsToggle = true;
        @Config.Name(value="Unsupported Pumpkin Placing")
        @Config.Comment(value={"Allows placing Pumpkins and Jack'O'Lanterns without a supporting block"})
        public boolean utUnsupportedPumpkinPlacing = false;
        @Config.RequiresMcRestart
        @Config.Name(value="End Crystal Placing")
        @Config.Comment(value={"Allows placing End Crystals without requiring Obsidian or Bedrock below"})
        public boolean utEndCrystalAnywherePlacing = false;
        @Config.Name(value="Projectiles Bounce Off Slime Blocks")
        @Config.Comment(value={"Lets projectiles like arrows bounce off slime blocks"})
        public boolean utSlimeBlockProjectiles = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Sugar Cane Size")
        @Config.Comment(value={"Determines how tall sugar cane can grow"})
        public int utSugarCaneSize = 3;
        @Config.RequiresMcRestart
        @Config.Name(value="Vine Size")
        @Config.Comment(value={"Determines how long vines can grow", "0 = Infinite (vanilla default)"})
        public int utVineSize = 0;

        public static class SaplingBehaviorCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Sapling Behavior Toggle")
            @Config.Comment(value={"Allows customization of sapling behavior while utilizing an optimized method"})
            public boolean utSaplingBehaviorToggle = true;
            @Config.Name(value="[2] Minimum Light Level")
            @Config.Comment(value={"Inclusive minimum light level at which saplings grow into trees"})
            public int utSaplingLightLevel = 9;
            @Config.Name(value="[3] Growth Chance")
            @Config.Comment(value={"Chance per update tick at which saplings grow into trees", "Note: General growth rate is still affected by the random tick speed"})
            @Config.RangeDouble(min=0.0, max=1.0)
            public double utSaplingGrowthChance = 0.125;
        }

        public static class OverhaulBeaconCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Overhaul Beacon Toggle")
            @Config.Comment(value={"Overhaul beacon construction and range"})
            public boolean utOverhaulBeaconToggle = false;
            @Config.Name(value="[2] Mode")
            @Config.Comment(value={"Modifier: Use per block modifier for range calculation, replacing vanilla implementation", "Enforced: Enforce usage of only 1 beacon base type per level"})
            public EnumBeacon utOverhaulBeaconMode = EnumBeacon.ENFORCED;
            @Config.Name(value="[3] Global Modifier")
            @Config.Comment(value={"Global range for block, change it by modify beacon range config"})
            public double utOverhaulBeaconGlobalModifier = 1.0;
            @Config.Name(value="[4] Level Scaling")
            @Config.Comment(value={"Scaling beacon range per level (1 -> 4)", "Don't try add more value to this scale as this only use first 4 values"})
            public double[] utOverhaulBeaconLevelScale = new double[]{1.0, 0.8, 0.6, 0.4};
            @Config.Name(value="[5] Per Block Modifier")
            @Config.Comment(value={"Block modifier for range calculate, only apply for beacon base block", "Add new one required restart, modify doesn't required so"})
            public Map<String, Double> utOverhaulBeaconBlocksModifier = new HashMap<String, Double>();

            public OverhaulBeaconCategory() {
                this.utOverhaulBeaconBlocksModifier.put("modid:example", 1.0);
            }
        }

        public static class FiniteWaterCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Finite Water Toggle")
            @Config.Comment(value={"Prevents creation of infinite water sources"})
            public boolean utFiniteWaterToggle = false;
            @Config.Name(value="[2] Allow Water Biomes")
            @Config.Comment(value={"Allows creation of infinite water sources in ocean and river biomes"})
            public boolean utFiniteWaterWaterBiomes = true;
            @Config.Name(value="[3] Minimum Altitude")
            @Config.Comment(value={"Inclusive minimum altitude at which water is infinite"})
            public int utFiniteWaterInfMin = 0;
            @Config.Name(value="[4] Maximum Altitude")
            @Config.Comment(value={"Inclusive maximum altitude at which water is infinite"})
            public int utFiniteWaterInfMax = 63;
        }

        public static class BreakableBedrockCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Breakable Bedrock Toggle")
            @Config.Comment(value={"Allows customizable mining of bedrock"})
            public boolean utBreakableBedrockToggle = false;
            @Config.Name(value="[2] Tool List")
            @Config.Comment(value={"List of tools concerning mining bedrock", "Behavior depends on the list mode", "Syntax: modid:tool"})
            public String[] utBreakableBedrockToolList = new String[0];
            @Config.Name(value="[3] List Mode")
            @Config.Comment(value={"Blacklist Mode: Tools which can't mine bedrock, others can", "Whitelist Mode: Tools which can mine bedrock, others can't"})
            public EnumLists utBreakableBedrockToolListMode = EnumLists.BLACKLIST;
        }

        public static class BlockDispenserCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Block Dispenser Toggle")
            @Config.Comment(value={"Allows dispensers to place blocks"})
            public boolean utBlockDispenserToggle = true;
            @Config.Name(value="[2] Block List")
            @Config.Comment(value={"List of blocks concerning dispensing", "Behavior depends on the list mode", "Syntax: modid:block"})
            public String[] utBlockDispenserBlockList = new String[]{"minecraft:water", "minecraft:flowing_water", "minecraft:lava", "minecraft:flowing_lava", "minecraft:fire", "minecraft:web", "botania:specialflower", "thermalexpansion:strongbox"};
            @Config.Name(value="[3] List Mode")
            @Config.Comment(value={"Blacklist Mode: Blocks which can't be placed, others can", "Whitelist Mode: Blocks which can be placed, others can't"})
            public EnumLists utBlockDispenserBlockListMode = EnumLists.BLACKLIST;
        }

        public static class BetterPlacementCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Better Placement Toggle")
            @Config.Comment(value={"Removes the delay between placing blocks"})
            public boolean utBetterPlacementToggle = false;
            @Config.Name(value="[2] Force New Location")
            @Config.Comment(value={"If the cursor must be moved to a new location before placing another block"})
            public boolean utBetterPlacementNewLoc = true;
            @Config.Name(value="[3] Creative Mode Only")
            @Config.Comment(value={"Only affects block placement in creative mode"})
            public boolean utBetterPlacementCreative = false;
        }
    }

    public static enum EnumBeacon {
        MODIFIER(false, true),
        ENFORCED(true, false),
        ENFORCED_MODIFIER(true, true);

        public final boolean isEnforce;
        public final boolean isModifier;

        private EnumBeacon(boolean isEnforce, boolean isModifier) {
            this.isEnforce = isEnforce;
            this.isModifier = isModifier;
        }
    }

    public static enum TrampleOptions {
        DEFAULT,
        NEVER,
        ONLY_PLAYER,
        NOT_PLAYER,
        FEATHER_FALLING;

    }

    public static enum EnumDifficulty {
        PEACEFUL,
        EASY,
        NORMAL,
        HARD;

    }

    public static enum EnumLists {
        WHITELIST,
        BLACKLIST;

    }
}

