/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.util;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import javax.lang.model.SourceVersion;

public class Util {
    private static final Joiner SLASH_JOINER = Joiner.on((char)'/');
    private static final boolean DEBUG_CANON = false;

    public static File childFile(File parent, String childName) {
        parent.mkdirs();
        return new File(parent, childName);
    }

    public static boolean isValidClassName(String className) {
        String DOT_PACKAGE_INFO = ".package-info";
        if (className.endsWith(".package-info")) {
            className = className.substring(0, className.length() - ".package-info".length());
        }
        return SourceVersion.isName(className);
    }

    public static String normalizePathToString(Path path) {
        return SLASH_JOINER.join((Iterable)path);
    }

    public static String normalize(String path) {
        char prevChar = '\u0000';
        StringBuilder sb = null;
        for (int i = 0; i < path.length(); ++i) {
            char thisChar = path.charAt(i);
            if (thisChar == '\\') {
                thisChar = '/';
            }
            if (prevChar != '/' || thisChar != prevChar) {
                if (sb != null) {
                    sb.append(thisChar);
                }
            } else if (sb == null) {
                sb = new StringBuilder(path.length());
                sb.append(path, 0, i);
            }
            prevChar = thisChar;
        }
        return sb == null ? path : sb.toString();
    }

    public static String getCanonicalPathFast(File file) throws IOException {
        String ours = Util.normalize(file.getAbsolutePath());
        return ours;
    }
}

