/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.Arrays;
import org.embeddedt.vintagefix.util.Util;

public class CachedResourcePath {
    private final String[] pathComponents;
    public static final Interner<String> PATH_COMPONENT_INTERNER = Interners.newStrongInterner();
    private static final Splitter SLASH_SPLITTER = Splitter.on((char)'/');
    private static final Joiner JOINER = Joiner.on((char)'/');

    public CachedResourcePath(String path, boolean intern) {
        int numComponents = 1;
        path = Util.normalize(path);
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) != '/') continue;
            ++numComponents;
        }
        String[] components = new String[numComponents];
        int i = 0;
        for (String s : SLASH_SPLITTER.split((CharSequence)path)) {
            components[i] = intern ? (String)PATH_COMPONENT_INTERNER.intern((Object)s) : s;
            ++i;
        }
        this.pathComponents = components;
    }

    public int hashCode() {
        return Arrays.hashCode(this.pathComponents);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CachedResourcePath that = (CachedResourcePath)o;
        return Arrays.equals(this.pathComponents, that.pathComponents);
    }

    public String toString() {
        return JOINER.join((Object[])this.pathComponents);
    }
}

