/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.mixin.resourcepacks;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.minecraft.client.resources.FileResourcePack;
import org.embeddedt.vintagefix.VintageFix;
import org.embeddedt.vintagefix.annotation.ClientOnlyMixin;
import org.embeddedt.vintagefix.dynamicresources.ICachedResourcePack;
import org.embeddedt.vintagefix.util.CachedResourcePath;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FileResourcePack.class})
@ClientOnlyMixin
public abstract class MixinFileResourcePack
implements ICachedResourcePack {
    private static final Cache<String, ObjectOpenHashSet<CachedResourcePath>> containedPathsByFile = CacheBuilder.newBuilder().concurrencyLevel(4).expireAfterAccess(5L, TimeUnit.MINUTES).build();

    @Shadow
    protected abstract ZipFile func_110599_c() throws IOException;

    private Set<CachedResourcePath> genCache() {
        try {
            ZipFile file = this.func_110599_c();
            return (Set)containedPathsByFile.get((Object)file.getName(), () -> {
                ObjectOpenHashSet containedPaths = new ObjectOpenHashSet(file.size());
                Enumeration<? extends ZipEntry> entryEnum = file.entries();
                while (entryEnum.hasMoreElements()) {
                    ZipEntry entry = entryEnum.nextElement();
                    if (!entry.getName().startsWith("assets/") && entry.getName().indexOf(47) != -1) continue;
                    containedPaths.add((Object)new CachedResourcePath(entry.getName(), true));
                }
                containedPaths.trim();
                return containedPaths;
            });
        }
        catch (FileNotFoundException e) {
            return ImmutableSet.of();
        }
        catch (IOException | ExecutionException e) {
            VintageFix.LOGGER.error("Exception creating cache", (Throwable)e);
            return ImmutableSet.of();
        }
    }

    private Set<CachedResourcePath> getCache() {
        try {
            ZipFile file = this.func_110599_c();
            return (Set)containedPathsByFile.getIfPresent((Object)file.getName());
        }
        catch (IOException e) {
            return null;
        }
    }

    @Inject(method={"hasResourceName"}, at={@At(value="HEAD")}, cancellable=true)
    private void fastHasResource(String name, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)this.genCache().contains(new CachedResourcePath(name, false)));
    }

    @Override
    @Nullable
    public Stream<String> getAllPaths() {
        Set<CachedResourcePath> paths = this.getCache();
        return paths != null ? paths.stream().map(CachedResourcePath::toString) : null;
    }
}

