/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.mixin.dynamic_resources;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.embeddedt.vintagefix.annotation.ClientOnlyMixin;
import org.embeddedt.vintagefix.annotation.LateMixin;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import slimeknights.mantle.client.ModelHelper;

@Mixin(value={ModelHelper.class})
@ClientOnlyMixin
@LateMixin
public class MixinModelHelper {
    private static final int VERTEX_SIZE = DefaultVertexFormats.field_176599_b.func_181719_f();

    @Inject(method={"colorQuad"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void colorQuadFast(int color, BakedQuad quad, CallbackInfoReturnable<BakedQuad> cir) {
        if (quad.getFormat() == DefaultVertexFormats.field_176599_b) {
            if ((color & 0xFF000000) == 0) {
                color |= 0xFF000000;
            }
            color = Integer.reverseBytes(Integer.rotateLeft(color, 8));
            int[] newData = (int[])quad.func_178209_a().clone();
            for (int i = 0; i < 4; ++i) {
                newData[i * MixinModelHelper.VERTEX_SIZE + 3] = color;
            }
            cir.setReturnValue((Object)new BakedQuad(newData, quad.func_178211_c(), quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat()));
        }
    }
}

