/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.mixin.dynamic_resources;

import java.util.EnumMap;
import net.minecraft.util.EnumFacing;
import org.embeddedt.vintagefix.annotation.ClientOnlyMixin;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"net/minecraftforge/client/model/ItemLayerModel$FaceData"}, remap=false)
@ClientOnlyMixin
public class FaceDataMixin {
    private int[] faceDataStore;
    private int faceDataSize;
    @Shadow
    @Final
    private int vMax;

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Ljava/util/EnumMap;put(Ljava/lang/Enum;Ljava/lang/Object;)Ljava/lang/Object;"))
    private Object skipPut(EnumMap<?, ?> map, Enum<?> key, Object object) {
        return null;
    }

    private static int getOrdinal(EnumFacing facing) {
        switch (facing) {
            case WEST: {
                return 0;
            }
            case EAST: {
                return 1;
            }
            case UP: {
                return 2;
            }
            case DOWN: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Unexpected facing");
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initBacking(int uMax, int vMax, CallbackInfo ci) {
        this.faceDataSize = (uMax * vMax + 31) / 32;
        this.faceDataStore = new int[4 * this.faceDataSize];
    }

    @Overwrite
    public void set(EnumFacing facing, int u, int v) {
        int idx = v * this.vMax + u;
        int n = FaceDataMixin.getOrdinal(facing) * this.faceDataSize + (idx >> 5);
        this.faceDataStore[n] = this.faceDataStore[n] | 1 << (idx & 0x1F);
    }

    @Overwrite
    public boolean get(EnumFacing facing, int u, int v) {
        int idx = v * this.vMax + u;
        return (this.faceDataStore[FaceDataMixin.getOrdinal(facing) * this.faceDataSize + (idx >> 5)] & 1 << (idx & 0x1F)) != 0;
    }
}

