/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.dynamicresources.model;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistrySimple;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.vintagefix.dynamicresources.IBlockModelShapes;
import org.embeddedt.vintagefix.dynamicresources.model.DynamicModelProvider;
import org.embeddedt.vintagefix.dynamicresources.model.ModelLocationInformation;
import org.embeddedt.vintagefix.event.DynamicModelBakeEvent;

public class DynamicBakedModelProvider
extends RegistrySimple<ModelResourceLocation, IBakedModel> {
    private static final Logger LOGGER = LogManager.getLogger();
    public static DynamicBakedModelProvider instance;
    public static IBakedModel missingModel;
    public static final ModelResourceLocation MISSING_MODEL_LOCATION;
    private final DynamicModelProvider modelProvider;
    private final Map<ModelResourceLocation, IBakedModel> permanentlyLoadedBakedModels = Collections.synchronizedMap(new Object2ObjectOpenHashMap());
    private final Cache<ModelResourceLocation, Optional<IBakedModel>> loadedBakedModels = CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.MINUTES).maximumSize(1000L).concurrencyLevel(8).softValues().build();
    private final BakedModelStore bakedModelStore = new BakedModelStore();
    private static final FileNotFoundException PARENT_MISSING_EXCEPTION;
    private static final Function<ResourceLocation, TextureAtlasSprite> loggingTextureGetter;

    public DynamicBakedModelProvider(DynamicModelProvider modelProvider) {
        this.modelProvider = modelProvider;
    }

    public Map<IBlockState, IBakedModel> getBakedModelStore() {
        return this.bakedModelStore;
    }

    protected Map<ModelResourceLocation, IBakedModel> func_148740_a() {
        return ImmutableMap.of();
    }

    @Nullable
    private static IBakedModel getMissingIfRegistered(ModelResourceLocation location) {
        if (ModelLocationInformation.allItemVariants.contains(location)) {
            return missingModel;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IBakedModel getObject(ModelResourceLocation location) {
        Optional<IBakedModel> opt = (Optional<IBakedModel>)this.loadedBakedModels.getIfPresent((Object)location);
        if (opt == null) {
            DynamicBakedModelProvider dynamicBakedModelProvider = this;
            synchronized (dynamicBakedModelProvider) {
                opt = (Optional)this.loadedBakedModels.getIfPresent((Object)location);
                if (opt == null) {
                    opt = Optional.ofNullable(this.loadBakedModel(location));
                    this.loadedBakedModels.put((Object)location, opt);
                }
            }
        }
        if (opt.isPresent()) {
            return (IBakedModel)opt.get();
        }
        return DynamicBakedModelProvider.getMissingIfRegistered(location);
    }

    @Nullable
    public IBakedModel getModelIfPresent(ModelResourceLocation location) {
        Optional opt = (Optional)this.loadedBakedModels.getIfPresent((Object)location);
        if (opt != null) {
            return opt.orElse(null);
        }
        return null;
    }

    private IBakedModel loadBakedModel(ModelResourceLocation location) {
        block12: {
            IBakedModel bakedModel = this.permanentlyLoadedBakedModels.get(location);
            if (bakedModel != null) {
                return bakedModel;
            }
            Throwable mException = null;
            IModel model = null;
            try {
                model = this.modelProvider.getObject((ResourceLocation)location);
            }
            catch (Throwable e) {
                mException = e;
            }
            if (model == null) {
                DynamicModelBakeEvent event = new DynamicModelBakeEvent((ResourceLocation)location, null, missingModel);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (event.bakedModel != missingModel) {
                    return event.bakedModel;
                }
                if (ModelLocationInformation.canLogError(location.func_110624_b())) {
                    if (!ModelLocationInformation.DEBUG_MODEL_LOAD) {
                        LOGGER.error("Error occured while loading model {}", (Object)location);
                    } else {
                        LOGGER.error("Failed to load model {}", (Object)location, (Object)mException);
                    }
                }
            } else {
                try {
                    return DynamicBakedModelProvider.bakeAndCheckTextures((ResourceLocation)location, model, DefaultVertexFormats.field_176599_b);
                }
                catch (Throwable t) {
                    if (!ModelLocationInformation.canLogError(location.func_110624_b())) break block12;
                    if (ModelLocationInformation.DEBUG_MODEL_LOAD) {
                        LOGGER.error("Error occured while baking model {}", (Object)location, (Object)t);
                    }
                    LOGGER.error("Error occured while baking model {}", (Object)location);
                }
            }
        }
        Collection<ModelResourceLocation> knownVariants = ModelLocationInformation.validVariantsForBlock.get(new ResourceLocation(location.func_110624_b(), location.func_110623_a()));
        return knownVariants != null && knownVariants.contains(location) ? missingModel : null;
    }

    private static IBakedModel bakeAndCheckTextures(ResourceLocation location, IModel model, VertexFormat format) {
        IBakedModel bakedModel = model.bake(model.getDefaultState(), format, loggingTextureGetter);
        if (!MISSING_MODEL_LOCATION.equals((Object)location)) {
            DynamicModelBakeEvent event = new DynamicModelBakeEvent(location, model, bakedModel);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.bakedModel;
        }
        return bakedModel;
    }

    public void putObject(ModelResourceLocation key, IBakedModel value) {
        this.permanentlyLoadedBakedModels.put(key, value);
        this.loadedBakedModels.invalidate((Object)key);
    }

    public Set<ModelResourceLocation> func_148742_b() {
        return this.permanentlyLoadedBakedModels.keySet();
    }

    public Iterator<IBakedModel> iterator() {
        return this.permanentlyLoadedBakedModels.values().iterator();
    }

    public void invalidateThrough(ModelResourceLocation key) {
        this.loadedBakedModels.invalidate((Object)key);
        this.modelProvider.invalidate((ResourceLocation)key);
    }

    static {
        MISSING_MODEL_LOCATION = new ModelResourceLocation("builtin/missing", "missing");
        PARENT_MISSING_EXCEPTION = new FileNotFoundException("Failed to load model parent");
        loggingTextureGetter = location -> {
            String name;
            TextureMap map = Minecraft.func_71410_x().func_147117_R();
            TextureAtlasSprite sprite = map.func_110572_b(name = location.toString());
            if (!(sprite != map.func_174944_f() || sprite.func_94215_i().equals(name) || location.func_110624_b().equals("minecraft") && sprite.func_94215_i().equals(location.func_110623_a()) || name.equals("minecraft:builtin/white"))) {
                LOGGER.warn("Texture {} was not discovered during texture pass", (Object)name);
            }
            return sprite;
        };
    }

    class BakedModelStore
    implements Map<IBlockState, IBakedModel> {
        BakedModelStore() {
        }

        @Override
        public int size() {
            return DynamicBakedModelProvider.this.permanentlyLoadedBakedModels.size();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(Object key) {
            return true;
        }

        @Override
        public boolean containsValue(Object value) {
            return true;
        }

        @Override
        public IBakedModel get(Object key) {
            if (key instanceof IBlockState) {
                return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b((IBlockState)key);
            }
            return null;
        }

        @Override
        public IBakedModel put(IBlockState key, IBakedModel value) {
            ModelResourceLocation mrl = ((IBlockModelShapes)Minecraft.func_71410_x().func_175602_ab().func_175023_a()).getLocationForState(key);
            DynamicBakedModelProvider.this.putObject(mrl, value);
            return null;
        }

        @Override
        public IBakedModel remove(Object key) {
            return null;
        }

        @Override
        public void putAll(Map<? extends IBlockState, ? extends IBakedModel> m) {
            m.forEach(this::put);
        }

        @Override
        public void clear() {
        }

        @Override
        public Set<IBlockState> keySet() {
            return Collections.emptySet();
        }

        @Override
        public Collection<IBakedModel> values() {
            return DynamicBakedModelProvider.this.permanentlyLoadedBakedModels.values();
        }

        @Override
        public Set<Map.Entry<IBlockState, IBakedModel>> entrySet() {
            return Collections.emptySet();
        }
    }
}

