/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.classloading;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import net.minecraft.block.properties.IProperty;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.vintagefix.ducks.FastMapStateHolder;

public class FastImmutableMapDefiner {
    private static final Logger LOGGER = LogManager.getLogger((String)"VintageFix - class definer");
    public static String GOOGLE_ACCESS_PREFIX = "/googleaccess/";
    public static String GOOGLE_ACCESS_SUFFIX = ".class_manual";
    private static final Supplier<Definer> DEFINE_CLASS = Suppliers.memoize(() -> {
        try {
            Method makePrivateLookup = MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
            Object privateLookup = makePrivateLookup.invoke(null, ImmutableMap.class, MethodHandles.lookup());
            Method defineClass = MethodHandles.Lookup.class.getMethod("defineClass", byte[].class);
            LOGGER.info("Using Java 9+ class definer");
            return (bytes, name) -> (Class)defineClass.invoke(privateLookup, new Object[]{bytes});
        }
        catch (Exception x) {
            try {
                Method defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                defineClass.setAccessible(true);
                ClassLoader loader = ImmutableMap.class.getClassLoader();
                LOGGER.info("Using Java 8 class definer");
                return (bytes, name) -> (Class)defineClass.invoke((Object)loader, name, bytes, 0, bytes.length);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    });
    private static final Supplier<MethodHandle> MAKE_IMMUTABLE_FAST_MAP = Suppliers.memoize(() -> {
        try {
            FastImmutableMapDefiner.defineInAppClassloader("com.google.common.collect.FerriteCoreEntrySetAccess");
            FastImmutableMapDefiner.defineInAppClassloader("com.google.common.collect.FerriteCoreImmutableMapAccess");
            FastImmutableMapDefiner.defineInAppClassloader("com.google.common.collect.FerriteCoreImmutableCollectionAccess");
            Class<?> map = Class.forName("org.embeddedt.vintagefix.fastmap.immutable.FastMapEntryImmutableMap");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            return lookup.findConstructor(map, MethodType.methodType(Void.TYPE, FastMapStateHolder.class));
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    });

    public static ImmutableMap<IProperty<?>, Comparable<?>> makeMap(FastMapStateHolder<?> state) {
        try {
            return MAKE_IMMUTABLE_FAST_MAP.get().invoke(state);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable x) {
            throw new RuntimeException(x);
        }
    }

    private static void defineInAppClassloader(String name) throws Exception {
        byte[] classBytes;
        try (InputStream byteInput = FastImmutableMapDefiner.class.getResourceAsStream(GOOGLE_ACCESS_PREFIX + name.replace('.', '/') + GOOGLE_ACCESS_SUFFIX);){
            Preconditions.checkNotNull((Object)byteInput, (Object)("Failed to find class bytes for " + name));
            classBytes = IOUtils.toByteArray((InputStream)byteInput);
        }
        Class<?> loaded = DEFINE_CLASS.get().define(classBytes, name);
        Preconditions.checkState((loaded.getClassLoader() == ImmutableMap.class.getClassLoader() ? 1 : 0) != 0);
    }

    private static interface Definer {
        public Class<?> define(byte[] var1, String var2) throws Exception;
    }
}

