/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.setup;

import java.io.File;
import java.util.function.Supplier;
import mcjty.lib.McJtyLib;
import mcjty.lib.base.GeneralConfig;
import mcjty.lib.varia.WrenchChecker;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class DefaultModSetup {
    private File modConfigDir;
    private Logger logger;
    protected CreativeTabs creativeTab;

    public void preInit(FMLPreInitializationEvent e) {
        this.logger = e.getModLog();
        this.createTabs();
        McJtyLib.preInit(e);
        GeneralConfig.init(e);
        this.modConfigDir = e.getModConfigurationDirectory();
        this.setupConfig();
        this.setupModCompat();
    }

    protected abstract void setupModCompat();

    protected abstract void setupConfig();

    public abstract void createTabs();

    protected void createTab(String name, final Supplier<ItemStack> stack) {
        this.creativeTab = new CreativeTabs(name){

            @NotNull
            public ItemStack func_78016_d() {
                return (ItemStack)stack.get();
            }
        };
    }

    public void init(FMLInitializationEvent e) {
    }

    public void postInit(FMLPostInitializationEvent e) {
        WrenchChecker.init();
    }

    public File getModConfigDir() {
        return this.modConfigDir;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public CreativeTabs getTab() {
        return this.creativeTab;
    }
}

