/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lib.McJtyLib;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.thirteen.Context;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketSendServerCommand
implements IMessage {
    private String modid;
    private String command;
    private TypedMap arguments;

    public void fromBytes(ByteBuf buf) {
        this.modid = NetworkTools.readString(buf);
        this.command = NetworkTools.readString(buf);
        this.arguments = TypedMapTools.readArguments(buf);
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writeString(buf, this.modid);
        NetworkTools.writeString(buf, this.command);
        TypedMapTools.writeArguments(buf, this.arguments);
    }

    public PacketSendServerCommand() {
    }

    public PacketSendServerCommand(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketSendServerCommand(String modid, String command, @Nonnull TypedMap arguments) {
        this.modid = modid;
        this.command = command;
        this.arguments = arguments;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            boolean result = McJtyLib.handleCommand(this.modid, this.command, (EntityPlayer)ctx.getSender(), this.arguments);
            if (!result) {
                Logging.logError("Error handling command '" + this.command + "' for mod '" + this.modid + "'!");
            }
        });
        ctx.setPacketHandled(true);
    }
}

