/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui.widgets;

import mcjty.lib.base.StyleConfig;
import mcjty.lib.gui.GuiParser;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.VerticalAlignment;
import mcjty.lib.gui.widgets.AbstractWidget;
import mcjty.lib.typed.Type;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public abstract class AbstractLabel<P extends AbstractLabel<P>>
extends AbstractWidget<P> {
    public static final String TYPE_LABEL = "label";
    public static final HorizontalAlignment DEFAULT_HORIZONTAL_ALIGN = HorizontalAlignment.ALIGN_CENTER;
    public static final VerticalAlignment DEFAULT_VERTICAL_ALIGN = VerticalAlignment.ALIGN_CENTER;
    public static final boolean DEFAULT_DYNAMIC = false;
    private String text;
    private Integer color = null;
    private Integer disabledColor = null;
    private HorizontalAlignment horizontalAlignment = DEFAULT_HORIZONTAL_ALIGN;
    private VerticalAlignment verticalAlignment = DEFAULT_VERTICAL_ALIGN;
    private boolean dynamic = false;
    private int txtDx = 0;
    private int txtDy = 0;
    private ResourceLocation image = null;
    private int u;
    private int v;
    private int iw;
    private int ih;

    public AbstractLabel(Minecraft mc, Gui gui) {
        super(mc, gui);
    }

    public ResourceLocation getImage() {
        return this.image;
    }

    public P setImage(ResourceLocation image, int u, int v, int iw, int ih) {
        this.image = image;
        this.u = u;
        this.v = v;
        this.iw = iw;
        this.ih = ih;
        return (P)this;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public P setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
        return (P)this;
    }

    @Override
    public int getDesiredWidth() {
        int w = super.getDesiredWidth();
        if (this.dynamic) {
            return w;
        }
        if (w == -1) {
            w = this.mc.field_71466_p.func_78256_a(this.text) + 6;
        }
        return w;
    }

    @Override
    public int getDesiredHeight() {
        int h = super.getDesiredHeight();
        if (this.dynamic) {
            return h;
        }
        if (h == -1) {
            h = this.mc.field_71466_p.field_78288_b + 2;
        }
        return h;
    }

    public String getText() {
        return this.text;
    }

    public P setText(String text) {
        this.text = text;
        return (P)this;
    }

    public P setTextOffset(int ox, int oy) {
        this.txtDx = ox;
        this.txtDy = oy;
        return (P)this;
    }

    public int getColor() {
        return this.color == null ? StyleConfig.colorTextNormal : this.color;
    }

    public P setColor(int color) {
        this.color = color;
        return (P)this;
    }

    public int getDisabledColor() {
        return this.disabledColor == null ? StyleConfig.colorTextDisabled : this.disabledColor;
    }

    public P setDisabledColor(int disabledColor) {
        this.disabledColor = disabledColor;
        return (P)this;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public P setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return (P)this;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public P setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return (P)this;
    }

    @Override
    public void draw(int x, int y) {
        this.drawOffset(x, y, 0, 0);
    }

    public void drawOffset(int x, int y, int offsetx, int offsety) {
        if (!this.visible) {
            return;
        }
        super.draw(x, y);
        int dx = this.calculateHorizontalOffset() + offsetx + this.txtDx;
        int dy = this.calculateVerticalOffset() + offsety + this.txtDy;
        if (this.image != null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(this.image);
            int xx = x + this.bounds.x + (this.bounds.width - this.iw) / 2;
            int yy = y + this.bounds.y + (this.bounds.height - this.ih) / 2;
            this.gui.func_73729_b(xx, yy, this.u, this.v, this.iw, this.ih);
        }
        int col = this.getColor();
        if (!this.isEnabled()) {
            col = this.getDisabledColor();
        }
        if (this.text == null) {
            this.mc.field_71466_p.func_78276_b("", x + dx + this.bounds.x, y + dy + this.bounds.y, col);
        } else {
            this.mc.field_71466_p.func_78276_b(this.mc.field_71466_p.func_78269_a(this.text, this.bounds.width), x + dx + this.bounds.x, y + dy + this.bounds.y, col);
        }
    }

    private int calculateVerticalOffset() {
        if (this.verticalAlignment != VerticalAlignment.ALIGN_TOP) {
            int h = this.mc.field_71466_p.field_78288_b;
            if (this.verticalAlignment == VerticalAlignment.ALIGN_BOTTOM) {
                return this.bounds.height - h;
            }
            return (this.bounds.height - h) / 2;
        }
        return 0;
    }

    private int calculateHorizontalOffset() {
        if (this.horizontalAlignment != HorizontalAlignment.ALIGN_LEFT) {
            int w = this.mc.field_71466_p.func_78256_a(this.text);
            if (this.horizontalAlignment == HorizontalAlignment.ALIGN_RIGHT) {
                return this.bounds.width - w;
            }
            return (this.bounds.width - w) / 2;
        }
        return 0;
    }

    @Override
    public void readFromGuiCommand(GuiParser.GuiCommand command) {
        super.readFromGuiCommand(command);
        this.text = command.getOptionalPar(1, "");
        this.color = GuiParser.get(command, "color", null);
        this.disabledColor = GuiParser.get(command, "disabledcolor", null);
        this.horizontalAlignment = HorizontalAlignment.getByName(GuiParser.get(command, "horizalign", DEFAULT_HORIZONTAL_ALIGN.name()));
        this.verticalAlignment = VerticalAlignment.getByName(GuiParser.get(command, "vertalign", DEFAULT_VERTICAL_ALIGN.name()));
        this.dynamic = GuiParser.get(command, "dynamic", false);
    }

    @Override
    public void fillGuiCommand(GuiParser.GuiCommand command) {
        super.fillGuiCommand(command);
        command.parameter(this.text);
        GuiParser.put(command, "color", this.color, null);
        GuiParser.put(command, "disabledcolor", this.disabledColor, null);
        GuiParser.put(command, "horizalign", this.horizontalAlignment.name(), DEFAULT_HORIZONTAL_ALIGN.name());
        GuiParser.put(command, "vertalign", this.verticalAlignment.name(), DEFAULT_VERTICAL_ALIGN.name());
        GuiParser.put(command, "dynamic", this.dynamic, false);
    }

    @Override
    public GuiParser.GuiCommand createGuiCommand() {
        return new GuiParser.GuiCommand(TYPE_LABEL);
    }

    @Override
    public <T> void setGenericValue(T value) {
        if (value == null) {
            this.setText("");
        } else {
            this.setText(value.toString());
        }
    }

    @Override
    public Object getGenericValue(Type<?> type) {
        return this.getText();
    }
}

