/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import mcjty.lib.gui.GuiParser;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class GuiParserTools {
    public static void parseAndHandleServer(ResourceLocation guiDescription, Consumer<GuiParser.GuiCommand> consumer) {
        try {
            ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(guiDescription.func_110624_b());
            JsonContext ctx = new JsonContext(mod.getModId());
            Path filePath = null;
            if (mod.getSource().isFile()) {
                FileSystem fs = FileSystems.newFileSystem(mod.getSource().toPath(), (ClassLoader)null);
                filePath = fs.getPath("/assets/" + ctx.getModId() + "/" + guiDescription.func_110623_a(), new String[0]);
            } else if (mod.getSource().isDirectory()) {
                filePath = mod.getSource().toPath().resolve("assets/" + ctx.getModId() + "/" + guiDescription.func_110623_a());
            }
            System.out.println("filePath = " + filePath);
            try (BufferedReader br = new BufferedReader(new InputStreamReader(Files.newInputStream(filePath, new OpenOption[0]), StandardCharsets.UTF_8));){
                GuiParser.parse(br).forEach(consumer);
            }
            catch (GuiParser.ParserException e) {
                throw new RuntimeException(e);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

