/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui;

import java.awt.Rectangle;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.base.ModBase;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.gui.GuiSideWindow;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.WindowManager;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.network.PacketSendServerCommand;
import mcjty.lib.network.PacketServerCommandTyped;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public abstract class GenericGuiContainer<T extends GenericTileEntity>
extends GuiContainer {
    protected ModBase modBase;
    protected SimpleNetworkWrapper network;
    protected Window window;
    private WindowManager windowManager;
    protected final T tileEntity;
    private GuiSideWindow sideWindow;

    public int getGuiLeft() {
        return this.field_147003_i;
    }

    public int getGuiTop() {
        return this.field_147009_r;
    }

    public void setWindowDimensions(int x, int y) {
        this.field_146999_f = x;
        this.field_147000_g = y;
    }

    public GenericGuiContainer(ModBase mod, SimpleNetworkWrapper network, T tileEntity, Container container, int manual, String manualNode) {
        super(container);
        this.modBase = mod;
        this.network = network;
        this.tileEntity = tileEntity;
        this.sideWindow = new GuiSideWindow(manual, manualNode);
        this.windowManager = null;
    }

    public List<Rectangle> getSideWindowBounds() {
        if (this.sideWindow.getWindow() == null || this.sideWindow.getWindow().getToplevel() == null) {
            Logging.getLogger().error((Object)new RuntimeException("Internal error! getSideWindowBounds() called before initGui!"));
            return Collections.emptyList();
        }
        return Collections.singletonList(this.sideWindow.getWindow().getToplevel().getBounds());
    }

    public List<Rectangle> getExtraWindowBounds() {
        if (this.sideWindow.getWindow() == null || this.sideWindow.getWindow().getToplevel() == null) {
            Logging.getLogger().error((Object)new RuntimeException("Internal error! getExtraWindowBounds() called before initGui!"));
            return Collections.emptyList();
        }
        ArrayList<Rectangle> bounds = new ArrayList<Rectangle>();
        Rectangle r1 = this.sideWindow.getWindow().getToplevel().getBounds();
        bounds.add(new Rectangle(r1.x, r1.y, r1.width, r1.height));
        if (this.windowManager != null) {
            for (Window w : this.windowManager.getWindows()) {
                Rectangle r = w.getToplevel().getBounds();
                bounds.add(new Rectangle(r.x, r.y, r.width, r.height));
            }
        }
        return bounds;
    }

    public void func_73866_w_() {
        this.windowManager = null;
        super.func_73866_w_();
        this.sideWindow.initGui(this.modBase, this.network, this.field_146297_k, (GuiScreen)this, this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
    }

    protected void registerWindows(WindowManager mgr) {
    }

    protected WindowManager getWindowManager() {
        if (this.windowManager == null) {
            if (this.sideWindow.getWindow() == null) {
                RuntimeException e = new RuntimeException("Internal error! getWindowManager() called before initGui!");
                Logging.getLogger().error((Object)e);
                throw e;
            }
            this.windowManager = new WindowManager((GuiScreen)this);
            this.windowManager.addWindow(this.sideWindow.getWindow());
            this.windowManager.addWindow(this.window);
            this.registerWindows(this.windowManager);
        }
        return this.windowManager;
    }

    protected void func_146979_b(int i, int i2) {
        this.getWindowManager().drawTooltips();
    }

    public static String escapeString(String s) {
        return s.replace("@", "@@");
    }

    private static List<Object> parseString(String s, List<ItemStack> items) {
        ArrayList<Object> l = new ArrayList<Object>();
        String current = "";
        for (int i = 0; i < s.length(); ++i) {
            String c = s.substring(i, i + 1);
            if ("@".equals(c)) {
                ItemStack e;
                int itemIdx;
                if ((itemIdx = s.charAt(++i) - 48) == 16) {
                    current = current + "@";
                    continue;
                }
                if (itemIdx < 0 || itemIdx > 9) {
                    throw new IllegalArgumentException(s);
                }
                if (!current.isEmpty()) {
                    l.add(current);
                    current = "";
                }
                if ((e = items.get(itemIdx)).func_190926_b()) continue;
                l.add(e);
                continue;
            }
            current = current + c;
        }
        if (!current.isEmpty()) {
            l.add(current);
        }
        return l;
    }

    public void drawHoveringText(List<String> textLines, List<ItemStack> items, int x, int y, FontRenderer font) {
        if (!textLines.isEmpty()) {
            GlStateManager.func_179101_C();
            net.minecraft.client.renderer.RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int i = 0;
            int linesWithItemStacks = 0;
            for (String s : textLines) {
                int j;
                if (s != null && items != null && s.contains("@") && !items.isEmpty()) {
                    List<Object> list = GenericGuiContainer.parseString(s, items);
                    boolean lineHasItemStacks = false;
                    j = 0;
                    for (Object o : list) {
                        if (o instanceof String) {
                            j += font.func_78256_a((String)o);
                            continue;
                        }
                        j += 20;
                        lineHasItemStacks = true;
                    }
                    if (lineHasItemStacks) {
                        ++linesWithItemStacks;
                    }
                } else {
                    j = font.func_78256_a(s);
                }
                if (j <= i) continue;
                i = j;
            }
            int xx = x + 12;
            int yy = y - 12;
            int k = 8;
            if (textLines.size() > 1) {
                k += 2 + (textLines.size() - 1) * 10 + linesWithItemStacks * 8;
            }
            if (xx > this.field_146294_l - this.field_147003_i - i - 5) {
                xx -= 28 + i;
            }
            if (xx < 4 - this.field_147003_i) {
                xx = 4 - this.field_147003_i;
            }
            if (yy > this.field_146295_m - this.field_147009_r - k - 4) {
                yy = this.field_146295_m - this.field_147009_r - k - 4;
            } else if (yy < 4 - this.field_147009_r) {
                yy = 4 - this.field_147009_r;
            }
            this.field_73735_i = 300.0f;
            this.field_146296_j.field_77023_b = 300.0f;
            int l = -267386864;
            this.func_73733_a(xx - 3, yy - 4, xx + i + 3, yy - 3, l, l);
            this.func_73733_a(xx - 3, yy + k + 3, xx + i + 3, yy + k + 4, l, l);
            this.func_73733_a(xx - 3, yy - 3, xx + i + 3, yy + k + 3, l, l);
            this.func_73733_a(xx - 4, yy - 3, xx - 3, yy + k + 3, l, l);
            this.func_73733_a(xx + i + 3, yy - 3, xx + i + 4, yy + k + 3, l, l);
            int i1 = 0x505000FF;
            int j1 = (i1 & 0xFEFEFE) >> 1 | i1 & 0xFF000000;
            this.func_73733_a(xx - 3, yy - 3 + 1, xx - 3 + 1, yy + k + 3 - 1, i1, j1);
            this.func_73733_a(xx + i + 2, yy - 3 + 1, xx + i + 3, yy + k + 3 - 1, i1, j1);
            this.func_73733_a(xx - 3, yy - 3, xx + i + 3, yy - 3 + 1, i1, i1);
            this.func_73733_a(xx - 3, yy + k + 2, xx + i + 3, yy + k + 3, j1, j1);
            for (int k1 = 0; k1 < textLines.size(); ++k1) {
                String s1 = textLines.get(k1);
                if (s1 != null && items != null && s1.contains("@") && !items.isEmpty()) {
                    List<Object> list = GenericGuiContainer.parseString(s1, items);
                    int curx = xx;
                    boolean lineHasItemStacks = false;
                    for (Object o : list) {
                        if (o instanceof String) {
                            String s2 = (String)o;
                            font.func_175063_a(s2, (float)curx, (float)yy, -1);
                            curx += font.func_78256_a(s2);
                            continue;
                        }
                        RenderHelper.renderObject(this.field_146297_k, curx + 1, yy, o, false);
                        curx += 20;
                        lineHasItemStacks = true;
                    }
                    if (lineHasItemStacks) {
                        yy += 8;
                    }
                } else {
                    font.func_175063_a(s1, (float)xx, (float)yy, -1);
                }
                if (k1 == 0) {
                    yy += 2;
                }
                yy += 10;
            }
            this.field_73735_i = 0.0f;
            this.field_146296_j.field_77023_b = 0.0f;
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            net.minecraft.client.renderer.RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.drawWindow();
    }

    protected void drawWindow() {
        this.func_146276_q_();
        this.getWindowManager().draw();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        this.drawStackTooltips(mouseX, mouseY);
    }

    public void func_146977_a(Slot slotIn) {
        if (!this.isPartiallyCoveredByModalWindow(slotIn)) {
            super.func_146977_a(slotIn);
        }
    }

    public boolean func_146981_a(Slot slotIn, int mouseX, int mouseY) {
        if (this.isPartiallyCoveredByModalWindow(slotIn)) {
            return false;
        }
        return super.func_146981_a(slotIn, mouseX, mouseY);
    }

    private boolean isPartiallyCoveredByModalWindow(Slot slotIn) {
        int xPos = slotIn.field_75223_e + this.window.getToplevel().getBounds().x;
        int yPos = slotIn.field_75221_f + this.window.getToplevel().getBounds().y;
        return this.getWindowManager().getModalWindows().anyMatch(window -> window.getToplevel().getBounds().intersects(new Rectangle(xPos, yPos, 18, 18)));
    }

    protected void drawStackTooltips(int mouseX, int mouseY) {
        BlockRender blockRender;
        Object renderItem;
        ItemStack itemStack;
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        Widget<?> widget = this.window.getToplevel().getWidgetAtPosition(x, y);
        if (widget instanceof BlockRender && !(itemStack = (renderItem = (blockRender = (BlockRender)widget).getRenderItem()) instanceof ItemStack ? (ItemStack)renderItem : (renderItem instanceof Block ? new ItemStack((Block)renderItem) : (renderItem instanceof Item ? new ItemStack((Item)renderItem) : ItemStack.field_190927_a))).func_190926_b()) {
            this.customRenderToolTip(blockRender, itemStack, mouseX, mouseY);
        }
    }

    protected List<String> addCustomLines(List<String> oldList, BlockRender blockRender, ItemStack stack) {
        return oldList;
    }

    protected void customRenderToolTip(BlockRender blockRender, ItemStack stack, int x, int y) {
        List<String> list;
        if (stack.func_77973_b() == null) {
            list = new ArrayList<String>();
        } else {
            ITooltipFlag.TooltipFlags flag = this.field_146297_k.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
            list = stack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, (ITooltipFlag)flag);
        }
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                list.set(i, stack.func_77953_t().getColor() + list.get(i));
                continue;
            }
            list.set(i, TextFormatting.GRAY + list.get(i));
        }
        list = this.addCustomLines(list, blockRender, stack);
        FontRenderer font = null;
        if (stack.func_77973_b() != null) {
            font = stack.func_77973_b().getFontRenderer(stack);
        }
        this.drawHoveringText(list, x, y, font == null ? this.field_146289_q : font);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        this.getWindowManager().mouseClicked(x, y, button);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.getWindowManager().handleMouseInput();
    }

    protected void func_146286_b(int x, int y, int state) {
        super.func_146286_b(x, y, state);
        this.getWindowManager().mouseReleased(x, y, state);
    }

    public Window getWindow() {
        return this.window;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        boolean b = this.getWindowManager().keyTyped(typedChar, keyCode);
        if (b) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public void keyTypedFromEvent(char typedChar, int keyCode) {
        if (this.getWindowManager().keyTyped(typedChar, keyCode)) {
            try {
                super.func_73869_a(typedChar, keyCode);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public void sendServerCommand(SimpleNetworkWrapper network, String command, TypedMap params) {
        network.sendToServer((IMessage)new PacketServerCommandTyped(this.tileEntity.func_174877_v(), null, command, params));
    }

    public void sendServerCommand(SimpleNetworkWrapper network, int dimensionId, String command, TypedMap params) {
        network.sendToServer((IMessage)new PacketServerCommandTyped(this.tileEntity.func_174877_v(), dimensionId, command, params));
    }

    public void sendServerCommand(String modid, String command, @Nonnull TypedMap arguments) {
        this.network.sendToServer((IMessage)new PacketSendServerCommand(modid, command, arguments));
    }

    public void sendServerCommand(String modid, String command) {
        this.network.sendToServer((IMessage)new PacketSendServerCommand(modid, command, TypedMap.EMPTY));
    }
}

