/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.world;

import io.github.phantamanta44.libnine.util.data.ByteUtils;
import io.github.phantamanta44.libnine.util.data.ISerializable;
import io.github.phantamanta44.libnine.util.world.BlockSide;
import io.github.phantamanta44.libnine.util.world.IAllocableSides;
import java.util.EnumMap;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class SideAlloc<E extends Enum<E>>
implements IAllocableSides<E>,
ISerializable {
    private final Class<E> enumType;
    private final Supplier<EnumFacing> frontGetter;
    private final EnumMap<BlockSide, E> faces;

    public SideAlloc(E defaultState, Supplier<EnumFacing> frontGetter) {
        this.enumType = ((Enum)defaultState).getDeclaringClass();
        this.frontGetter = frontGetter;
        this.faces = new EnumMap(BlockSide.class);
        for (BlockSide face : BlockSide.values()) {
            this.faces.put(face, defaultState);
        }
    }

    @Override
    public void setFace(BlockSide face, E state) {
        this.faces.put(face, state);
    }

    @Override
    public E getFace(BlockSide face) {
        return (E)((Enum)this.faces.get(face));
    }

    public <T> BiPredicate<T, EnumFacing> getPredicate(E state) {
        return (t, f) -> f != null && this.faces.get(BlockSide.fromDirection(this.frontGetter.get(), f)) == state;
    }

    @Override
    public void serBytes(ByteUtils.Writer data) {
        for (BlockSide side : BlockSide.values()) {
            data.writeShort((short)((Enum)this.faces.get(side)).ordinal());
        }
    }

    @Override
    public void deserBytes(ByteUtils.Reader data) {
        Enum[] values = (Enum[])this.enumType.getEnumConstants();
        for (BlockSide side : BlockSide.values()) {
            this.faces.put(side, values[data.readShort()]);
        }
    }

    @Override
    public void serNBT(NBTTagCompound tag) {
        for (BlockSide side : BlockSide.values()) {
            tag.func_74778_a(side.name(), ((Enum)this.faces.get(side)).toString());
        }
    }

    @Override
    public void deserNBT(NBTTagCompound tag) {
        for (BlockSide side : BlockSide.values()) {
            this.faces.put(side, Enum.valueOf(this.enumType, tag.func_74779_i(side.name())));
        }
    }
}

