/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.render;

import io.github.phantamanta44.libnine.util.render.TextureResource;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TextureRegion {
    private final TextureResource texture;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final float u1;
    private final float v1;
    private final float u2;
    private final float v2;
    private final float du;
    private final float dv;

    public TextureRegion(TextureResource texture, int x, int y, int width, int height) {
        this.texture = texture;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.u1 = (float)x / (float)texture.getWidth();
        this.v1 = (float)y / (float)texture.getHeight();
        this.u2 = this.u1 + (float)width / (float)texture.getWidth();
        this.v2 = this.v1 + (float)height / (float)texture.getHeight();
        this.du = this.u2 - this.u1;
        this.dv = this.v2 - this.v1;
    }

    public TextureRegion(TextureResource texture) {
        this(texture, 0, 0, texture.getWidth(), texture.getHeight());
    }

    public TextureResource getTexture() {
        return this.texture;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public float getU1() {
        return this.u1;
    }

    public float getV1() {
        return this.v1;
    }

    public float getU2() {
        return this.u2;
    }

    public float getV2() {
        return this.v2;
    }

    public float getUDifferential() {
        return this.du;
    }

    public float getVDifferential() {
        return this.dv;
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(double x, double y, double zIndex, double width, double height) {
        this.texture.bind();
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b(x, y + height, zIndex).func_187315_a((double)this.u1, (double)this.v2).func_181675_d();
        buf.func_181662_b(x + width, y + height, zIndex).func_187315_a((double)this.u2, (double)this.v2).func_181675_d();
        buf.func_181662_b(x + width, y, zIndex).func_187315_a((double)this.u2, (double)this.v1).func_181675_d();
        buf.func_181662_b(x, y, zIndex).func_187315_a((double)this.u1, (double)this.v1).func_181675_d();
        tess.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(int x, int y, double zIndex, int width, int height) {
        this.draw((double)x, (double)y, zIndex, (double)width, (double)height);
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(double x, double y, double width, double height) {
        this.draw(x, y, 0.0, width, height);
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(int x, int y, int width, int height) {
        this.draw(x, y, 0.0, width, height);
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(double x, double y, double zIndex) {
        this.draw(x, y, zIndex, (double)this.width, (double)this.height);
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(int x, int y, double zIndex) {
        this.draw(x, y, zIndex, this.width, this.height);
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(double x, double y) {
        this.draw(x, y, 0.0);
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(int x, int y) {
        this.draw(x, y, 0.0);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawPartial(double x, double y, double zIndex, double width, double height, float x1, float y1, float x2, float y2) {
        double xStart = x + width * (double)x1;
        double xEnd = x + width * (double)x2;
        double yStart = y + height * (double)y1;
        double yEnd = y + height * (double)y2;
        float uStart = this.u1 + this.du * x1;
        float uEnd = this.u1 + this.du * x2;
        float vStart = this.v1 + this.dv * y1;
        float vEnd = this.v1 + this.dv * y2;
        this.texture.bind();
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b(xStart, yEnd, zIndex).func_187315_a((double)uStart, (double)vEnd).func_181675_d();
        buf.func_181662_b(xEnd, yEnd, zIndex).func_187315_a((double)uEnd, (double)vEnd).func_181675_d();
        buf.func_181662_b(xEnd, yStart, zIndex).func_187315_a((double)uEnd, (double)vStart).func_181675_d();
        buf.func_181662_b(xStart, yStart, zIndex).func_187315_a((double)uStart, (double)vStart).func_181675_d();
        tess.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void drawPartial(int x, int y, double zIndex, int width, int height, float x1, float y1, float x2, float y2) {
        this.drawPartial((double)x, (double)y, zIndex, (double)width, (double)height, x1, y1, x2, y2);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawPartial(double x, double y, double width, double height, float x1, float y1, float x2, float y2) {
        this.drawPartial(x, y, 0.0, width, height, x1, y1, x2, y2);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawPartial(int x, int y, int width, int height, float x1, float y1, float x2, float y2) {
        this.drawPartial(x, y, 0.0, width, height, x1, y1, x2, y2);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawPartial(double x, double y, double zIndex, float x1, float y1, float x2, float y2) {
        this.drawPartial(x, y, zIndex, (double)this.width, (double)this.height, x1, y1, x2, y2);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawPartial(int x, int y, double zIndex, float x1, float y1, float x2, float y2) {
        this.drawPartial(x, y, zIndex, this.width, this.height, x1, y1, x2, y2);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawPartial(double x, double y, float x1, float y1, float x2, float y2) {
        this.drawPartial(x, y, 0.0, x1, y1, x2, y2);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawPartial(int x, int y, float x1, float y1, float x2, float y2) {
        this.drawPartial(x, y, 0.0, x1, y1, x2, y2);
    }
}

