/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.component.reservoir;

import io.github.phantamanta44.libnine.component.reservoir.DelegatedIntReservoir;
import io.github.phantamanta44.libnine.component.reservoir.IIntReservoir;
import io.github.phantamanta44.libnine.util.data.ByteUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class FluidReservoir
extends DelegatedIntReservoir
implements IFluidTank {
    private final boolean locked;
    private final Collection<BiConsumer<FluidStack, FluidStack>> callbacks = new ArrayList<BiConsumer<FluidStack, FluidStack>>();
    @Nullable
    private Fluid fluid;
    @Nullable
    private NBTTagCompound fluidData;

    public static FluidReservoir observable(IIntReservoir backing, Runnable observer) {
        FluidReservoir reservoir = new FluidReservoir(backing);
        reservoir.onFluidChange((o, n) -> observer.run());
        reservoir.onQuantityChange((o, n) -> observer.run());
        return reservoir;
    }

    public FluidReservoir(@Nullable Fluid fluid, @Nullable NBTTagCompound fluidData, IIntReservoir backing, boolean locked) {
        super(backing);
        this.fluid = fluid;
        this.fluidData = fluidData;
        this.locked = locked;
        backing.onQuantityChange((o, n) -> {
            if (n <= 0 && !locked) {
                FluidStack oldFluid = this.getFluid();
                this.fluid = null;
                this.fluidData = null;
                for (BiConsumer<FluidStack, FluidStack> callback : this.callbacks) {
                    callback.accept(oldFluid, null);
                }
            }
        });
    }

    public FluidReservoir(@Nullable FluidStack fluid, IIntReservoir backing, boolean locked) {
        this(fluid != null ? fluid.getFluid() : null, fluid != null ? fluid.tag : null, backing, locked);
    }

    public FluidReservoir(@Nullable Fluid fluid, @Nullable NBTTagCompound fluidData, IIntReservoir backing) {
        this(fluid, fluidData, backing, true);
    }

    public FluidReservoir(@Nullable FluidStack fluid, IIntReservoir backing) {
        this(fluid, backing, true);
    }

    public FluidReservoir(IIntReservoir backing) {
        this(null, null, backing, false);
    }

    public boolean hasFluid() {
        return this.fluid != null && this.getQuantity() > 0;
    }

    @Nullable
    public FluidStack getFluid() {
        if (this.fluid == null) {
            return null;
        }
        int quantity = this.getQuantity();
        return quantity > 0 ? new FluidStack(this.fluid, quantity, this.fluidData) : null;
    }

    @Nullable
    public Fluid getFluidType() {
        return this.fluid;
    }

    @Nullable
    public NBTTagCompound getFluidData() {
        return this.fluidData;
    }

    public void setFluid(@Nullable Fluid fluid, @Nullable NBTTagCompound fluidData) {
        if (!Objects.equals(fluid, this.fluid) || !Objects.equals(fluidData, this.fluidData)) {
            if (this.locked) {
                throw new UnsupportedOperationException("Fluid type is locked!");
            }
            FluidStack oldFluid = this.getFluid();
            this.fluid = fluid;
            this.fluidData = fluidData;
            for (BiConsumer<FluidStack, FluidStack> callback : this.callbacks) {
                callback.accept(oldFluid, this.getFluid());
            }
        }
    }

    public void setFluid(@Nullable Fluid fluid) {
        this.setFluid(fluid, null);
    }

    public int getFluidAmount() {
        return this.getQuantity();
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource.amount <= 0) {
            return 0;
        }
        if (this.fluid == null) {
            if (doFill) {
                this.fluid = resource.getFluid();
                this.fluidData = resource.tag;
                for (BiConsumer<FluidStack, FluidStack> callback : this.callbacks) {
                    callback.accept(null, this.getFluid());
                }
            }
        } else if (resource.getFluid() != this.fluid || !Objects.equals(resource.tag, this.fluidData)) {
            return 0;
        }
        return this.offer(resource.amount, doFill);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.fluid == null) {
            return null;
        }
        Fluid oldFluid = this.fluid;
        int drained = this.draw(maxDrain, doDrain);
        return drained > 0 ? new FluidStack(oldFluid, drained, this.fluidData) : null;
    }

    public boolean canFillFluidType(FluidStack fluidStack) {
        return this.fluid == null || this.fluid == fluidStack.getFluid() && Objects.equals(this.fluidData, fluidStack.tag);
    }

    public boolean canDrainFluidType(FluidStack fluidStack) {
        return this.fluid != null && this.fluid == fluidStack.getFluid() && Objects.equals(this.fluidData, fluidStack.tag);
    }

    public void onFluidChange(BiConsumer<FluidStack, FluidStack> callback) {
        this.callbacks.add(callback);
    }

    @Override
    public void serNBT(NBTTagCompound tag) {
        super.serNBT(tag);
        if (!this.locked && this.fluid != null) {
            tag.func_74778_a("Fluid", this.fluid.getName());
            if (this.fluidData != null) {
                tag.func_74782_a("FluidData", (NBTBase)this.fluidData);
            }
        }
    }

    @Override
    public void deserNBT(NBTTagCompound tag) {
        super.deserNBT(tag);
        if (!this.locked && tag.func_150297_b("Fluid", 8)) {
            this.fluid = FluidRegistry.getFluid((String)tag.func_74779_i("Fluid"));
            this.fluidData = tag.func_150297_b("FluidData", 10) ? tag.func_74775_l("FluidData") : null;
        }
    }

    @Override
    public void serBytes(ByteUtils.Writer data) {
        super.serBytes(data);
        if (!this.locked) {
            if (this.fluid == null) {
                data.writeByte((byte)0);
            } else {
                data.writeByte((byte)(1 | (this.fluidData != null ? 2 : 0))).writeFluid(this.fluid);
                if (this.fluidData != null) {
                    data.writeTagCompound(this.fluidData);
                }
            }
        }
    }

    @Override
    public void deserBytes(ByteUtils.Reader data) {
        super.deserBytes(data);
        if (!this.locked) {
            byte mask = data.readByte();
            if ((mask & 1) != 0) {
                this.setFluid(data.readFluid(), (mask & 2) != 0 ? data.readTagCompound() : null);
            } else {
                this.setFluid(null);
            }
        }
    }
}

