/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.client.gui.component.impl;

import io.github.phantamanta44.libnine.client.gui.component.GuiComponent;
import io.github.phantamanta44.libnine.util.render.TextureRegion;
import io.github.phantamanta44.libnine.util.world.IRedstoneControllable;

public class GuiComponentRedstoneControl
extends GuiComponent {
    private final TextureRegion bg;
    private final TextureRegion bgHover;
    private final TextureRegion ignored;
    private final TextureRegion direct;
    private final TextureRegion inverted;
    private final int innerX;
    private final int innerY;
    private final String descIgnored;
    private final String descDirect;
    private final String descInverted;
    private final IRedstoneControllable target;

    public GuiComponentRedstoneControl(int x, int y, TextureRegion bg, TextureRegion bgHover, TextureRegion ignored, TextureRegion direct, TextureRegion inverted, int offsetX, int offsetY, String descIgnored, String descDirect, String descInverted, IRedstoneControllable target) {
        super(x, y, bg.getWidth(), bg.getHeight());
        this.bg = bg;
        this.bgHover = bgHover;
        this.ignored = ignored;
        this.direct = direct;
        this.inverted = inverted;
        this.innerX = x + offsetX;
        this.innerY = y + offsetY;
        this.descIgnored = descIgnored;
        this.descDirect = descDirect;
        this.descInverted = descInverted;
        this.target = target;
    }

    @Override
    public void render(float partialTicks, int mX, int mY, boolean mouseOver) {
        (mouseOver ? this.bgHover : this.bg).draw(this.x, this.y, this.width, this.height);
        switch (this.target.getRedstoneBehaviour()) {
            case IGNORED: {
                this.ignored.draw(this.innerX, this.innerY, this.width, this.height);
                break;
            }
            case DIRECT: {
                this.direct.draw(this.innerX, this.innerY, this.width, this.height);
                break;
            }
            case INVERTED: {
                this.inverted.draw(this.innerX, this.innerY, this.width, this.height);
            }
        }
    }

    @Override
    public void renderTooltip(float partialTicks, int mX, int mY) {
        switch (this.target.getRedstoneBehaviour()) {
            case IGNORED: {
                this.drawTooltip(this.descIgnored, mX, mY);
                break;
            }
            case DIRECT: {
                this.drawTooltip(this.descDirect, mX, mY);
                break;
            }
            case INVERTED: {
                this.drawTooltip(this.descInverted, mX, mY);
            }
        }
    }

    @Override
    public boolean onClick(int mX, int mY, int button, boolean mouseOver) {
        return mouseOver;
    }
}

