/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.capability.provider;

import io.github.phantamanta44.libnine.util.tuple.IPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class CapabilityBrokerDirPredicated
implements ICapabilityProvider {
    private final Map<Capability<?>, Collection<IPair<BiPredicate, ?>>> capabilities = new IdentityHashMap();

    public <T> CapabilityBrokerDirPredicated with(Capability<T> capability, T aspect, BiPredicate<T, EnumFacing> condition) {
        this.capabilities.computeIfAbsent(capability, k -> new ArrayList()).add(IPair.of(condition, aspect));
        return this;
    }

    public <T> CapabilityBrokerDirPredicated with(Capability<T> capability, T aspect) {
        return this.with(capability, aspect, (a, f) -> true);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        Collection<IPair<BiPredicate, ?>> impls = this.capabilities.get(capability);
        if (impls == null) {
            return false;
        }
        for (IPair<BiPredicate, ?> entry : impls) {
            if (!entry.getA().test(entry.getB(), facing)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        Collection<IPair<BiPredicate, ?>> impls = this.capabilities.get(capability);
        if (impls == null) {
            return null;
        }
        for (IPair<BiPredicate, ?> entry : impls) {
            if (!entry.getA().test(entry.getB(), facing)) continue;
            return (T)entry.getB();
        }
        return null;
    }
}

