/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine;

import io.github.phantamanta44.libnine.Virtue;
import io.github.phantamanta44.libnine.block.L9Block;
import io.github.phantamanta44.libnine.block.L9BlockStated;
import io.github.phantamanta44.libnine.block.state.IBlockModelMapper;
import io.github.phantamanta44.libnine.gui.GuiIdentity;
import io.github.phantamanta44.libnine.gui.L9Container;
import io.github.phantamanta44.libnine.gui.L9GuiHandler;
import io.github.phantamanta44.libnine.item.L9Item;
import io.github.phantamanta44.libnine.tile.L9TileEntity;
import io.github.phantamanta44.libnine.util.LazyConstant;
import io.github.phantamanta44.libnine.util.format.FormatUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;

public class Registrar {
    private final Map<Class<? extends L9TileEntity>, Virtue> tileVirtueTable;
    private final Map<Class<? extends L9Container>, Virtue> containerVirtueTable;
    @Nullable
    private Virtue bound;
    private final List<L9Block> virtueBlocks = new LinkedList<L9Block>();
    private final List<L9Item> virtueItems = new LinkedList<L9Item>();
    private final List<Item> rqItems = new LinkedList<Item>();
    private final List<L9Block> rqBlocks = new LinkedList<L9Block>();
    private final List<TileRegistration> rqTileEntities = new LinkedList<TileRegistration>();
    private final List<SoundEvent> rqSounds = new LinkedList<SoundEvent>();

    public Registrar() {
        this.tileVirtueTable = new HashMap<Class<? extends L9TileEntity>, Virtue>();
        this.containerVirtueTable = new HashMap<Class<? extends L9Container>, Virtue>();
    }

    public Virtue lookUpTileVirtue(Class<? extends L9TileEntity> clazz) {
        return this.tileVirtueTable.get(clazz);
    }

    public Virtue lookUpContainerVirtue(Class<? extends L9Container> clazz) {
        return this.containerVirtueTable.get(clazz);
    }

    public void begin(Virtue virtue) {
        if (this.bound != null) {
            throw new IllegalStateException(String.format("Could not bind virtue %s because %s was already bound!", virtue.getModId(), this.getBound().getModId()));
        }
        this.bound = virtue;
    }

    public void end() {
        if (this.bound == null) {
            throw new IllegalStateException("No virtue is bound!");
        }
        this.virtueItems.forEach(L9Item::postInit);
        this.virtueItems.clear();
        this.virtueBlocks.forEach(L9Block::postInit);
        this.virtueBlocks.clear();
        this.bound = null;
    }

    public Virtue getBound() {
        if (this.bound == null) {
            throw new IllegalStateException("No virtue is bound!");
        }
        return this.bound;
    }

    public void queueItemReg(Item item) {
        this.rqItems.add(item);
        if (item instanceof L9Item) {
            this.virtueItems.add((L9Item)item);
        }
    }

    public void queueBlockReg(L9Block block) {
        this.rqBlocks.add(block);
        this.virtueBlocks.add(block);
    }

    void queueTileEntityReg(String modId, String className) {
        this.rqTileEntities.add(new TileRegistration(modId, className));
    }

    public void queueItemModelReg(L9Item item, int meta, String model, String variant) {
    }

    public void queueItemModelReg(L9Item item, int meta, String model) {
    }

    public void queueItemModelReg(L9Item item, String model) {
    }

    public void queueItemBlockModelReg(L9Block block, int meta, String model, String variant) {
    }

    public void queueItemBlockModelReg(L9Block block, int meta, String model) {
    }

    public void queueItemBlockModelReg(L9Block block, String model) {
    }

    public void queueBlockStateMapperReg(L9BlockStated block, IBlockModelMapper mapper) {
    }

    public void queueItemColourHandlerReg(IItemColor handler, Item ... items) {
    }

    public void queueBlockColourHandlerReg(IBlockColor handler, L9Block ... blocks) {
    }

    public void onRegisterColourHandlers() {
    }

    public void queueSoundEventReg(SoundEvent sound) {
        this.rqSounds.add(sound);
    }

    public <T extends TileEntity> void queueTESRReg(Class<T> clazz, TileEntitySpecialRenderer<T> renderer) {
    }

    public <T extends Container> void queueGuiServerReg(GuiIdentity<T, ?> identity, L9GuiHandler.IContainerFactory<T> factory) {
        this.getBound().markUsesContainers();
        this.getBound().getGuiHandler().registerServerGui(identity, factory);
        this.containerVirtueTable.put(identity.getContainerClass(), this.getBound());
    }

    public <S extends Container, C> void queueGuiClientReg(GuiIdentity<S, C> identity, L9GuiHandler.IGuiFactory<S, C> factory) {
    }

    protected void hookEvents() {
        MinecraftForge.EVENT_BUS.register((Object)new RegistrarHook());
    }

    private static class TileRegistration {
        private final LazyConstant<Virtue> virtue = new LazyConstant<Virtue>(() -> Virtue.forMod(modId));
        private final LazyConstant<Class> clazz = new LazyConstant<Class>(() -> {
            try {
                return Class.forName(className);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid tile entity class: " + className, e);
            }
        });

        TileRegistration(String modId, String className) {
        }

        void register() {
            GameRegistry.registerTileEntity((Class)this.clazz.get(), (ResourceLocation)this.virtue.get().newResourceLocation(FormatUtils.formatClassName(this.clazz.get())));
            this.virtue.get().markUsesTileEntities();
        }
    }

    private class RegistrarHook {
        private RegistrarHook() {
        }

        @SubscribeEvent
        public void onRegisterItems(RegistryEvent.Register<Item> event) {
            Registrar.this.rqItems.forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
        }

        @SubscribeEvent
        public void onRegisterBlocks(RegistryEvent.Register<Block> event) {
            Registrar.this.rqBlocks.forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
            Registrar.this.rqTileEntities.forEach(t -> {
                t.register();
                Registrar.this.tileVirtueTable.put(((TileRegistration)t).clazz.get(), ((TileRegistration)t).virtue.get());
            });
        }

        @SubscribeEvent
        public void onRegisterSounds(RegistryEvent.Register<SoundEvent> event) {
            Registrar.this.rqSounds.forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
        }
    }
}

