/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.mixin.betterquesting.api2.utils;

import betterquesting.api2.utils.BQThreadedIO;
import betterquesting.core.BetterQuesting;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={BQThreadedIO.class}, remap=false)
public abstract class BQThreadedIOMixin {
    @Shadow
    private ExecutorService exService;

    @Overwrite
    public void shutdown() {
        try {
            BetterQuesting.logger.info("Shutting down BQThreadedIO...");
            this.exService.shutdown();
            if (!this.exService.awaitTermination(60L, TimeUnit.SECONDS)) {
                throw new InterruptedException();
            }
            BetterQuesting.logger.info("Successfully terminated threads, continuing with shutdown process...");
        }
        catch (Exception ex) {
            BetterQuesting.logger.error("Failed to terminate threads, continuing with shutdown process...");
        }
    }
}

