/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.configuration.category.mixin;

import com.google.common.collect.Lists;
import io.github.lxgaming.sledgehammer.configuration.annotation.Mapping;
import io.github.lxgaming.sledgehammer.lib.configurate.objectmapping.Setting;
import io.github.lxgaming.sledgehammer.lib.configurate.objectmapping.serialize.ConfigSerializable;
import java.util.List;

@ConfigSerializable
public class CoreMixinCategory {
    @Mapping(value="core.advancements.AdvancementManagerMixin_Reload")
    @Setting(value="advancement-reload", comment="If 'true', advancements will not be reloaded on world load.")
    private boolean advancementReload = false;
    @Mapping.List(value={@Mapping(value="core.advancements.AdvancementManagerMixin_Stacktrace"), @Mapping(value="forge.common.ForgeHooksMixin_Advancement")})
    @Setting(value="advancement-stacktrace", comment="If 'true', prints a single message instead of a stacktrace for advancement errors.")
    private boolean advancementStacktrace = false;
    @Mapping(value="core.client.renderer.tileentity.TileEntityBannerRendererMixin")
    @Setting(value="banner-freezing", comment="If 'true', fixes banners freezing when the world is old enough (MC-63720).")
    private boolean bannerFreezing = false;
    @Mapping(value="core.world.biome.BiomeProviderMixin")
    @Setting(value="biome-provider", comment="If 'true', fixes NullPointerException in BiomeProvider::findBiomePosition.")
    private boolean biomeProvider = false;
    @Mapping(value="core.block.BlockGrassMixin")
    @Setting(value="block-grass", comment="If 'true', prevents Grass turning into Dirt.")
    private boolean blockGrass = false;
    @Mapping(value="core.block.BlockIceMixin")
    @Setting(value="block-ice", comment="If 'true', prevents Ice turning into Water.")
    private boolean blockIce = false;
    @Mapping.List(value={@Mapping(value="core.world.chunk.storage.AnvilChunkLoaderMixin"), @Mapping(value="core.world.chunk.storage.RegionFileChunkBufferMixin")})
    @Setting(value="chunk-save-alert", comment="If 'true', alert players with permission (sledgehammer.broadcast.chunksave) when a chunk fails to save.")
    private boolean chunkSaveAlert = false;
    @Setting(value="chunk-save-blacklist", comment="Items to remove from chunks.")
    private List<String> chunkSaveBlacklist = Lists.newArrayList((Object[])new String[]{"minecraft:writable_book", "minecraft:written_book"});
    @Mapping.List(value={@Mapping(value="core.world.chunk.storage.AnvilChunkLoaderMixin"), @Mapping(value="core.world.chunk.storage.RegionFileChunkBufferMixin")})
    @Setting(value="chunk-save-purge-all", comment="If 'true', removes all Entities and TileEntities from chunks that fail to save.")
    private boolean chunkSavePurgeAll = false;
    @Mapping.List(value={@Mapping(value="core.world.chunk.storage.AnvilChunkLoaderMixin"), @Mapping(value="core.world.chunk.storage.RegionFileChunkBufferMixin")})
    @Setting(value="chunk-save-purge-blacklist", comment="If 'true', removes all blacklisted items from chunks that fail to save.")
    private boolean chunkSavePurgeBlacklist = false;
    @Mapping.List(value={@Mapping(value="core.world.chunk.storage.AnvilChunkLoaderMixin"), @Mapping(value="core.world.chunk.storage.RegionFileChunkBufferMixin")})
    @Setting(value="chunk-save-shutdown", comment="If 'true', generates a crash report and safely stops the server if a chunk fails to save.")
    private boolean chunkSaveShutdown = false;
    @Mapping.List(value={@Mapping(value="core.client.renderer.entity.RenderMinecartMixin"), @Mapping(value="core.client.renderer.entity.RenderTNTPrimedMixin"), @Mapping(value="core.client.renderer.entity.RenderWolfMixin")})
    @Setting(value="dark-blocks", comment="If 'true', fixes BlockRendererDispatcher.renderBlockBrightness producing extremely dark blocks in certain cirumstances (MC-6932, MC-41825).")
    private boolean darkBlocks = false;
    @Mapping(value="core.entity.EntityMixin_IDOffset")
    @Setting(value="entity-id-offset", comment="If 'true', prevents ID 0 from being assigned to entities. Fixes bugs like MC-111480.")
    private boolean entityIdOffset = false;
    @Mapping(value="core.entity.EntityTrackerMixin")
    @Setting(value="entity-tracker", comment="If 'true', prevents ConcurrentModificationException in EntityTracker.")
    private boolean entityTracker = false;
    @Mapping.List(value={@Mapping(value="core.entity.EntityLivingMixin_Despawning"), @Mapping(value="core.world.WorldMixin_Despawning")})
    @Setting(value="fix-mobs-not-despawning", comment="If 'true', avoids MC-2536 by running mob despawning checks in lazy chunks. This will probably break farms which rely on vanilla 1.12 mechanics. You have been warned.")
    private boolean fixMobsNotDespawning = false;
    @Mapping(value="core.entity.EntityLivingMixin_DespawnRanges")
    @Setting(value="fix-impossible-mob-despawn-range", comment="If 'true', adjusts the despawn ranges of mobs (32/128 blocks) on low render distances. Requires fix-mobs-not-despawning so that mobs are eligible for despawning. This has no effect on Sponge as it makes these settings configurable.")
    private boolean fixImpossibleMobDespawnRange = false;
    @Mapping(value="core.network.play.server.SPacketChunkDataMixin")
    @Setting(value="get-update-tag-crash", comment="If 'true', adds TileEntity data to the crash report from calls to 'getUpdateTag' that fail.")
    private boolean getUpdateTagCrash = false;
    @Mapping.List(value={@Mapping(value="core.client.renderer.entity.layers.LayerArrowMixin"), @Mapping(value="core.client.renderer.entity.layers.LayerCreeperChargeMixin"), @Mapping(value="core.client.renderer.entity.layers.LayerSpiderEyesMixin"), @Mapping(value="core.client.renderer.entity.RenderDragonMixin"), @Mapping(value="core.client.renderer.entity.RenderGuardianMixin")})
    @Setting(value="gl-state-bugs", comment="If 'true', fixes some minor rendering glitches in vanilla.")
    private boolean glStateBugs = false;
    @Mapping(value="core.util.text.TextComponentTranslationMixin")
    @Setting(value="invalid-translation", comment="If 'true', prevents crash due to invalid translation keys.")
    private boolean invalidTranslation = false;
    @Mapping(value="core.item.ItemStackMixin_Exploit")
    @Setting(value="itemstack-exploit", comment="If 'true', fixes MC-134716 - Player kick exploit.")
    private boolean itemstackExploit = false;
    @Mapping(value="core.util.LazyLoadBaseMixin")
    @Setting(value="lazyload-thread-safe", comment="If 'true', makes LazyLoad Thread-safe (Should fix MC-68381).")
    private boolean lazyLoadThreadSafe = false;
    @Mapping(value="core.network.NetHandlerPlayServerMixin_Sleep")
    @Setting(value="leave-sleep", comment="If 'true', allows players to exit the sleep screen.")
    private boolean leaveSleep = false;
    @Mapping.List(value={@Mapping(value="core.item.ItemWritableBookMixin"), @Mapping(value="core.network.NetHandlerPlayServerMixin_Book")})
    @Setting(value="limit-books", comment="If 'true', enforces limits for books to 50 pages with 255 characters for each.")
    private boolean limitBooks = false;
    @Mapping(value="core.network.NetworkSystemMixin")
    @Setting(value="network-system", comment="If 'true', fixes potential deadlock on shutdown.")
    private boolean networkSystem = false;
    @Mapping.List(value={@Mapping(value="core.block.BlockDynamicLiquidMixin"), @Mapping(value="core.block.BlockLiquidAccessor")})
    @Setting(value="optimize-liquid-drain", comment="If 'true', fixes depth calculation that causes unnecessary block updates.")
    private boolean optimizeLiquidDrain = false;
    @Mapping(value="core.server.management.PlayerChunkMapMixin")
    @Setting(value="player-chunk-map", comment="If 'true', prevents ConcurrentModificationException in PlayerChunkMap.")
    private boolean playerChunkMap = false;
    @Mapping.List(value={@Mapping(value="core.client.renderer.RenderGlobalMixin"), @Mapping(value="core.client.tileentity.TileEntityBannerMixin")})
    @Setting(value="premature-culling", comment="If 'true', fixes MC-88176 (entities culled too aggresively at subchunk boundaries) and MC-72166 (banners invisible at some angles).")
    private boolean prematureCulling = false;
    @Mapping(value="core.world.WorldMixin_RoofSpawning")
    @Setting(value="roof-lighting", comment="If 'true', prevents the top of the world from being considered completely dark. Fixes MC-68565.")
    private boolean roofLighting = false;
    @Mapping(value="core.client.renderer.EntityRendererMixin")
    @Setting(value="speed-up-chunk-rendering", comment="If 'true', changes the renderer's target FPS to be 30 (matching 1.15-pre1) instead of the maximum FPS in game options. This helps with chunks not loading on the client.")
    private boolean speedUpChunkRendering = false;
    @Mapping(value="core.world.WorldMixin_ChunkUnload")
    @Setting(value="tile-entity-chunk-unload", comment="If 'true', prevents unloading TileEntities from loading chunks")
    private boolean tileEntityChunkUnload = false;
    @Mapping(value="core.network.play.server.SPacketJoinGameMixin")
    @Setting(value="world-type-length", comment="If 'true', increases the maximum length for a WorldType name in SPacketJoinGame packet.")
    private boolean worldTypeLength = false;
    @Mapping(value="core.client.renderer.RenderGlobalMixin_VoidBox")
    @Setting(value="void-box", comment="If 'true', removes the box around the player at low Y levels.")
    private boolean voidBox = false;

    public boolean isAdvancementReload() {
        return this.advancementReload;
    }

    public boolean isAdvancementStacktrace() {
        return this.advancementStacktrace;
    }

    public boolean isBiomeProvider() {
        return this.biomeProvider;
    }

    public boolean isBlockGrass() {
        return this.blockGrass;
    }

    public boolean isBlockIce() {
        return this.blockIce;
    }

    public boolean isChunkSaveAlert() {
        return this.chunkSaveAlert;
    }

    public List<String> getChunkSaveBlacklist() {
        return this.chunkSaveBlacklist;
    }

    public boolean isChunkSavePurgeAll() {
        return this.chunkSavePurgeAll;
    }

    public boolean isChunkSavePurgeBlacklist() {
        return this.chunkSavePurgeBlacklist;
    }

    public boolean isChunkSaveShutdown() {
        return this.chunkSaveShutdown;
    }

    public boolean isEntityTracker() {
        return this.entityTracker;
    }

    public boolean isFixMobsNotDespawning() {
        return this.fixMobsNotDespawning;
    }

    public boolean isFixImpossibleMobDespawnRange() {
        return this.fixImpossibleMobDespawnRange;
    }

    public boolean isGetUpdateTagCrash() {
        return this.getUpdateTagCrash;
    }

    public boolean isInvalidTranslation() {
        return this.invalidTranslation;
    }

    public boolean isItemstackExploit() {
        return this.itemstackExploit;
    }

    public boolean isLazyLoadThreadSafe() {
        return this.lazyLoadThreadSafe;
    }

    public boolean isLeaveSleep() {
        return this.leaveSleep;
    }

    public boolean isLimitBooks() {
        return this.limitBooks;
    }

    public boolean isNetworkSystem() {
        return this.networkSystem;
    }

    public boolean isOptimizeLiquidDrain() {
        return this.optimizeLiquidDrain;
    }

    public boolean isPlayerChunkMap() {
        return this.playerChunkMap;
    }

    public boolean isTileEntityChunkUnload() {
        return this.tileEntityChunkUnload;
    }

    public boolean isWorldTypeLength() {
        return this.worldTypeLength;
    }
}

