/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.worldgen.trees;

import gregtech.api.util.function.TriConsumer;
import gregtechfoodoption.GTFOValues;
import gregtechfoodoption.item.GTFOMetaItem;
import gregtechfoodoption.utils.GTFOUtils;
import gregtechfoodoption.worldgen.condition.BiomeCondition;
import gregtechfoodoption.worldgen.condition.TemperatureRainfallCondition;
import gregtechfoodoption.worldgen.trees.GTFOTree;
import java.util.Random;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class OrangeTree
extends GTFOTree {
    public static int LEAVES_COLOR = 7784748;

    public OrangeTree() {
        super("orange", 1);
        this.addCondition(new BiomeCondition(Biomes.field_150587_Y, 6, 0.25));
        this.addCondition(new BiomeCondition(Biomes.field_150588_X, 3, 0.45));
        this.addCondition(new TemperatureRainfallCondition(3, 1.2, 1.15, 0.0, 0.2));
    }

    @Override
    public int getMinTrunkHeight(Random random) {
        return 2 + random.nextInt(3);
    }

    @Override
    protected void generateTrunk(World world, BlockPos.MutableBlockPos pos, int maxHeight, Random random, TriConsumer<World, BlockPos, IBlockState> notifier) {
        BlockPos.MutableBlockPos upN = GTFOUtils.copy((BlockPos)pos);
        for (int height = 0; height < maxHeight; ++height) {
            notifier.accept((Object)world, (Object)upN, (Object)this.logState.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y));
            if (height > 0) {
                EnumFacing randomFacing = EnumFacing.func_176731_b((int)random.nextInt(4));
                notifier.accept((Object)world, (Object)upN.func_177972_a(randomFacing), (Object)this.logState.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)randomFacing.func_176740_k())));
            }
            upN.func_189536_c(EnumFacing.UP);
        }
    }

    @Override
    protected void generateLeaves(World world, BlockPos.MutableBlockPos pos, int trunkHeight, Random random, TriConsumer<World, BlockPos, IBlockState> notifier) {
        BlockPos.MutableBlockPos currentYPos = GTFOUtils.copy((BlockPos)pos);
        currentYPos.func_189536_c(EnumFacing.UP);
        int i = 0;
        while (i < trunkHeight + 1) {
            Iterable iterator = BlockPos.func_177980_a((BlockPos)currentYPos.func_177967_a(EnumFacing.NORTH, 2).func_177967_a(EnumFacing.WEST, 2), (BlockPos)currentYPos.func_177967_a(EnumFacing.SOUTH, 2).func_177967_a(EnumFacing.EAST, 2));
            int finalI = i++;
            iterator.forEach(leavesPos -> {
                if (Math.abs(leavesPos.func_177958_n() - currentYPos.func_177958_n()) + Math.abs(leavesPos.func_177952_p() - currentYPos.func_177952_p()) < 3 && (finalI < trunkHeight || Math.abs(leavesPos.func_177958_n() - currentYPos.func_177958_n()) + Math.abs(leavesPos.func_177952_p() - currentYPos.func_177952_p()) == 1 || random.nextInt(2) == 0)) {
                    notifier.accept((Object)world, leavesPos, (Object)this.getNaturalLeavesState());
                }
            });
            currentYPos.func_189536_c(EnumFacing.UP);
        }
        notifier.accept((Object)world, (Object)currentYPos, (Object)this.getNaturalLeavesState());
    }

    @Override
    public int getBlockColor(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        return LEAVES_COLOR;
    }

    @Override
    public int getItemColor(ItemStack stack, int tintIndex) {
        return LEAVES_COLOR;
    }

    @Override
    protected int getMooreRadiusAtHeight(int height, int trunkHeight) {
        if (height == 0) {
            return 0;
        }
        if (height < trunkHeight + 1) {
            return 1;
        }
        return 0;
    }

    @Override
    public ItemStack getAppleDrop(int chance) {
        if (GTFOValues.rand.nextInt(chance / 10) == 0) {
            return GTFOMetaItem.ORANGE.getStackForm(GTFOValues.rand.nextInt(2) + 1);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getApple() {
        return GTFOMetaItem.ORANGE.getStackForm();
    }
}

