/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.worldgen.trees;

import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.GTUtility;
import gregtech.api.util.function.TriConsumer;
import gregtech.common.items.MetaItems;
import gregtech.loaders.WoodTypeEntry;
import gregtech.loaders.recipe.WoodRecipeLoader;
import gregtechfoodoption.block.GTFOMetaBlocks;
import gregtechfoodoption.block.tree.GTFOBlockLeaves;
import gregtechfoodoption.block.tree.GTFOBlockLog;
import gregtechfoodoption.block.tree.GTFOBlockSapling;
import gregtechfoodoption.recipe.GTFORecipeMaps;
import gregtechfoodoption.utils.GTFOUtils;
import gregtechfoodoption.worldgen.GTFOFeature;
import gregtechfoodoption.worldgen.GTFOFeatureGen;
import gregtechfoodoption.worldgen.trees.GTFOTreeGen;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public abstract class GTFOTree
extends GTFOFeature {
    public final String name;
    public IBlockState logState;
    public IBlockState leavesState;
    public IBlockState saplingState;
    private final int seed;
    public static final List<GTFOTree> TREES = new ArrayList<GTFOTree>();

    public GTFOTree(String name, int seed) {
        super(seed);
        this.name = name;
        this.seed = seed;
        this.FEATURE_GROW_INSTANCE = new GTFOTreeGen(true, this);
        this.WORLD_GEN_INSTANCE = new GTFOTreeGen(false, this);
        TREES.add(this);
    }

    @Override
    public boolean generate(World world, BlockPos.MutableBlockPos pos, Random random, TriConsumer<World, BlockPos, IBlockState> notifier) {
        IBlockState state;
        int minHeight = this.getMinTrunkHeight(random);
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + minHeight + 1 <= world.func_72800_K() && this.isSuitableLocation(world, (BlockPos)pos, minHeight) && (state = world.func_180495_p(pos.func_177977_b())).func_177230_c().canSustainPlant(state, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, this.getPlantableSapling()) && pos.func_177956_o() < world.func_72800_K() - minHeight - 1) {
            state.func_177230_c().onPlantGrow(state, world, pos.func_177977_b(), (BlockPos)pos);
            this.generateLeaves(world, pos, minHeight, random, notifier);
            this.generateTrunk(world, pos, minHeight, random, notifier);
            return true;
        }
        return false;
    }

    public int getMinTrunkHeight(Random random) {
        return random.nextInt(3) + 5;
    }

    public GTFOFeatureGen getTreeGrowInstance() {
        return this.FEATURE_GROW_INSTANCE;
    }

    public void setupBlocks() {
        GTFOBlockLeaves leaves = GTFOMetaBlocks.GTFO_LEAVES.get(this.seed / 4);
        this.leavesState = leaves.func_176203_a(this.seed % 4 << 2);
        GTFOBlockLog log = GTFOMetaBlocks.GTFO_LOGS.get(this.seed / 4);
        this.logState = log.func_176203_a(this.seed % 4 << 2);
        GTFOBlockSapling sapling = GTFOMetaBlocks.GTFO_SAPLINGS.get(this.seed / 8);
        this.saplingState = sapling.func_176203_a(this.seed % 8 << 1);
    }

    public IPlantable getPlantableSapling() {
        return (IPlantable)this.saplingState.func_177230_c();
    }

    public abstract int getBlockColor(IBlockState var1, IBlockAccess var2, BlockPos var3, int var4);

    public abstract int getItemColor(ItemStack var1, int var2);

    public boolean isReplaceable(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return this.canGrowInto(state.func_177230_c());
    }

    protected boolean canGrowInto(Block blockType) {
        Material material = blockType.func_176223_P().func_185904_a();
        return material == Material.field_151579_a || material == Material.field_151584_j || blockType == Blocks.field_150349_c || blockType == Blocks.field_150346_d || blockType == Blocks.field_150364_r || blockType == Blocks.field_150363_s || blockType == Blocks.field_150345_g || blockType == Blocks.field_150395_bd;
    }

    protected void generateLeaves(World world, BlockPos.MutableBlockPos pos, int height, Random random, TriConsumer<World, BlockPos, IBlockState> notifier) {
        for (int foliageY = pos.func_177956_o() - 3 + height; foliageY <= pos.func_177956_o() + height; ++foliageY) {
            int foliageLayer = foliageY - (pos.func_177956_o() + height);
            int foliageLayerRadius = 1 - foliageLayer / 2;
            for (int foliageX = pos.func_177958_n() - foliageLayerRadius; foliageX <= pos.func_177958_n() + foliageLayerRadius; ++foliageX) {
                int foliageRelativeX = foliageX - pos.func_177958_n();
                for (int foliageZ = pos.func_177952_p() - foliageLayerRadius; foliageZ <= pos.func_177952_p() + foliageLayerRadius; ++foliageZ) {
                    BlockPos newLeavesPos;
                    IBlockState state;
                    int foliageRelativeZ = foliageZ - pos.func_177952_p();
                    if (Math.abs(foliageRelativeX) == foliageLayerRadius && Math.abs(foliageRelativeZ) == foliageLayerRadius && (random.nextInt(2) == 0 || foliageLayer == 0) || !(state = world.func_180495_p(newLeavesPos = new BlockPos(foliageX, foliageY, foliageZ))).func_177230_c().func_176200_f((IBlockAccess)world, (BlockPos)pos) && !state.func_177230_c().canBeReplacedByLeaves(state, (IBlockAccess)world, (BlockPos)pos)) continue;
                    notifier.accept((Object)world, (Object)newLeavesPos, (Object)this.leavesState);
                }
            }
        }
    }

    protected void generateTrunk(World world, BlockPos.MutableBlockPos pos, int maxHeight, Random random, TriConsumer<World, BlockPos, IBlockState> notifier) {
        BlockPos.MutableBlockPos upN = GTFOUtils.copy((BlockPos)pos);
        for (int height = 0; height < maxHeight; ++height) {
            IBlockState state = world.func_180495_p((BlockPos)upN);
            if (state.func_177230_c().isAir(state, (IBlockAccess)world, (BlockPos)upN) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, (BlockPos)upN)) {
                notifier.accept((Object)world, (Object)pos.func_177981_b(height), (Object)this.logState.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y));
            }
            upN.func_189536_c(EnumFacing.UP);
        }
    }

    protected boolean isSuitableLocation(World world, BlockPos pos, int minHeight) {
        for (int height = 0; height <= 1 + minHeight; ++height) {
            int extraSpaceNeeded = this.getMooreRadiusAtHeight(height, minHeight);
            BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
            for (int checkX = pos.func_177958_n() - extraSpaceNeeded; checkX <= pos.func_177958_n() + extraSpaceNeeded; ++checkX) {
                for (int checkZ = pos.func_177952_p() - extraSpaceNeeded; checkZ <= pos.func_177952_p() + extraSpaceNeeded; ++checkZ) {
                    if (this.isReplaceable(world, (BlockPos)blockPos.func_181079_c(checkX, height + pos.func_177956_o(), checkZ))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected int getMooreRadiusAtHeight(int height, int trunkHeight) {
        return 0;
    }

    public void initRecipes() {
        ItemStack sapling = this.getSaplingStack();
        ItemStack planks = new ItemStack((Block)GTFOMetaBlocks.GTFO_PLANKS.get(this.seed / 16), 1, this.seed % 16);
        ItemStack log = new ItemStack((Block)GTFOMetaBlocks.GTFO_LOGS.get(this.seed / 4), 1, this.seed % 4 << 2);
        ItemStack leaves = new ItemStack((Block)GTFOMetaBlocks.GTFO_LEAVES.get(this.seed / 4), 1, this.seed % 4 << 2);
        WoodRecipeLoader.registerWoodTypeRecipe((WoodTypeEntry)new WoodTypeEntry.Builder("gregtechfoodoption", this.name).planks(planks, null).log(log).removeCharcoalRecipe().build());
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTFORecipeMaps.GREENHOUSE_RECIPES.recipeBuilder()).EUt(60)).duration(2000)).inputs(new ItemStack[]{sapling})).circuitMeta(1)).fluidInputs(new FluidStack[]{Materials.Water.getFluid(10000)})).outputs(new ItemStack[]{GTUtility.copy((int)6, (ItemStack)log), sapling, this.getApple()})).chancedOutput(sapling, 2000, 1000)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTFORecipeMaps.GREENHOUSE_RECIPES.recipeBuilder()).EUt(60)).duration(2000)).inputs(new ItemStack[]{sapling})).circuitMeta(2)).fluidInputs(new FluidStack[]{Materials.Water.getFluid(10000)})).outputs(new ItemStack[]{GTUtility.copy((int)5, (ItemStack)log)})).chancedOutput(sapling, 1000, 1000)).outputs(new ItemStack[]{GTUtility.copy((int)20, (ItemStack)leaves)})).buildAndRegister();
        if (!this.getApple().func_190926_b()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTFORecipeMaps.GREENHOUSE_RECIPES.recipeBuilder()).EUt(60)).duration(3000)).inputs(new ItemStack[]{sapling})).circuitMeta(3)).fluidInputs(new FluidStack[]{Materials.Water.getFluid(20000)})).outputs(new ItemStack[]{GTUtility.copy((int)5, (ItemStack)log)})).chancedOutput(sapling, 8000, 200)).outputs(new ItemStack[]{GTUtility.copy((int)3, (ItemStack)this.getApple())})).chancedOutput(GTUtility.copy((int)2, (ItemStack)this.getApple()), 4000, 500)).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTFORecipeMaps.GREENHOUSE_RECIPES.recipeBuilder()).EUt(60)).duration(2000)).inputs(new ItemStack[]{sapling, MetaItems.FERTILIZER.getStackForm(2)})).circuitMeta(4)).fluidInputs(new FluidStack[]{Materials.Water.getFluid(20000)})).outputs(new ItemStack[]{GTUtility.copy((int)10, (ItemStack)log), sapling})).chancedOutput(sapling, 8000, 200)).outputs(new ItemStack[]{GTUtility.copy((int)3, (ItemStack)this.getApple())})).buildAndRegister();
        }
        if (this.getSap() != null) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTFORecipeMaps.GREENHOUSE_RECIPES.recipeBuilder()).EUt(90)).duration(3000)).inputs(new ItemStack[]{sapling})).notConsumable(OrePrefix.toolHeadChainsaw, Materials.Steel)).circuitMeta(5)).fluidInputs(new FluidStack[]{Materials.Water.getFluid(10000)})).outputs(new ItemStack[]{GTUtility.copy((int)5, (ItemStack)log)})).chancedOutput(sapling, 8000, 200)).fluidOutputs(new FluidStack[]{new FluidStack(this.getSap(), 4000)})).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)GTFORecipeMaps.GREENHOUSE_RECIPES.recipeBuilder()).EUt(90)).duration(4000)).inputs(new ItemStack[]{sapling, MetaItems.FERTILIZER.getStackForm(1)})).notConsumable(OrePrefix.toolHeadChainsaw, Materials.Steel)).circuitMeta(6)).fluidInputs(new FluidStack[]{Materials.Water.getFluid(10000)})).outputs(new ItemStack[]{GTUtility.copy((int)8, (ItemStack)log)})).chancedOutput(sapling, 8000, 200)).fluidOutputs(new FluidStack[]{new FluidStack(this.getSap(), 16000)})).buildAndRegister();
        }
    }

    public ItemStack getAppleDrop(int chance) {
        return ItemStack.field_190927_a;
    }

    protected IBlockState getNaturalLeavesState() {
        return this.leavesState.func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(true));
    }

    public ItemStack getApple() {
        return ItemStack.field_190927_a;
    }

    public Fluid getSap() {
        return null;
    }

    public ItemStack getSaplingStack() {
        return new ItemStack((Block)GTFOMetaBlocks.GTFO_SAPLINGS.get(this.seed / 8), 1, this.seed % 8 << 1);
    }
}

