/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.worldgen.trees;

import gregtech.api.util.function.TriConsumer;
import gregtechfoodoption.GTFOValues;
import gregtechfoodoption.item.GTFOMetaItem;
import gregtechfoodoption.utils.GTFOUtils;
import gregtechfoodoption.worldgen.condition.TemperatureRainfallCondition;
import gregtechfoodoption.worldgen.trees.GTFOTree;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CoconutTree
extends GTFOTree {
    public static int LEAVES_COLOR = 6651676;

    public CoconutTree() {
        super("coconut", 9);
        this.addCondition(new TemperatureRainfallCondition(5, 1.5, 0.8, 0.9, 0.5));
    }

    @Override
    public int getBlockColor(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        return LEAVES_COLOR;
    }

    @Override
    public int getItemColor(ItemStack stack, int tintIndex) {
        return LEAVES_COLOR;
    }

    @Override
    protected void generateLeaves(World world, BlockPos.MutableBlockPos pos, int height, Random random, TriConsumer<World, BlockPos, IBlockState> notifier) {
        int i;
        BlockPos.MutableBlockPos posCopy = GTFOUtils.copy(pos.func_177981_b(height - 1));
        int sideVariance = random.nextInt(4);
        for (int i2 = 0; i2 < 3; ++i2) {
            posCopy.func_189536_c(EnumFacing.UP);
            notifier.accept((Object)world, (Object)posCopy, (Object)this.getNaturalLeavesState());
            if (i2 != 1 && i2 != 2) continue;
            posCopy.func_189536_c(EnumFacing.func_176731_b((int)sideVariance));
            notifier.accept((Object)world, (Object)posCopy, (Object)this.getNaturalLeavesState());
        }
        posCopy.func_189536_c(EnumFacing.func_176731_b((int)sideVariance));
        notifier.accept((Object)world, (Object)posCopy, (Object)this.getNaturalLeavesState());
        for (i = 0; i < 4; ++i) {
            int leafOffset = random.nextInt(2);
            BlockPos.MutableBlockPos posCopy2 = GTFOUtils.copy(pos.func_177981_b(height - 2 + leafOffset));
            int sideVariance2 = random.nextInt(2);
            for (int j = 0; j < 3; ++j) {
                posCopy2.func_189536_c(EnumFacing.func_176731_b((int)i));
                notifier.accept((Object)world, (Object)posCopy2, (Object)this.getNaturalLeavesState());
                if (j == 0) {
                    posCopy2.func_189536_c(EnumFacing.UP);
                    notifier.accept((Object)world, (Object)posCopy2, (Object)this.getNaturalLeavesState());
                }
                if (random.nextInt(3) != 0) continue;
                if (sideVariance2 == 0) {
                    posCopy2.func_189536_c(EnumFacing.func_176731_b((int)i).func_176746_e());
                    notifier.accept((Object)world, (Object)posCopy2, (Object)this.getNaturalLeavesState());
                    continue;
                }
                posCopy2.func_189536_c(EnumFacing.func_176731_b((int)i).func_176735_f());
                notifier.accept((Object)world, (Object)posCopy2, (Object)this.getNaturalLeavesState());
            }
        }
        for (i = 0; i < 4; ++i) {
            notifier.accept((Object)world, (Object)pos.func_177981_b(height - 1).func_177972_a(EnumFacing.func_176731_b((int)i)), (Object)this.getNaturalLeavesState());
            notifier.accept((Object)world, (Object)pos.func_177981_b(height - 1).func_177972_a(EnumFacing.func_176731_b((int)i)).func_177972_a(EnumFacing.func_176731_b((int)i).func_176746_e()), (Object)this.getNaturalLeavesState());
        }
    }

    @Override
    public ItemStack getAppleDrop(int chance) {
        if (GTFOValues.rand.nextInt(chance / 7) == 0) {
            return GTFOMetaItem.COCONUT.getStackForm(GTFOValues.rand.nextInt(2));
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getApple() {
        return GTFOMetaItem.COCONUT.getStackForm();
    }
}

