/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.worldgen.trees;

import gregtech.api.util.function.TriConsumer;
import gregtechfoodoption.GTFOValues;
import gregtechfoodoption.item.GTFOMetaItem;
import gregtechfoodoption.utils.GTFOUtils;
import gregtechfoodoption.worldgen.condition.BiomeCondition;
import gregtechfoodoption.worldgen.condition.TemperatureRainfallCondition;
import gregtechfoodoption.worldgen.trees.GTFOTree;
import java.util.Random;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BananaTree
extends GTFOTree {
    public static int LEAVES_COLOR = 3762734;

    public BananaTree() {
        super("banana", 0);
        this.addCondition(new BiomeCondition(Biomes.field_76782_w, 5, 0.35));
        this.addCondition(new BiomeCondition(Biomes.field_150574_L, 5, 0.3));
        this.addCondition(new BiomeCondition(Biomes.field_76792_x, 5, 0.35));
        this.addCondition(new BiomeCondition(Biomes.field_185446_X, 5, 0.3));
        this.addCondition(new BiomeCondition(Biomes.field_185447_Y, 5, 0.15));
        this.addCondition(new TemperatureRainfallCondition(5, 1.5, 0.8, 0.8, 0.4));
    }

    @Override
    protected void generateLeaves(World world, BlockPos.MutableBlockPos pos, int height, Random random, TriConsumer<World, BlockPos, IBlockState> notifier) {
        int i;
        BlockPos.MutableBlockPos posCopy = GTFOUtils.copy(pos.func_177981_b(height - 1));
        for (int i2 = 0; i2 < 3; ++i2) {
            posCopy.func_189536_c(EnumFacing.UP);
            notifier.accept((Object)world, (Object)posCopy, (Object)this.getNaturalLeavesState());
            if (i2 != 1) continue;
            posCopy.func_189536_c(EnumFacing.func_176731_b((int)random.nextInt(4)));
            notifier.accept((Object)world, (Object)posCopy, (Object)this.getNaturalLeavesState());
        }
        for (i = 0; i < 4; ++i) {
            int leafOffset = random.nextInt(2);
            BlockPos.MutableBlockPos posCopy2 = GTFOUtils.copy(pos.func_177981_b(height - 2 + leafOffset));
            for (int j = 0; j < 3; ++j) {
                posCopy2.func_189536_c(EnumFacing.func_176731_b((int)i));
                notifier.accept((Object)world, (Object)posCopy2, (Object)this.getNaturalLeavesState());
                if (j != 0) continue;
                posCopy2.func_189536_c(EnumFacing.UP);
                notifier.accept((Object)world, (Object)posCopy2, (Object)this.getNaturalLeavesState());
            }
        }
        for (i = 0; i < 4; ++i) {
            notifier.accept((Object)world, (Object)pos.func_177981_b(height - 1).func_177972_a(EnumFacing.func_176731_b((int)i)), (Object)this.getNaturalLeavesState());
            notifier.accept((Object)world, (Object)pos.func_177981_b(height - 1).func_177972_a(EnumFacing.func_176731_b((int)i)).func_177972_a(EnumFacing.func_176731_b((int)i).func_176746_e()), (Object)this.getNaturalLeavesState());
        }
    }

    @Override
    protected void generateTrunk(World world, BlockPos.MutableBlockPos pos, int maxHeight, Random random, TriConsumer<World, BlockPos, IBlockState> notifier) {
        BlockPos.MutableBlockPos upN = GTFOUtils.copy((BlockPos)pos);
        for (int height = 0; height < maxHeight; ++height) {
            IBlockState state = world.func_180495_p((BlockPos)upN);
            if (state.func_177230_c().isAir(state, (IBlockAccess)world, (BlockPos)upN) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, (BlockPos)upN)) {
                notifier.accept((Object)world, (Object)pos.func_177981_b(height), (Object)this.logState.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)(height == maxHeight - 1 ? BlockLog.EnumAxis.NONE : BlockLog.EnumAxis.Y)));
            }
            upN.func_189536_c(EnumFacing.UP);
        }
    }

    @Override
    public ItemStack getAppleDrop(int chance) {
        if (GTFOValues.rand.nextInt(chance / 8) == 0) {
            return GTFOMetaItem.BANANA.getStackForm(GTFOValues.rand.nextInt(4) + 3);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getApple() {
        return GTFOMetaItem.BANANA.getStackForm();
    }

    @Override
    public int getBlockColor(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        return LEAVES_COLOR;
    }

    @Override
    public int getItemColor(ItemStack stack, int tintIndex) {
        return LEAVES_COLOR;
    }

    @Override
    public int getMinTrunkHeight(Random random) {
        return 3 + random.nextInt(1);
    }
}

