/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.worldgen.condition;

import gregtechfoodoption.worldgen.condition.FeatureCondition;
import net.minecraft.world.biome.Biome;

public class TemperatureRainfallCondition
extends FeatureCondition {
    private double optimalTemp;
    private double optimalRain;
    private double range;
    private double commonality;

    public TemperatureRainfallCondition(int maxAmount, double commonality, double optimalTemp, double optimalRain, double range) {
        super(maxAmount);
        this.optimalTemp = optimalTemp;
        this.optimalRain = optimalRain;
        this.range = range;
        this.commonality = commonality;
    }

    private double getHabitation(Biome biome) {
        return this.range - Math.sqrt(Math.pow((double)biome.func_185353_n() - this.optimalTemp, 2.0) + Math.pow((double)biome.func_76727_i() - this.optimalRain, 2.0));
    }

    @Override
    public boolean isSatisfied(Biome biome) {
        return this.getHabitation(biome) > 0.0;
    }

    @Override
    public double getPerlinCutoff(Biome biome) {
        return 1.0 - this.getHabitation(biome) * this.commonality;
    }
}

