/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.worldgen.berries;

import gregtech.api.util.function.TriConsumer;
import gregtechfoodoption.block.GTFOBerryBush;
import gregtechfoodoption.worldgen.GTFOFeature;
import gregtechfoodoption.worldgen.berries.GTFOBerryGen;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class GTFOBerry
extends GTFOFeature {
    public final GTFOBerryBush berryBush;

    public GTFOBerry(int seed, GTFOBerryBush berryBush) {
        super(seed);
        this.berryBush = berryBush;
        this.WORLD_GEN_INSTANCE = new GTFOBerryGen(this);
    }

    @Override
    public boolean generate(World world, BlockPos.MutableBlockPos pos, Random random, TriConsumer<World, BlockPos, IBlockState> notifier) {
        if (this.canGrowAt(world, (BlockPos)pos)) {
            notifier.accept((Object)world, (Object)pos, (Object)this.berryBush.func_185528_e(2));
            for (int i = 0; i < random.nextInt(3); ++i) {
                BlockPos other = pos.func_177982_a(random.nextInt(5) - 2, random.nextInt(5) - 2, 0);
                if (!this.canGrowAt(world, other)) continue;
                notifier.accept((Object)world, (Object)other, (Object)this.berryBush.func_185528_e(2));
            }
            return true;
        }
        return false;
    }

    protected boolean canGrowInto(Block blockType) {
        Material material = blockType.func_176223_P().func_185904_a();
        return material == Material.field_151579_a || blockType == Blocks.field_150395_bd || material == Material.field_151597_y;
    }

    protected boolean canGrowAt(World world, BlockPos pos) {
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() < world.func_72800_K()) {
            IBlockState soilState = world.func_180495_p(pos.func_177977_b());
            IBlockState currentState = world.func_180495_p(pos);
            return this.canGrowInto(currentState.func_177230_c()) && soilState.func_177230_c().canSustainPlant(soilState, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this.berryBush);
        }
        return false;
    }

    public String toString() {
        return "Berry " + this.berryBush.getRegistryName();
    }
}

