/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.worldgen;

import gregtech.api.util.function.TriConsumer;
import gregtechfoodoption.utils.GTFOLog;
import gregtechfoodoption.worldgen.GTFOFeatureGen;
import gregtechfoodoption.worldgen.condition.FeatureCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.NoiseGeneratorSimplex;

public abstract class GTFOFeature {
    private NoiseGeneratorSimplex generatorSimplex;
    private final int seed;
    public final List<FeatureCondition> featureConditions = new ArrayList<FeatureCondition>();
    public static final List<GTFOFeature> FEATURES = new ArrayList<GTFOFeature>();
    protected GTFOFeatureGen FEATURE_GROW_INSTANCE;
    protected GTFOFeatureGen WORLD_GEN_INSTANCE;
    private int totalChunksChecked;
    private int totalChunksPlaced;

    public GTFOFeature(int seed) {
        this.seed = seed;
        FEATURES.add(this);
    }

    public void setWorld(World world) {
        this.generatorSimplex = new NoiseGeneratorSimplex(new Random(world.func_72905_C() + (long)this.seed));
    }

    public double getRandomStrength(int chunkX, int chunkZ) {
        return this.generatorSimplex.func_151605_a((double)chunkX * this.getPerlinScale(), (double)chunkZ * this.getPerlinScale());
    }

    public double getPerlinScale() {
        return 0.04;
    }

    public void updatePlacePercentage(boolean didSucceed) {
        ++this.totalChunksChecked;
        if (didSucceed) {
            ++this.totalChunksPlaced;
        }
        if (this.totalChunksChecked % 1000 == 0) {
            GTFOLog.logger.info("Feature " + this + " has been placed successfully in chunks " + (double)this.totalChunksPlaced / (double)(this.totalChunksChecked / 100) + " percent of the time out of " + this.totalChunksChecked + " chunks checked");
        }
    }

    public abstract boolean generate(World var1, BlockPos.MutableBlockPos var2, Random var3, TriConsumer<World, BlockPos, IBlockState> var4);

    public GTFOFeatureGen getWorldGenInstance() {
        return this.WORLD_GEN_INSTANCE;
    }

    public GTFOFeature addCondition(FeatureCondition condition) {
        this.featureConditions.add(condition);
        return this;
    }
}

