/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.utils;

import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.metaitem.stats.IItemComponent;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.ingredients.GTRecipeItemInput;
import gregtech.api.recipes.ingredients.nbtmatch.NBTCondition;
import gregtech.api.recipes.ingredients.nbtmatch.NBTMatcher;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.RandomPotionEffect;
import gregtechfoodoption.GTFOMaterialHandler;
import gregtechfoodoption.item.GTFOFoodStats;
import gregtechfoodoption.item.GTFOMetaItem;
import gregtechfoodoption.item.GTFOMetaItems;
import gregtechfoodoption.recipe.GTFORecipeMaps;
import gregtechfoodoption.recipe.builder.BakingOvenRecipeBuilder;
import gregtechfoodoption.utils.GTFOLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public class GTFOUtils {
    public static int boolToInt(boolean boole) {
        return boole ? 1 : 0;
    }

    public static int averageRGB(float divisor, int ... inputs) {
        int red = 0;
        int green = 0;
        int blue = 0;
        for (int input : inputs) {
            red += input - input % (int)Math.pow(256.0, 2.0) >> 16;
            green += (input - input % 256 >> 8) % 256;
            blue += input % 256;
        }
        int result = (int)((float)blue / divisor);
        result += (int)((float)green / divisor) << 8;
        return result += (int)((float)red / divisor) << 16;
    }

    public static ItemStack wildcardize(ItemStack itemStack) {
        itemStack.func_77964_b(Short.MAX_VALUE);
        return itemStack;
    }

    public static boolean removeAllSmelting(ItemStack input) {
        if (input.func_190926_b()) {
            GTFOLog.logger.error("Cannot remove furnace recipe with empty input.");
            GTFOLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
            RecipeMap.setFoundInvalidRecipe((boolean)true);
            return false;
        }
        ArrayList<ItemStack> removingItems = new ArrayList<ItemStack>();
        for (ItemStack stack : FurnaceRecipes.func_77602_a().func_77599_b().keySet()) {
            if (!ItemStack.func_185132_d((ItemStack)input, (ItemStack)stack)) continue;
            removingItems.add(stack);
        }
        for (ItemStack stack : removingItems) {
            FurnaceRecipes.func_77602_a().func_77599_b().remove(stack);
        }
        return removingItems.isEmpty();
    }

    public static List<ItemStack> getFish() {
        return Arrays.asList(new ItemStack(Items.field_151115_aP), new ItemStack(Items.field_151115_aP, 1, 1), new ItemStack(Items.field_151115_aP, 1, 2));
    }

    public static List<ItemStack> getMeat() {
        return Arrays.asList(new ItemStack(Items.field_151082_bd), new ItemStack(Items.field_151076_bf), new ItemStack(Items.field_179561_bm), new ItemStack(Items.field_151147_al), new ItemStack(Items.field_179558_bo));
    }

    public static List<ItemStack> getAnimalProducts() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        result.addAll(GTFOUtils.getMeat());
        result.addAll(GTFOUtils.getFish());
        return result;
    }

    public static List<Fluid> getOrganicOils() {
        return Arrays.asList(Materials.FishOil.getFluid(), Materials.SeedOil.getFluid(), GTFOMaterialHandler.OliveOil.getFluid(), GTFOMaterialHandler.FryingOil.getFluid());
    }

    public static RecipeMap<?> chemicalDehydratorProxy() {
        if (Loader.isModLoaded((String)"supersymmetry")) {
            return RecipeMap.getByName((String)"dryer");
        }
        return RecipeMaps.CHEMICAL_RECIPES;
    }

    public static RecipeMap<?> roasterProxy() {
        if (Loader.isModLoaded((String)"supersymmetry")) {
            return RecipeMap.getByName((String)"roaster");
        }
        return RecipeMaps.CHEMICAL_RECIPES;
    }

    public static RecipeMap<?> stellarForgeProxy() {
        return RecipeMaps.FORMING_PRESS_RECIPES;
    }

    public static void addBakingOvenRecipes(ItemStack input, ItemStack output, int duration, int temperature, int fuelAmount) {
        ((BakingOvenRecipeBuilder)((BakingOvenRecipeBuilder)((BakingOvenRecipeBuilder)((BakingOvenRecipeBuilder)((BakingOvenRecipeBuilder)GTFORecipeMaps.BAKING_OVEN_RECIPES.recipeBuilder()).duration(duration)).temperature(temperature).inputNBT((GTRecipeInput)new GTRecipeItemInput(input), NBTMatcher.ANY, NBTCondition.ANY)).input(OrePrefix.plank, Materials.Wood, fuelAmount * 2)).outputs(new ItemStack[]{output})).buildAndRegister();
        ItemStack inputx4 = input.func_77946_l();
        inputx4.func_190920_e(input.func_190916_E() * 4);
        ItemStack outputx4 = output.func_77946_l();
        outputx4.func_190920_e(output.func_190916_E() * 4);
        ItemStack inputx8 = input.func_77946_l();
        inputx8.func_190920_e(input.func_190916_E() * 8);
        ItemStack outputx8 = output.func_77946_l();
        outputx8.func_190920_e(output.func_190916_E() * 8);
        ((BakingOvenRecipeBuilder)((BakingOvenRecipeBuilder)((BakingOvenRecipeBuilder)((BakingOvenRecipeBuilder)((BakingOvenRecipeBuilder)GTFORecipeMaps.BAKING_OVEN_RECIPES.recipeBuilder()).duration(duration)).inputNBT((GTRecipeInput)new GTRecipeItemInput(inputx4), NBTMatcher.ANY, NBTCondition.ANY)).input(OrePrefix.gem, Materials.Coal, Math.max(fuelAmount, 1))).outputs(new ItemStack[]{outputx4})).buildAndRegister();
        ((BakingOvenRecipeBuilder)((BakingOvenRecipeBuilder)((BakingOvenRecipeBuilder)((BakingOvenRecipeBuilder)((BakingOvenRecipeBuilder)GTFORecipeMaps.BAKING_OVEN_RECIPES.recipeBuilder()).duration(duration)).inputNBT((GTRecipeInput)new GTRecipeItemInput(inputx4), NBTMatcher.ANY, NBTCondition.ANY)).input(OrePrefix.gem, Materials.Charcoal, Math.max(fuelAmount, 1))).outputs(new ItemStack[]{outputx4})).buildAndRegister();
        ((BakingOvenRecipeBuilder)((BakingOvenRecipeBuilder)((BakingOvenRecipeBuilder)((BakingOvenRecipeBuilder)((BakingOvenRecipeBuilder)GTFORecipeMaps.BAKING_OVEN_RECIPES.recipeBuilder()).duration(duration)).inputNBT((GTRecipeInput)new GTRecipeItemInput(inputx4), NBTMatcher.ANY, NBTCondition.ANY)).input(OrePrefix.dust, Materials.Coal, Math.max(fuelAmount, 1))).outputs(new ItemStack[]{outputx4})).buildAndRegister();
        ((BakingOvenRecipeBuilder)((BakingOvenRecipeBuilder)((BakingOvenRecipeBuilder)((BakingOvenRecipeBuilder)((BakingOvenRecipeBuilder)GTFORecipeMaps.BAKING_OVEN_RECIPES.recipeBuilder()).duration(duration)).inputNBT((GTRecipeInput)new GTRecipeItemInput(inputx4), NBTMatcher.ANY, NBTCondition.ANY)).input(OrePrefix.dust, Materials.Charcoal, Math.max(fuelAmount, 1))).outputs(new ItemStack[]{outputx4})).buildAndRegister();
        if (!OreDictUnifier.get((String)"dustAnthracite").func_190926_b()) {
            ((BakingOvenRecipeBuilder)((BakingOvenRecipeBuilder)((BakingOvenRecipeBuilder)((BakingOvenRecipeBuilder)((BakingOvenRecipeBuilder)GTFORecipeMaps.BAKING_OVEN_RECIPES.recipeBuilder()).duration(duration)).inputNBT((GTRecipeInput)new GTRecipeItemInput(inputx8), NBTMatcher.ANY, NBTCondition.ANY)).input("gemAnthracite", Math.max(fuelAmount, 1))).outputs(new ItemStack[]{outputx8})).buildAndRegister();
            ((BakingOvenRecipeBuilder)((BakingOvenRecipeBuilder)((BakingOvenRecipeBuilder)((BakingOvenRecipeBuilder)((BakingOvenRecipeBuilder)GTFORecipeMaps.BAKING_OVEN_RECIPES.recipeBuilder()).duration(duration)).inputNBT((GTRecipeInput)new GTRecipeItemInput(inputx8), NBTMatcher.ANY, NBTCondition.ANY)).input("dustAnthracite", Math.max(fuelAmount, 1))).outputs(new ItemStack[]{outputx8})).buildAndRegister();
        }
    }

    public static GTFOFoodStats getKebabFood(int hunger, float sat) {
        return new GTFOFoodStats(hunger, sat, false, false, GTFOMetaItem.SKEWER.getStackForm(1), new RandomPotionEffect[0]).setEatingDuration(12);
    }

    @SideOnly(value=Side.CLIENT)
    public static void addPotionTooltip(List<RandomPotionEffect> effects, List<String> list) {
        list.add(new TextComponentTranslation("gregtechfoodoption.tooltip.potion.header", new Object[0]).func_150254_d());
        effects.forEach(effect -> list.add(new TextComponentTranslation("gregtechfoodoption.tooltip.potion.each", new Object[]{new TextComponentTranslation(effect.effect.func_76453_d(), new Object[0]).func_150254_d(), new TextComponentTranslation("enchantment.level." + (effect.effect.func_76458_c() + 1), new Object[0]), effect.effect.func_76459_b(), 100 - effect.chance}).func_150254_d()));
    }

    public static int getFirstUnemptyItemSlot(IItemHandler handler, int startSlot) {
        int i;
        for (i = startSlot; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            return i;
        }
        for (i = 0; i < startSlot; ++i) {
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    public static Vec3d getScaledFacingVec(EnumFacing facing, double scale) {
        Vec3i facingOrdinaryVec = facing.func_176730_m();
        return new Vec3d((double)facingOrdinaryVec.func_177958_n(), (double)facingOrdinaryVec.func_177956_o(), (double)facingOrdinaryVec.func_177952_p()).func_186678_a(scale);
    }

    public static BlockPos.MutableBlockPos copy(BlockPos pos) {
        return new BlockPos.MutableBlockPos(pos.func_185334_h());
    }

    public static boolean isFull(IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).func_190916_E() == handler.getStackInSlot(i).func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public static GTFOFoodStats getGTFOFoodStats(ItemStack stack) {
        if (stack.func_77973_b() instanceof MetaItem && GTFOMetaItems.META_ITEM.getItem(stack) != null) {
            for (IItemComponent stats : ((GTFOMetaItem.GTFOMetaValueItem)GTFOMetaItems.META_ITEM.getItem(stack)).getAllStats()) {
                if (!(stats instanceof GTFOFoodStats)) continue;
                return (GTFOFoodStats)stats;
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawRect(int left, int top, int right, int bottom, int color) {
        if (left < right) {
            int i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            int j = top;
            top = bottom;
            bottom = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)left, (double)bottom, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)bottom, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)top, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }
}

