/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.recipe;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.items.toolitem.IGTTool;
import gregtech.api.recipes.ModHandler;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.material.properties.ToolProperty;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.common.items.MetaItems;
import gregtech.loaders.recipe.handlers.ToolRecipeHandler;
import gregtechfoodoption.item.GTFOMetaItem;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;

public class GTFORecipeHandler {
    public static void register() {
        OrePrefix.ingot.addProcessingHandler(PropertyKey.TOOL, GTFORecipeHandler::processIngot);
        OrePrefix.plate.addProcessingHandler(PropertyKey.TOOL, GTFORecipeHandler::processPlate);
    }

    private static void processIngot(OrePrefix ingotPrefix, Material material, ToolProperty property) {
        if (property.getToolDurability() > 0) {
            ToolRecipeHandler.addToolRecipe((Material)material, (IGTTool)GTFOMetaItem.ROLLING_PIN, (boolean)true, (Object[])new Object[]{"  R", " I ", "R f", Character.valueOf('I'), new UnificationEntry(ingotPrefix, material), Character.valueOf('R'), new UnificationEntry(OrePrefix.stick, material)});
        }
    }

    private static void processPlate(OrePrefix prefix, Material material, ToolProperty property) {
        if (property.getToolDurability() > 0) {
            ItemStack[] powerUnits = new ItemStack[]{MetaItems.POWER_UNIT_HV.getMaxChargeOverrideStack(1800000L), MetaItems.POWER_UNIT_HV.getMaxChargeOverrideStack(1600000L), MetaItems.POWER_UNIT_HV.getMaxChargeOverrideStack(1200000L), MetaItems.POWER_UNIT_HV.getMaxChargeOverrideStack(6400000L)};
            for (int i = 0; i < powerUnits.length; ++i) {
                IElectricItem powerUnit = (IElectricItem)powerUnits[i].getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
                ItemStack toolItem = GTFOMetaItem.BUTCHERY_KNIFE_HV.get(material, 0L, powerUnit.getMaxCharge());
                ModHandler.addShapedEnergyTransferRecipe((String)String.format("%s_%s_%s", "butchery_knife", material, i), (ItemStack)toolItem, (Predicate)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{powerUnits[i]}), (boolean)true, (boolean)true, (Object[])new Object[]{"WUd", "wMf", "H H", Character.valueOf('H'), new UnificationEntry(prefix, material), Character.valueOf('U'), powerUnits[i], Character.valueOf('M'), MetaItems.ELECTRIC_MOTOR_HV, Character.valueOf('W'), new UnificationEntry(OrePrefix.cableGtDouble, Materials.Gold)});
            }
        }
    }
}

