/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.mixins.late;

import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.ingredients.GTRecipeItemInput;
import gregtech.api.recipes.machines.RecipeMapFluidCanner;
import gregtechfoodoption.item.GTFOFoodStats;
import gregtechfoodoption.potion.LacingEntry;
import gregtechfoodoption.utils.GTFOUtils;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RecipeMapFluidCanner.class}, priority=500, remap=false)
public class RecipeMapFluidCannerMixin {
    @Inject(method={"findRecipe"}, at={@At(value="RETURN", ordinal=1)}, cancellable=true)
    private void checkLacingRecipes(long voltage, List<ItemStack> inputs, List<FluidStack> fluidInputs, boolean exactVoltage, CallbackInfoReturnable<Recipe> cir) {
        this.findLacingRecipe(inputs, fluidInputs, cir);
    }

    @Inject(method={"findRecipe"}, at={@At(value="RETURN", ordinal=4)}, cancellable=true)
    private void checkLacingRecipes2(long voltage, List<ItemStack> inputs, List<FluidStack> fluidInputs, boolean exactVoltage, CallbackInfoReturnable<Recipe> cir) {
        this.findLacingRecipe(inputs, fluidInputs, cir);
    }

    @Unique
    public void findLacingRecipe(List<ItemStack> inputs, List<FluidStack> fluidInputs, CallbackInfoReturnable<Recipe> cir) {
        NBTTagCompound gtfoStatsTag;
        NBTTagCompound overallTag;
        ItemStack inputStack = ItemStack.field_190927_a;
        ItemStack lacingWith = ItemStack.field_190927_a;
        for (ItemStack input : inputs) {
            GTFOFoodStats stats = GTFOUtils.getGTFOFoodStats(input);
            if (stats != null) {
                inputStack = input.func_77946_l();
                inputStack.func_190920_e(1);
                continue;
            }
            if (!(input.func_77973_b() instanceof MetaItem)) continue;
            lacingWith = input.func_77946_l();
        }
        if (inputStack.func_190926_b()) {
            return;
        }
        FluidStack potentialFluid = null;
        if (!fluidInputs.isEmpty()) {
            potentialFluid = fluidInputs.get(0);
        }
        if (potentialFluid != null && potentialFluid.amount != 0) {
            FluidStack inputFluid = potentialFluid.copy();
            if (inputFluid.amount < 100) {
                return;
            }
            inputFluid.amount = 100;
            ItemStack outputStack = inputStack.func_77946_l();
            outputStack.func_190920_e(1);
            overallTag = outputStack.func_77978_p();
            if (outputStack.func_77978_p() == null) {
                overallTag = new NBTTagCompound();
            }
            gtfoStatsTag = overallTag.func_74775_l("gtfoStats");
            switch (inputFluid.getUnlocalizedName()) {
                default: 
            }
            return;
        }
        if (!lacingWith.func_190926_b()) {
            ItemStack outputStack = inputStack.func_77946_l();
            outputStack.func_190920_e(1);
            overallTag = outputStack.func_77978_p();
            if (outputStack.func_77978_p() == null) {
                overallTag = new NBTTagCompound();
            }
            gtfoStatsTag = overallTag.func_74775_l("gtfoStats");
            boolean lacingSuccessful = false;
            for (LacingEntry entry : LacingEntry.LACING_REGISTRY) {
                if (!entry.getLacingItem().func_77969_a(lacingWith)) continue;
                gtfoStatsTag.func_74757_a(entry.getNbtKey(), true);
                lacingSuccessful = true;
            }
            if (!lacingSuccessful) {
                return;
            }
            overallTag.func_74782_a("gtfoStats", (NBTBase)gtfoStatsTag);
            outputStack.func_77982_d(overallTag);
            cir.setReturnValue((Object)((Recipe)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CANNER_RECIPES.recipeBuilder()).inputs(new GTRecipeInput[]{GTRecipeItemInput.getOrCreate((ItemStack)inputStack, (int)1), GTRecipeItemInput.getOrCreate((ItemStack)lacingWith, (int)1)})).outputs(new ItemStack[]{outputStack})).duration(16)).EUt(4)).build().getResult()));
        }
    }
}

