/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.machines.multiblock.kitchen;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.google.common.collect.Lists;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.ClickButtonWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.SimpleGeneratorMetaTileEntity;
import gregtech.api.metatileentity.WorkableTieredMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockDisplayText;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.ingredients.IntCircuitIngredient;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.blocks.BlockBoilerCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtechfoodoption.GTFOValues;
import gregtechfoodoption.block.GTFOBlockCasing;
import gregtechfoodoption.block.GTFOMetaBlocks;
import gregtechfoodoption.client.GTFOGuiTextures;
import gregtechfoodoption.machines.multiblock.kitchen.KitchenLogic;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class MetaTileEntityKitchen
extends MultiblockWithDisplayBase {
    public static final int MIN_RADIUS = 2;
    private final KitchenLogic kitchenLogic;
    protected IItemHandlerModifiable inputInventory;
    protected IItemHandlerModifiable outputInventory;
    protected IMultipleTankHandler inputFluidInventory;
    protected IMultipleTankHandler outputFluidInventory;
    protected IEnergyContainer energyContainer;
    protected IItemHandlerModifiable recipeHolder = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            MetaTileEntityKitchen.this.kitchenLogic.reset();
        }
    };
    protected IItemHandlerModifiable allCircuits = new ItemStackHandler(32){

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return IntCircuitIngredient.getIntegratedCircuit((int)slot);
        }
    };
    protected int orderSize = 64;
    private int sDist = 0;
    private int bDist = 0;

    public MetaTileEntityKitchen(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
        this.kitchenLogic = new KitchenLogic(this);
        this.resetTileAbilities();
    }

    protected void initializeAbilities() {
        ArrayList<IItemHandlerModifiable> inputs = new ArrayList<IItemHandlerModifiable>(this.getAbilities(MultiblockAbility.IMPORT_ITEMS));
        inputs.add(this.allCircuits);
        this.inputInventory = new ItemHandlerList(inputs);
        this.inputFluidInventory = new FluidTankList(true, this.getAbilities(MultiblockAbility.IMPORT_FLUIDS));
        this.outputInventory = new ItemHandlerList(this.getAbilities(MultiblockAbility.EXPORT_ITEMS));
        this.outputFluidInventory = new FluidTankList(true, this.getAbilities(MultiblockAbility.EXPORT_FLUIDS));
        this.energyContainer = new EnergyContainerList(this.getAbilities(MultiblockAbility.INPUT_ENERGY));
    }

    private void resetTileAbilities() {
        this.inputInventory = new ItemStackHandler(0);
        this.inputFluidInventory = new FluidTankList(true, new IFluidTank[0]);
        this.outputInventory = new ItemStackHandler(0);
        this.outputFluidInventory = new FluidTankList(true, new IFluidTank[0]);
        this.energyContainer = new EnergyContainerList((List)Lists.newArrayList());
    }

    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        this.initializeAbilities();
    }

    protected void updateFormedValid() {
    }

    public void clearMachineInventory(NonNullList<ItemStack> itemBuffer) {
        super.clearMachineInventory(itemBuffer);
        itemBuffer.add((Object)this.recipeHolder.getStackInSlot(0));
    }

    public boolean drainEnergy(boolean simulate) {
        long energyToDrain = GTValues.VA[this.getEnergyTier()] / 2;
        long resultEnergy = this.energyContainer.getEnergyStored() - energyToDrain;
        if (resultEnergy >= 0L && resultEnergy <= this.energyContainer.getEnergyCapacity()) {
            if (!simulate) {
                this.energyContainer.changeEnergy(-energyToDrain);
            }
            return true;
        }
        return false;
    }

    public int getEnergyTier() {
        if (this.energyContainer == null) {
            return 1;
        }
        return Math.max(1, GTUtility.getFloorTierByVoltage((long)this.energyContainer.getInputVoltage()));
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        if (this.getWorld() != null) {
            this.updateStructureDimensions();
        }
        if (this.sDist < 2) {
            this.sDist = 2;
        }
        if (this.bDist < 4) {
            this.bDist = 4;
        }
        StringBuilder borderBuilder = new StringBuilder();
        StringBuilder centerBuilder = new StringBuilder();
        StringBuilder frontBuilder = new StringBuilder();
        StringBuilder topBuilder = new StringBuilder();
        StringBuilder emptyBuilder = new StringBuilder();
        for (int i = 0; i < this.sDist; ++i) {
            if (i == 0) {
                centerBuilder.append("B");
                topBuilder.append(" ");
            } else {
                centerBuilder.append("F");
                topBuilder.append("I");
            }
            emptyBuilder.append("  ");
            frontBuilder.append("B");
            borderBuilder.append("B");
        }
        emptyBuilder.append(" ");
        borderBuilder.append((CharSequence)borderBuilder);
        borderBuilder.append("B");
        frontBuilder.append((CharSequence)frontBuilder);
        frontBuilder.insert(this.sDist, "S");
        centerBuilder.append((CharSequence)new StringBuilder(centerBuilder).reverse());
        centerBuilder.insert(this.sDist, "F");
        topBuilder.append((CharSequence)new StringBuilder(topBuilder).reverse());
        topBuilder.insert(this.sDist, "I");
        TraceabilityPredicate basePredicate = this.autoAbilities().or(MetaTileEntityKitchen.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.INPUT_ENERGY}).setMinGlobalLimited(1).setMaxGlobalLimited(3));
        return FactoryBlockPattern.start().aisle(new String[]{borderBuilder.toString(), emptyBuilder.toString()}).aisle(new String[]{centerBuilder.toString(), topBuilder.toString()}).setRepeatable(4, this.bDist).aisle(new String[]{frontBuilder.toString(), emptyBuilder.toString()}).where('S', this.selfPredicate()).where('B', basePredicate.or(MetaTileEntityKitchen.states((IBlockState[])new IBlockState[]{this.getCasingState()}))).where('F', MetaTileEntityKitchen.states((IBlockState[])new IBlockState[]{this.getFloorState(), this.getFloorState2()})).where('I', this.innerPredicate()).where(' ', MetaTileEntityKitchen.any()).build();
    }

    public TraceabilityPredicate autoAbilities() {
        TraceabilityPredicate predicate = super.autoAbilities(true, false);
        predicate = predicate.or(MetaTileEntityKitchen.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.INPUT_ENERGY}).setMinGlobalLimited(1).setMaxGlobalLimited(2).setPreviewCount(1));
        predicate = predicate.or(MetaTileEntityKitchen.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.IMPORT_ITEMS}).setPreviewCount(1));
        predicate = predicate.or(MetaTileEntityKitchen.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.EXPORT_ITEMS}).setPreviewCount(1));
        predicate = predicate.or(MetaTileEntityKitchen.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.IMPORT_FLUIDS}).setPreviewCount(1));
        predicate = predicate.or(MetaTileEntityKitchen.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.EXPORT_FLUIDS}).setPreviewCount(1));
        return predicate;
    }

    @Nonnull
    protected TraceabilityPredicate innerPredicate() {
        return new TraceabilityPredicate(blockWorldState -> {
            TileEntity tileEntity = blockWorldState.getTileEntity();
            if (!(tileEntity instanceof IGregTechTileEntity)) {
                return true;
            }
            MetaTileEntity metaTileEntity = ((IGregTechTileEntity)tileEntity).getMetaTileEntity();
            if (!(metaTileEntity instanceof WorkableTieredMetaTileEntity) || metaTileEntity instanceof SimpleGeneratorMetaTileEntity) {
                return true;
            }
            this.kitchenLogic.giveMetaTileEntity((WorkableTieredMetaTileEntity)metaTileEntity);
            this.kitchenLogic.wasNotified = true;
            return true;
        });
    }

    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        for (int i = 1; i < 6; ++i) {
            tooltip.add(I18n.func_135052_a((String)("gregtechfoodoption.machine.kitchen.tooltip." + i), (Object[])new Object[0]));
        }
    }

    public boolean allowsExtendedFacing() {
        return false;
    }

    public boolean allowsFlip() {
        return false;
    }

    protected boolean updateStructureDimensions() {
        int i;
        World world = this.getWorld();
        EnumFacing front = this.getFrontFacing();
        EnumFacing back = front.func_176734_d();
        EnumFacing left = front.func_176735_f();
        EnumFacing right = left.func_176734_d();
        BlockPos.MutableBlockPos lPos = new BlockPos.MutableBlockPos(this.getPos().func_177972_a(back));
        BlockPos.MutableBlockPos rPos = new BlockPos.MutableBlockPos(this.getPos().func_177972_a(back));
        BlockPos.MutableBlockPos bPos = new BlockPos.MutableBlockPos(this.getPos());
        int sDist = 0;
        int bDist = 0;
        for (i = 0; i < 15; ++i) {
            if (!this.isBlockEdge(world, bPos, back)) continue;
            bDist = i;
            break;
        }
        for (i = 1; i < 9; ++i) {
            if (!(this.isBlockEdge(world, lPos, left) & this.isBlockEdge(world, rPos, right))) continue;
            sDist = i;
            break;
        }
        if (sDist < 2 || bDist < 4) {
            this.invalidateStructure();
            return false;
        }
        this.sDist = sDist;
        this.bDist = bDist;
        if (!this.getWorld().field_72995_K) {
            this.writeCustomData(GregtechDataCodes.UPDATE_STRUCTURE_SIZE, buf -> {
                buf.writeInt(this.sDist);
                buf.writeInt(this.bDist);
            });
        }
        return true;
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.resetTileAbilities();
    }

    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        data.func_74768_a("sDist", this.sDist);
        data.func_74768_a("bDist", this.bDist);
        data.func_74768_a("orderSize", this.orderSize);
        this.writeRecipeItemToNBT(data);
        return super.writeToNBT(data);
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.sDist = data.func_74762_e("sDist");
        this.bDist = data.func_74762_e("bDist");
        this.orderSize = data.func_74762_e("orderSize");
        if (data.func_74764_b("recipe")) {
            this.recipeHolder.setStackInSlot(0, new ItemStack(data.func_74775_l("recipe")));
        }
        this.reinitializeStructurePattern();
    }

    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeInt(this.sDist);
        buf.writeInt(this.bDist);
        buf.writeInt(this.orderSize);
        buf.func_150788_a(this.recipeHolder.getStackInSlot(0));
    }

    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.sDist = buf.readInt();
        this.bDist = buf.readInt();
        this.orderSize = buf.readInt();
        try {
            this.recipeHolder.setStackInSlot(0, buf.func_150791_c());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.reinitializeStructurePattern();
    }

    public ICubeRenderer getBaseTexture(IMultiblockPart iMultiblockPart) {
        return Textures.SOLID_STEEL_CASING;
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MetaTileEntityKitchen(this.metaTileEntityId);
    }

    protected ModularUI.Builder createUITemplate(EntityPlayer entityPlayer) {
        ModularUI.Builder builder = super.createUITemplate(entityPlayer);
        builder.slot(this.recipeHolder, 0, 150, 100, new IGuiTexture[]{GuiTextures.SLOT});
        return builder;
    }

    public boolean isBlockEdge(@Nonnull World world, @Nonnull BlockPos.MutableBlockPos pos, @Nonnull EnumFacing direction) {
        return world.func_180495_p((BlockPos)pos.func_189536_c(direction)) == this.getCasingState() || world.func_175625_s((BlockPos)pos) instanceof MetaTileEntityHolder;
    }

    @Nonnull
    protected IBlockState getCasingState() {
        return MetaBlocks.BOILER_CASING.getState((Enum)BlockBoilerCasing.BoilerCasingType.STEEL_PIPE);
    }

    @Nonnull
    protected IBlockState getFloorState() {
        return GTFOMetaBlocks.GTFO_CASING.getState(GTFOBlockCasing.CasingType.PORCELAIN_TILE);
    }

    @Nonnull
    protected IBlockState getFloorState2() {
        return GTFOMetaBlocks.GTFO_CASING.getState(GTFOBlockCasing.CasingType.DARK_PORCELAIN_TILE);
    }

    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.UPDATE_STRUCTURE_SIZE) {
            this.sDist = buf.readInt();
            this.bDist = buf.readInt();
        } else if (dataId == GregtechDataCodes.WORKABLE_ACTIVE) {
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.WORKING_ENABLED) {
            this.scheduleRenderUpdate();
        } else if (dataId == GTFOValues.UPDATE_KITCHEN_ORDER) {
            this.orderSize = buf.readInt();
            this.kitchenLogic.recheckOutputs = true;
        }
    }

    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.BLAST_FURNACE_OVERLAY;
    }

    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.isActive(), this.kitchenLogic.isWorkingEnabled());
    }

    public boolean isActive() {
        return this.isStructureFormed() && this.kitchenLogic.state == KitchenLogic.KitchenLogicState.PROBABLY_FINE && this.kitchenLogic.isWorkingEnabled();
    }

    protected void addDisplayText(List<ITextComponent> textList) {
        MultiblockDisplayText.builder(textList, (boolean)this.isStructureFormed()).setWorkingStatus(this.kitchenLogic.isWorkingEnabled(), this.isActive()).addWorkingStatusLine().addEnergyUsageLine(this.energyContainer).addEnergyTierLine(this.getEnergyTier()).addCustom(list -> {
            if (!this.isActive()) {
                return;
            }
            TextComponentTranslation comp = null;
            switch (this.kitchenLogic.state) {
                case PROBABLY_FINE: {
                    comp = new TextComponentTranslation("gregtechfoodoption.multiblock.kitchen.probably_fine", new Object[0]);
                    break;
                }
                case ORDER_COMPLETE: {
                    comp = new TextComponentTranslation("gregtechfoodoption.multiblock.kitchen.order_complete", new Object[0]);
                }
            }
            if (comp != null) {
                list.add(comp.func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)));
            }
        }).addCustom(list -> {
            if (!this.isActive()) {
                return;
            }
            list.add(new TextComponentTranslation("gregtechfoodoption.multiblock.kitchen.order_size", new Object[]{this.orderSize}).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)));
        }).addCustom(list -> {
            TextFormatting color = TextFormatting.GRAY;
            if (this.kitchenLogic.dirtiness > 100) {
                color = TextFormatting.RED;
            } else if (this.kitchenLogic.dirtiness > 50) {
                color = TextFormatting.YELLOW;
            } else if (this.kitchenLogic.dirtiness > 10) {
                color = TextFormatting.WHITE;
            }
            list.add(new TextComponentTranslation("gregtechfoodoption.multiblock.kitchen.dirtiness", new Object[]{this.kitchenLogic.dirtiness}).func_150255_a(new Style().func_150238_a(color)));
        });
    }

    protected void addErrorText(List<ITextComponent> textList) {
        MultiblockDisplayText.builder(textList, (boolean)this.isStructureFormed(), (boolean)true).addCustom(list -> {
            if (!this.isStructureFormed() || !this.kitchenLogic.isWorkingEnabled()) {
                return;
            }
            TextComponentTranslation comp = null;
            switch (this.kitchenLogic.state) {
                case NO_RECIPE: {
                    comp = new TextComponentTranslation("gregtechfoodoption.multiblock.kitchen.no_recipe", new Object[0]);
                    break;
                }
                case BAD_MACHINES: {
                    comp = new TextComponentTranslation("gregtechfoodoption.multiblock.kitchen.bad_machines", new Object[0]);
                    break;
                }
                case MACHINES_NOT_WORKING: {
                    comp = new TextComponentTranslation("gregtechfoodoption.multiblock.kitchen.machines_not_working", new Object[0]);
                    break;
                }
                case NO_INGREDIENTS: {
                    comp = new TextComponentTranslation("gregtechfoodoption.multiblock.kitchen.no_ingredients", new Object[0]);
                }
            }
            if (comp != null) {
                list.add(comp.func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)));
            }
        });
    }

    protected void addWarningText(List<ITextComponent> textList) {
        MultiblockDisplayText.builder(textList, (boolean)this.isStructureFormed(), (boolean)false).addMaintenanceProblemLines(this.getMaintenanceProblems()).addLowPowerLine(!this.drainEnergy(true)).addCustom(list -> {
            if (!this.isStructureFormed() || !this.kitchenLogic.isWorkingEnabled()) {
                return;
            }
            TextComponentTranslation comp = null;
            switch (this.kitchenLogic.state) {
                case BUSES_FULL: {
                    comp = new TextComponentTranslation("gregtechfoodoption.multiblock.kitchen.buses_full", new Object[0]);
                    break;
                }
                case HATCHES_FULL: {
                    comp = new TextComponentTranslation("gregtechfoodoption.multiblock.kitchen.hatches_full", new Object[0]);
                }
            }
            if (comp != null) {
                list.add(comp.func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)));
            }
            if (this.kitchenLogic.dirtiness > 100) {
                list.add(new TextComponentTranslation("gregtechfoodoption.multiblock.kitchen.very_dirty", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
        });
    }

    @NotNull
    protected Widget getFlexButton(int x, int y, int width, int height) {
        WidgetGroup group = new WidgetGroup(x, y, width, height);
        group.addWidget((Widget)new ClickButtonWidget(0, 0, 9, 18, "", this::decrementOrderSize).setTooltipText("gregtechfoodoption.multiblock.kitchen.decrement_order", new Object[0]).setButtonTexture(GuiTextures.BUTTON_THROTTLE_MINUS));
        group.addWidget((Widget)new ClickButtonWidget(9, 0, 9, 18, "", this::incrementOrderSize).setTooltipText("gregtechfoodoption.multiblock.kitchen.increment_order", new Object[0]).setButtonTexture(GuiTextures.BUTTON_THROTTLE_PLUS));
        return group;
    }

    private void incrementOrderSize(Widget.ClickData clickData) {
        ++this.orderSize;
        this.orderSize = Math.min(this.orderSize, 64);
        this.writeCustomData(GTFOValues.UPDATE_KITCHEN_ORDER, buf -> buf.writeInt(this.orderSize));
        this.markDirty();
    }

    private void decrementOrderSize(Widget.ClickData clickData) {
        --this.orderSize;
        this.orderSize = Math.max(this.orderSize, 1);
        this.writeCustomData(GTFOValues.UPDATE_KITCHEN_ORDER, buf -> buf.writeInt(this.orderSize));
        this.markDirty();
    }

    public IItemHandlerModifiable getInputInventory() {
        return this.inputInventory;
    }

    public IItemHandlerModifiable getOutputInventory() {
        return this.outputInventory;
    }

    public IMultipleTankHandler getInputFluidInventory() {
        return this.inputFluidInventory;
    }

    public IMultipleTankHandler getOutputFluidInventory() {
        return this.outputFluidInventory;
    }

    @NotNull
    protected TextureArea getLogo() {
        return GTFOGuiTextures.GTFO_LOGO_WORKING;
    }

    @NotNull
    protected TextureArea getWarningLogo() {
        return GTFOGuiTextures.GTFO_LOGO_WARNING;
    }

    @NotNull
    protected TextureArea getErrorLogo() {
        return GTFOGuiTextures.GTFO_LOGO_ERROR;
    }

    public NBTTagCompound getRecipeNBT() {
        if (!this.recipeHolder.getStackInSlot(0).func_190926_b()) {
            return this.recipeHolder.getStackInSlot(0).func_77978_p();
        }
        return null;
    }

    public void writeRecipeItemToNBT(NBTTagCompound tag) {
        if (!this.recipeHolder.getStackInSlot(0).func_190926_b()) {
            NBTTagCompound item = new NBTTagCompound();
            this.recipeHolder.getStackInSlot(0).func_77955_b(item);
            tag.func_74782_a("recipe", (NBTBase)item);
        }
    }

    public int getOrderSize() {
        return this.orderSize;
    }
}

