/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.machines.multiblock;

import gregtech.api.GTValues;
import gregtech.api.capability.impl.SteamMultiWorkable;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.RecipeMapSteamMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.unification.material.Materials;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockFrame;
import gregtech.common.blocks.BlockGlassCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtechfoodoption.block.GTFOBlockCasing;
import gregtechfoodoption.block.GTFOMetaBlocks;
import gregtechfoodoption.client.GTFOClientHandler;
import gregtechfoodoption.client.GTFOGuiTextures;
import gregtechfoodoption.recipe.builder.ElectricBakingOvenRecipeBuilder;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class MetaTileEntitySteamBakingOven
extends RecipeMapSteamMultiblockController {
    public MetaTileEntitySteamBakingOven(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, double conversionRate) {
        super(metaTileEntityId, recipeMap, conversionRate);
        this.recipeMapWorkable = new SteamBakingOvenWorkable(this, CONVERSION_RATE);
        this.recipeMapWorkable.setParallelLimit(1);
    }

    protected IBlockState getCasingState() {
        return GTFOMetaBlocks.GTFO_CASING.getState(GTFOBlockCasing.CasingType.REINFORCED_ADOBE_BRICKS);
    }

    protected IBlockState getFrameState() {
        return ((BlockFrame)MetaBlocks.FRAMES.get(Materials.Steel)).getBlock(Materials.Steel);
    }

    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle(new String[]{"XXXX", "XGGX", "XXXX"}).aisle(new String[]{"XXXX", "GFFG", "XFFX"}).aisle(new String[]{"XXXX", "GFFG", "XFFX"}).aisle(new String[]{"XXXX", "YGGX", "XXXX"}).where('X', MetaTileEntitySteamBakingOven.states((IBlockState[])new IBlockState[]{this.getCasingState()}).or(this.autoAbilities(true, false, true, true, false))).where('F', MetaTileEntitySteamBakingOven.states((IBlockState[])new IBlockState[]{this.getFrameState()})).where('#', MetaTileEntitySteamBakingOven.air()).where(' ', MetaTileEntitySteamBakingOven.any()).where('Y', this.selfPredicate()).where('G', MetaTileEntitySteamBakingOven.states((IBlockState[])new IBlockState[]{this.getCasingState()}).or(MetaTileEntitySteamBakingOven.states((IBlockState[])new IBlockState[]{MetaBlocks.TRANSPARENT_CASING.getState((Enum)BlockGlassCasing.CasingType.TEMPERED_GLASS)}))).build();
    }

    public ICubeRenderer getBaseTexture(IMultiblockPart iMultiblockPart) {
        return GTFOClientHandler.REINFORCED_ADOBE_BRICKS;
    }

    @Nonnull
    protected ICubeRenderer getFrontOverlay() {
        return GTFOClientHandler.MICROWAVE_OVERLAY;
    }

    public boolean hasMaintenanceMechanics() {
        return false;
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntitySteamBakingOven(this.metaTileEntityId, this.getRecipeMap(), CONVERSION_RATE);
    }

    @NotNull
    protected TextureArea getLogo() {
        return GTFOGuiTextures.GTFO_LOGO_WORKING;
    }

    @NotNull
    protected TextureArea getWarningLogo() {
        return GTFOGuiTextures.GTFO_LOGO_WARNING;
    }

    @NotNull
    protected TextureArea getErrorLogo() {
        return GTFOGuiTextures.GTFO_LOGO_ERROR;
    }

    public static class SteamBakingOvenWorkable
    extends SteamMultiWorkable {
        protected int recipeSteamT;

        public SteamBakingOvenWorkable(RecipeMapSteamMultiblockController tileEntity, double conversionRate) {
            super(tileEntity, conversionRate);
        }

        protected void updateRecipeProgress() {
            if (this.canRecipeProgress && this.drawEnergy(this.recipeSteamT, true)) {
                this.drawEnergy(this.recipeSteamT, false);
                if (++this.progressTime > this.maxProgressTime) {
                    this.completeRecipe();
                }
                if (this.hasNotEnoughEnergy && this.getEnergyInputPerSecond() > 19L * (long)this.recipeSteamT) {
                    this.hasNotEnoughEnergy = false;
                }
            } else if (this.recipeSteamT > 0) {
                this.hasNotEnoughEnergy = true;
                if (this.progressTime >= 2) {
                    this.progressTime = ConfigHolder.machines.recipeProgressLowEnergy ? 1 : Math.max(1, this.progressTime - 2);
                }
            }
        }

        protected void setupRecipe(Recipe recipe) {
            super.setupRecipe(recipe);
            this.recipeSteamT = this.previousRecipe == null ? 0 : (Integer)this.previousRecipe.getProperty((RecipeProperty)ElectricBakingOvenRecipeBuilder.TemperatureProperty.getInstance(), (Object)0) / 100;
        }

        protected int[] calculateOverclock(Recipe recipe) {
            return new int[]{0, recipe.getDuration() * 4};
        }

        protected boolean drawEnergy(int recipeEUt, boolean simulate) {
            return recipeEUt == 0 || super.drawEnergy(recipeEUt, simulate);
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound compound = super.serializeNBT();
            compound.func_74768_a("RecipeSteamT", this.recipeSteamT);
            return compound;
        }

        public void deserializeNBT(@Nonnull NBTTagCompound compound) {
            super.deserializeNBT(compound);
            this.recipeSteamT = compound.func_74762_e("RecipeSteamT");
        }

        public void writeInitialSyncData(@Nonnull PacketBuffer buf) {
            super.writeInitialSyncData(buf);
            buf.writeInt(this.recipeSteamT);
        }

        public void receiveInitialSyncData(@Nonnull PacketBuffer buf) {
            super.receiveInitialSyncData(buf);
            this.recipeSteamT = buf.readInt();
        }

        public long getMaxVoltage() {
            return GTValues.V[4];
        }
    }
}

