/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.machines.multiblock;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.impl.ItemHandlerProxy;
import gregtech.api.capability.impl.PrimitiveRecipeLogic;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IUIHolder;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.RecipeMapPrimitiveMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.unification.material.Materials;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.common.blocks.BlockFrame;
import gregtech.common.blocks.MetaBlocks;
import gregtechfoodoption.block.GTFOBlockCasing;
import gregtechfoodoption.block.GTFOMetaBlocks;
import gregtechfoodoption.client.GTFOClientHandler;
import gregtechfoodoption.client.GTFOGuiTextures;
import gregtechfoodoption.recipe.GTFORecipeMaps;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class MetaTileEntityBakingOven
extends RecipeMapPrimitiveMultiblockController {
    public MetaTileEntityBakingOven(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, GTFORecipeMaps.BAKING_OVEN_RECIPES);
    }

    public int getActualLightValue() {
        return this.recipeMapWorkable.isActive() ? 15 : 0;
    }

    protected IBlockState getCasingState() {
        return GTFOMetaBlocks.GTFO_CASING.getState(GTFOBlockCasing.CasingType.ADOBE_BRICKS);
    }

    protected TraceabilityPredicate getFrameState() {
        return MetaTileEntityBakingOven.states((IBlockState[])new IBlockState[]{((BlockFrame)MetaBlocks.FRAMES.get(Materials.Iron)).getBlock(Materials.Iron), ((BlockFrame)MetaBlocks.FRAMES.get(Materials.Bronze)).getBlock(Materials.Bronze)});
    }

    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return GTFOClientHandler.ADOBE_BRICKS;
    }

    protected ICubeRenderer getFrontOverlay() {
        return GTFOClientHandler.BAKING_OVEN_OVERLAY;
    }

    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.recipeMapWorkable.isActive(), this.recipeMapWorkable.isWorkingEnabled());
    }

    protected void initializeInventory() {
        super.initializeInventory();
        ItemStackHandler emptyHandler = new ItemStackHandler(0);
        this.itemInventory = new ItemHandlerProxy((IItemHandler)emptyHandler, (IItemHandler)emptyHandler);
    }

    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle(new String[]{"XXX", "XXX"}).aisle(new String[]{"XFX", "X#X"}).aisle(new String[]{"XYX", "XXX"}).where('X', MetaTileEntityBakingOven.states((IBlockState[])new IBlockState[]{this.getCasingState()})).where('F', this.getFrameState()).where('#', MetaTileEntityBakingOven.air()).where(' ', MetaTileEntityBakingOven.any()).where('Y', this.selfPredicate()).build();
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityBakingOven(this.metaTileEntityId);
    }

    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return ModularUI.builder((IGuiTexture)GuiTextures.PRIMITIVE_BACKGROUND, (int)176, (int)166).widget((Widget)new LabelWidget(5, 5, this.getMetaFullName(), new Object[0])).widget((Widget)new SlotWidget((IItemHandler)this.importItems, 0, 53, 20, true, true).setBackgroundTexture(new IGuiTexture[]{GuiTextures.PRIMITIVE_SLOT, GTFOGuiTextures.PRIMITIVE_FOOD_OVERLAY})).widget((Widget)new SlotWidget((IItemHandler)this.importItems, 1, 53, 38, true, true).setBackgroundTexture(new IGuiTexture[]{GuiTextures.PRIMITIVE_SLOT, GuiTextures.PRIMITIVE_FURNACE_OVERLAY})).progressBar(() -> ((PrimitiveRecipeLogic)this.recipeMapWorkable).getProgressPercent(), 78, 31, 20, 15, GuiTextures.PRIMITIVE_BLAST_FURNACE_PROGRESS_BAR, ProgressWidget.MoveType.HORIZONTAL, this.getRecipeMap()).widget((Widget)new SlotWidget((IItemHandler)this.exportItems, 0, 105, 29, true, false).setBackgroundTexture(new IGuiTexture[]{GuiTextures.PRIMITIVE_SLOT, GTFOGuiTextures.PRIMITIVE_FOOD_OVERLAY})).bindPlayerInventory(entityPlayer.field_71071_by, (IGuiTexture)GuiTextures.PRIMITIVE_SLOT, 0).build((IUIHolder)this.getHolder(), entityPlayer);
    }

    public boolean hasMaintenanceMechanics() {
        return false;
    }
}

