/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.machines.farmer;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Vector3;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IActiveOutputSide;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.impl.EnergyContainerHandler;
import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.cover.CoverRayTracer;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IUIHolder;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.ToggleButtonWidget;
import gregtech.api.items.itemhandlers.GTItemStackHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.TieredMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.GregFakePlayer;
import gregtech.client.particle.GTParticle;
import gregtech.client.particle.GTParticleManager;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.OrientedOverlayRenderer;
import gregtechfoodoption.GTFOValues;
import gregtechfoodoption.client.GTFOClientHandler;
import gregtechfoodoption.client.GTFOGuiTextures;
import gregtechfoodoption.client.particle.GTFOFarmingLaserBeamParticle;
import gregtechfoodoption.machines.farmer.FarmerMode;
import gregtechfoodoption.machines.farmer.FarmerModeRegistry;
import gregtechfoodoption.utils.GTFOUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class MetaTileEntityFarmer
extends TieredMetaTileEntity
implements IControllable,
IActiveOutputSide {
    private final int ticksPerAction;
    private AxisAlignedBB workingArea;
    private BlockPos.MutableBlockPos operationPosition;
    public static final int LENGTH = 9;
    private boolean isWorking;
    private boolean isWorkingEnabled = true;
    private FarmerMode cachedMode;
    public GregFakePlayer fakePlayer;
    private final List<FarmerMode> unusableHarvestingModes = new ArrayList<FarmerMode>();
    protected int seedSlot;
    protected boolean seedsAreEmpty = false;
    private boolean autoOutputItems;
    private EnumFacing outputFacing;
    private boolean allowInputFromOutputSide = false;
    private static final int BASE_EU_CONSUMPTION = 16;
    protected final GTItemStackHandler chargerInventory;

    public MetaTileEntityFarmer(ResourceLocation metaTileEntityId, int tier, int ticksPerAction) {
        super(metaTileEntityId, tier);
        this.ticksPerAction = ticksPerAction;
        this.initializeInventory();
        this.chargerInventory = new GTItemStackHandler((MetaTileEntity)this, 1);
        this.cachedMode = FarmerModeRegistry.getAnyMode();
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MetaTileEntityFarmer(this.metaTileEntityId, this.getTier(), this.ticksPerAction);
    }

    public void update() {
        boolean isWorkingNow;
        super.update();
        if (!this.getWorld().field_72995_K) {
            ((EnergyContainerHandler)this.energyContainer).dischargeOrRechargeEnergyContainers((IItemHandlerModifiable)this.chargerInventory, 0);
        }
        boolean bl = isWorkingNow = this.energyContainer.getEnergyStored() >= (long)this.getEnergyConsumedPerTick();
        if (!this.getWorld().field_72995_K && isWorkingNow != this.isWorking) {
            this.writeCustomData(GregtechDataCodes.IS_WORKING, buffer -> buffer.writeBoolean(isWorkingNow));
            this.isWorking = isWorkingNow;
        }
        if (this.getOffsetTimer() % (long)this.ticksPerAction != 0L || !this.isWorking || !this.isWorkingEnabled) {
            return;
        }
        if (this.getWorld().field_72995_K) {
            this.operateClient();
            this.updateOperationPosition();
            return;
        }
        if (!isWorkingNow) {
            return;
        }
        this.energyContainer.removeEnergy((long)this.getEnergyConsumedPerTick());
        if (this.operationPosition == null || this.workingArea == null) {
            this.setupWorkingArea();
        }
        this.operateServer();
    }

    @SideOnly(value=Side.CLIENT)
    public void operateClient() {
        GTParticleManager.INSTANCE.addEffect((GTParticle)new GTFOFarmingLaserBeamParticle((MetaTileEntity)this, new Vector3(new Vec3d((Vec3i)this.getPos()).func_178787_e(GTFOUtils.getScaledFacingVec(this.getFrontFacing(), 0.4)).func_72441_c(0.5, 0.7, 0.5)), new Vector3(new Vec3d((Vec3i)this.operationPosition)).add(0.5, 0.0, 0.5), this.ticksPerAction * 3));
    }

    public void operateServer() {
        if (this.isAutoOutputItems()) {
            this.pushItemsIntoNearbyHandlers(new EnumFacing[]{this.getOutputFacing()});
        }
        if (this.fakePlayer == null) {
            this.fakePlayer = new GregFakePlayer(this.getWorld());
        }
        boolean didSomething = this.collectCrops();
        if (!this.unusableHarvestingModes.isEmpty() && this.notifiedItemOutputList.contains(this.getExportItems()) && !GTFOUtils.isFull((IItemHandler)this.getExportItems())) {
            this.unusableHarvestingModes.clear();
        }
        if (didSomething |= this.placeSeed()) {
            this.getWorld().func_184148_a(null, (double)this.getPos().func_177958_n() + 0.5, (double)this.getPos().func_177956_o() + 0.5, (double)this.getPos().func_177952_p() + 0.5, GTFOClientHandler.FARMER_LASER, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        this.updateOperationPosition();
    }

    public boolean collectCrops() {
        IBlockState blockState = this.getWorld().func_180495_p((BlockPos)this.operationPosition);
        if (!this.getWorld().func_175623_d((BlockPos)this.operationPosition)) {
            boolean canHarvestBlock = true;
            if (!this.cachedMode.canOperate(blockState, this, (BlockPos)GTFOUtils.copy((BlockPos)this.operationPosition), this.getWorld())) {
                FarmerMode mode = FarmerModeRegistry.findSuitableFarmerMode(blockState, this, GTFOUtils.copy((BlockPos)this.operationPosition), this.getWorld());
                if (mode != null) {
                    this.cachedMode = mode;
                } else {
                    canHarvestBlock = false;
                }
            }
            if (canHarvestBlock && !this.unusableHarvestingModes.contains(this.cachedMode) && !GTFOUtils.isFull((IItemHandler)this.getExportItems())) {
                List<ItemStack> drops = this.cachedMode.getDrops(blockState, this.getWorld(), GTFOUtils.copy((BlockPos)this.operationPosition), this);
                if (GTTransferUtils.addItemsToItemHandler((IItemHandler)this.getExportItems(), (boolean)true, drops)) {
                    GTTransferUtils.addItemsToItemHandler((IItemHandler)this.getExportItems(), (boolean)false, drops);
                    this.cachedMode.harvest(blockState, this.getWorld(), GTFOUtils.copy((BlockPos)this.operationPosition), this);
                    return true;
                }
                this.unusableHarvestingModes.add(this.cachedMode);
                this.notifiedItemOutputList.clear();
            }
        }
        return false;
    }

    public boolean placeSeed() {
        if (!(!this.isCropSpaceEmpty() || this.seedsAreEmpty && this.getNotifiedItemInputList().isEmpty())) {
            this.seedsAreEmpty = false;
            this.seedSlot = GTFOUtils.getFirstUnemptyItemSlot((IItemHandler)this.getImportItems(), this.seedSlot + 1);
            if (this.seedSlot == -1) {
                this.seedsAreEmpty = true;
            } else {
                EnumActionResult result;
                ItemStack seedItem = this.getImportItems().extractItem(this.seedSlot, 1, true);
                boolean canPlaceSeed = true;
                if (!this.cachedMode.canPlaceItem(seedItem) || !this.cachedMode.canPlaceAt(GTFOUtils.copy((BlockPos)this.operationPosition), new BlockPos.MutableBlockPos(this.getPos()), this.getFrontFacing(), this.getWorld())) {
                    FarmerMode mode = FarmerModeRegistry.findSuitableFarmerMode(seedItem, GTFOUtils.copy((BlockPos)this.operationPosition), new BlockPos.MutableBlockPos(this.getPos()), this.getFrontFacing(), this.getWorld());
                    if (mode != null) {
                        this.cachedMode = mode;
                    } else {
                        canPlaceSeed = false;
                        if (FarmerModeRegistry.findSuitableFarmerMode(seedItem) == null) {
                            ItemStack junkStack = this.getImportItems().extractItem(this.seedSlot, this.getImportItems().getStackInSlot(this.seedSlot).func_190916_E(), true);
                            if (GTTransferUtils.addItemsToItemHandler((IItemHandler)this.getExportItems(), (boolean)true, Collections.singletonList(junkStack))) {
                                GTTransferUtils.addItemsToItemHandler((IItemHandler)this.getExportItems(), (boolean)false, Collections.singletonList(this.getImportItems().extractItem(this.seedSlot, this.getImportItems().getStackInSlot(this.seedSlot).func_190916_E(), false)));
                            }
                        }
                    }
                }
                if (canPlaceSeed && (result = this.cachedMode.place(seedItem, this.getWorld(), GTFOUtils.copy((BlockPos)this.operationPosition), this)) == EnumActionResult.SUCCESS) {
                    this.getImportItems().extractItem(this.seedSlot, 1, false);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isCropSpaceEmpty() {
        if (!FarmerModeRegistry.canUseAirOptimization) {
            return true;
        }
        return this.getWorld().func_175623_d((BlockPos)this.operationPosition);
    }

    protected int getEnergyConsumedPerTick() {
        return 16 * (1 << (this.getTier() - 1) * 2);
    }

    private void updateOperationPosition() {
        this.operationPosition.func_189536_c(this.getFrontFacing().func_176735_f());
        if (!this.isOperationPositionInsideWorkingArea()) {
            this.operationPosition.func_189534_c(this.getFrontFacing().func_176746_e(), 9).func_189536_c(this.getFrontFacing());
            if (!this.isOperationPositionInsideWorkingArea()) {
                this.setDefaultOperationPosition();
                this.unusableHarvestingModes.clear();
                if (!this.isOperationPositionInsideWorkingArea() && !this.getWorld().field_72995_K) {
                    this.setupWorkingArea();
                }
            }
        }
    }

    private void setupWorkingArea() {
        this.workingArea = new AxisAlignedBB(this.getPos().func_177972_a(this.getFrontFacing()).func_177967_a(this.getFrontFacing().func_176746_e(), 4), this.getPos().func_177967_a(this.getFrontFacing(), 9).func_177967_a(this.getFrontFacing().func_176735_f(), 4)).func_186662_g(0.1);
        if (this.operationPosition == null || !this.isOperationPositionInsideWorkingArea()) {
            this.setDefaultOperationPosition();
            this.writeCustomData(GTFOValues.UPDATE_OPERATION_POS, buf -> buf.func_179255_a((BlockPos)this.operationPosition));
        }
    }

    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.UPDATE_FRONT_FACING) {
            this.setupWorkingArea();
            this.setDefaultOperationPosition();
        } else if (dataId == GregtechDataCodes.IS_WORKING) {
            this.isWorking = buf.readBoolean();
            this.getHolder().scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.WORKING_ENABLED) {
            this.isWorkingEnabled = buf.readBoolean();
            this.getHolder().scheduleRenderUpdate();
        } else if (dataId == GTFOValues.UPDATE_OPERATION_POS) {
            this.operationPosition = new BlockPos.MutableBlockPos(buf.func_179259_c());
            this.getHolder().scheduleRenderUpdate();
        } else if (dataId == GTFOValues.UPDATE_FARMER_OUTPUT_FACING) {
            this.outputFacing = EnumFacing.field_82609_l[buf.readByte()];
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.UPDATE_AUTO_OUTPUT_ITEMS) {
            this.autoOutputItems = buf.readBoolean();
            this.scheduleRenderUpdate();
        }
    }

    public void setFrontFacing(EnumFacing frontFacing) {
        super.setFrontFacing(frontFacing);
        if (this.outputFacing == null) {
            this.setOutputFacing(frontFacing.func_176734_d());
        }
        this.setupWorkingArea();
        this.setDefaultOperationPosition();
    }

    protected IItemHandlerModifiable createImportItemHandler() {
        return new NotifiableItemStackHandler((MetaTileEntity)this, 9, (MetaTileEntity)this, false);
    }

    protected IItemHandlerModifiable createExportItemHandler() {
        return new NotifiableItemStackHandler((MetaTileEntity)this, 9, (MetaTileEntity)this, true);
    }

    protected ModularUI createUI(EntityPlayer entityPlayer) {
        ModularUI.Builder builder = ModularUI.builder((IGuiTexture)GuiTextures.BACKGROUND, (int)176, (int)183).label(10, 5, this.getMetaFullName()).widget((Widget)new SlotWidget((IItemHandler)this.chargerInventory, 0, 79, 80, true, true, false).setBackgroundTexture(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.CHARGER_OVERLAY}).setTooltipText("gregtech.gui.charger_slot.tooltip", new Object[]{GTValues.VNF[this.getTier()], GTValues.VNF[this.getTier()]}));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int index = i * 3 + j;
                builder.widget((Widget)new SlotWidget((IItemHandler)this.importItems, index, 28 + j * 18, 18 + i * 18, true, true).setBackgroundTexture(new IGuiTexture[]{GuiTextures.SLOT, GTFOGuiTextures.SEED_OVERLAY}));
                builder.widget((Widget)new SlotWidget((IItemHandler)this.exportItems, index, 94 + j * 18, 18 + i * 18, true, false).setBackgroundTexture(new IGuiTexture[]{GuiTextures.SLOT, GTFOGuiTextures.CROP_OVERLAY}));
            }
        }
        builder.widget((Widget)new ToggleButtonWidget(7, 80, 18, 18, GuiTextures.BUTTON_ITEM_OUTPUT, this::isAutoOutputItems, this::setAutoOutputItems).shouldUseBaseBackground().setTooltipText("gregtech.gui.item_auto_output.tooltip", new Object[0]));
        builder.widget((Widget)new ImageWidget(152, 80, 17, 17, (IGuiTexture)((Boolean)GTValues.XMAS.get() != false ? GTFOGuiTextures.GTFO_LOGO_XMAS : GTFOGuiTextures.GTFO_LOGO)).setIgnoreColor(true));
        builder.bindPlayerInventory(entityPlayer.field_71071_by, (IGuiTexture)GuiTextures.SLOT, 7, 101);
        return builder.build((IUIHolder)this.getHolder(), entityPlayer);
    }

    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        OrientedOverlayRenderer renderer = GTFOClientHandler.FARMER_OVERLAY;
        renderer.renderOrientedState(renderState, translation, pipeline, Cuboid6.full, this.getFrontFacing(), this.isWorking, this.isWorkingEnabled);
        if (this.outputFacing != null) {
            Textures.PIPE_OUT_OVERLAY.renderSided(this.outputFacing, renderState, translation, pipeline);
            if (this.isAutoOutputItems()) {
                Textures.ITEM_OUTPUT_OVERLAY.renderSided(this.outputFacing, renderState, translation, pipeline);
            }
        }
    }

    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.isWorking = buf.readBoolean();
        this.operationPosition = new BlockPos.MutableBlockPos(buf.func_179259_c());
        this.isWorkingEnabled = buf.readBoolean();
        this.setupWorkingArea();
        this.outputFacing = EnumFacing.field_82609_l[buf.readByte()];
        this.autoOutputItems = buf.readBoolean();
    }

    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        this.setupWorkingArea();
        buf.writeBoolean(this.isWorking);
        buf.func_179255_a((BlockPos)this.operationPosition);
        buf.writeBoolean(this.isWorkingEnabled);
        buf.writeByte(this.getOutputFacing().func_176745_a());
        buf.writeBoolean(this.autoOutputItems);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74772_a("operationPosition", this.operationPosition.func_177986_g());
        data.func_74757_a("isWorkingEnabled", this.isWorkingEnabled);
        data.func_74768_a("OutputFacing", this.getOutputFacing().func_176745_a());
        data.func_74757_a("AutoOutputItems", this.autoOutputItems);
        data.func_74757_a("AllowInputFromOutputSide", this.allowInputFromOutputSide);
        data.func_74782_a("ChargerInventory", (NBTBase)this.chargerInventory.serializeNBT());
        return data;
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.operationPosition = new BlockPos.MutableBlockPos(BlockPos.func_177969_a((long)data.func_74763_f("operationPosition")));
        this.isWorkingEnabled = data.func_74767_n("isWorkingEnabled");
        this.outputFacing = EnumFacing.field_82609_l[data.func_74762_e("OutputFacing")];
        this.autoOutputItems = data.func_74767_n("AutoOutputItems");
        this.allowInputFromOutputSide = data.func_74767_n("AllowInputFromOutputSide");
        this.chargerInventory.deserializeNBT(data.func_74775_l("ChargerInventory"));
    }

    private boolean isOperationPositionInsideWorkingArea() {
        return this.workingArea.func_72318_a(new Vec3d((double)this.operationPosition.func_177958_n(), (double)this.operationPosition.func_177956_o(), (double)this.operationPosition.func_177952_p()));
    }

    private void setDefaultOperationPosition() {
        this.operationPosition = new BlockPos.MutableBlockPos(this.getPos().func_177972_a(this.getFrontFacing()).func_177967_a(this.getFrontFacing().func_176746_e(), 4));
        this.writeCustomData(GTFOValues.UPDATE_OPERATION_POS, buf -> buf.func_179255_a((BlockPos)this.operationPosition));
    }

    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.voltage_in", (Object[])new Object[]{this.energyContainer.getInputVoltage(), GTValues.VNF[this.getTier()]}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{this.energyContainer.getEnergyCapacity(), GTValues.VNF[this.getTier()]}));
        tooltip.add(I18n.func_135052_a((String)"gregtechfoodoption.machine.farmer.tooltip.flavor", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtechfoodoption.machine.farmer.tooltip.consumption", (Object[])new Object[]{this.getEnergyConsumedPerTick()}));
        tooltip.add(I18n.func_135052_a((String)"gregtechfoodoption.machine.farmer.tooltip.working", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtechfoodoption.machine.farmer.tooltip.speed", (Object[])new Object[]{this.ticksPerAction}));
    }

    public boolean isWorkingEnabled() {
        return this.isWorkingEnabled;
    }

    public void setWorkingEnabled(boolean b) {
        this.isWorkingEnabled = b;
        this.writeCustomData(GregtechDataCodes.WORKING_ENABLED, buf -> buf.writeBoolean(b));
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return (T)super.getCapability(capability, side);
    }

    public EnumFacing getOutputFacing() {
        return this.outputFacing == null ? this.frontFacing.func_176734_d() : this.outputFacing;
    }

    public boolean isAutoOutputItems() {
        return this.autoOutputItems;
    }

    public boolean isAutoOutputFluids() {
        return false;
    }

    public boolean isAllowInputFromOutputSideItems() {
        return this.allowInputFromOutputSide;
    }

    public boolean isAllowInputFromOutputSideFluids() {
        return false;
    }

    public boolean onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        EnumFacing hitFacing = CoverRayTracer.determineGridSideHit((RayTraceResult)hitResult);
        if (facing == this.getOutputFacing() || hitFacing == this.getOutputFacing() && playerIn.func_70093_af()) {
            if (!this.getWorld().field_72995_K) {
                if (this.isAllowInputFromOutputSideItems()) {
                    this.setAllowInputFromOutputSide(false);
                    playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.machine.basic.input_from_output_side.disallow", new Object[0]));
                } else {
                    this.setAllowInputFromOutputSide(true);
                    playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.machine.basic.input_from_output_side.allow", new Object[0]));
                }
            }
            return true;
        }
        return super.onScrewdriverClick(playerIn, hand, facing, hitResult);
    }

    public void setAllowInputFromOutputSide(boolean allowInputFromOutputSide) {
        this.allowInputFromOutputSide = allowInputFromOutputSide;
        if (!this.getWorld().field_72995_K) {
            this.markDirty();
        }
    }

    public boolean onWrenchClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (!playerIn.func_70093_af()) {
            if (this.getOutputFacing() == facing || this.getFrontFacing() == facing) {
                return false;
            }
            if (!this.getWorld().field_72995_K) {
                this.setOutputFacing(facing);
            }
            return true;
        }
        return super.onWrenchClick(playerIn, hand, facing, hitResult);
    }

    public void setOutputFacing(EnumFacing outputFacing) {
        this.outputFacing = outputFacing;
        if (!this.getWorld().field_72995_K) {
            this.notifyBlockUpdate();
            this.writeCustomData(GTFOValues.UPDATE_FARMER_OUTPUT_FACING, buf -> buf.writeByte(outputFacing.func_176745_a()));
            this.markDirty();
        }
    }

    public void setAutoOutputItems(boolean autoOutputItems) {
        this.autoOutputItems = autoOutputItems;
        if (!this.getWorld().field_72995_K) {
            this.writeCustomData(GregtechDataCodes.UPDATE_AUTO_OUTPUT_ITEMS, buf -> buf.writeBoolean(autoOutputItems));
            this.markDirty();
        }
    }

    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    public void clearMachineInventory(NonNullList<ItemStack> itemBuffer) {
        super.clearMachineInventory(itemBuffer);
        MetaTileEntityFarmer.clearInventory(itemBuffer, (IItemHandlerModifiable)this.chargerInventory);
    }
}

