/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.machines.farmer;

import gregtechfoodoption.machines.farmer.FarmerMode;
import gregtechfoodoption.machines.farmer.MetaTileEntityFarmer;
import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayPriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChorusFlower;
import net.minecraft.block.BlockChorusPlant;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ChorusFarmerMode
implements FarmerMode {
    @Override
    public boolean canOperate(IBlockState blockState, MetaTileEntityFarmer farmer, BlockPos pos, World world) {
        if (blockState.func_177230_c() != Blocks.field_185765_cR && blockState.func_177230_c() != Blocks.field_185766_cS) {
            return false;
        }
        Iterator<BlockPos> it = this.getChorusIterator(pos, world);
        while (it.hasNext()) {
            IBlockState state = world.func_180495_p(it.next());
            if (state.func_177230_c() != Blocks.field_185766_cS || (Integer)state.func_177229_b((IProperty)BlockChorusFlower.field_185607_a) == 5) continue;
            return false;
        }
        return true;
    }

    private Iterator<BlockPos> getChorusIterator(final BlockPos pos, final World world) {
        return new Iterator<BlockPos>(){
            final PriorityQueue<BlockPos> plantQueue;
            final Set<BlockPos> visited;
            final World myWorld;
            {
                this.plantQueue = new ObjectArrayPriorityQueue((Object[])new BlockPos[]{pos});
                this.visited = new ObjectOpenHashSet();
                this.myWorld = world;
            }

            @Override
            public boolean hasNext() {
                return !this.plantQueue.isEmpty();
            }

            @Override
            public BlockPos next() {
                BlockPos blockPos = (BlockPos)this.plantQueue.dequeue();
                this.visited.add(blockPos);
                IBlockState state = this.myWorld.func_180495_p(blockPos);
                if (state.func_177227_a().contains(BlockChorusPlant.field_185613_e)) {
                    if (((Boolean)(state = Blocks.field_185765_cR.func_176221_a(state, (IBlockAccess)this.myWorld, blockPos)).func_177229_b((IProperty)BlockChorusPlant.field_185613_e)).booleanValue()) {
                        this.add(blockPos.func_177984_a());
                    }
                    if (((Boolean)state.func_177229_b((IProperty)BlockChorusPlant.field_185610_b)).booleanValue()) {
                        this.add(blockPos.func_177974_f());
                    }
                    if (((Boolean)state.func_177229_b((IProperty)BlockChorusPlant.field_185612_d)).booleanValue()) {
                        this.add(blockPos.func_177976_e());
                    }
                    if (((Boolean)state.func_177229_b((IProperty)BlockChorusPlant.field_185609_a)).booleanValue()) {
                        this.add(blockPos.func_177978_c());
                    }
                    if (((Boolean)state.func_177229_b((IProperty)BlockChorusPlant.field_185611_c)).booleanValue()) {
                        this.add(blockPos.func_177968_d());
                    }
                }
                return blockPos;
            }

            private void add(BlockPos pos2) {
                if (!this.visited.contains(pos2)) {
                    this.plantQueue.enqueue((Object)pos2);
                }
            }
        };
    }

    @Override
    public List<ItemStack> getDrops(IBlockState blockState, World world, BlockPos.MutableBlockPos pos, MetaTileEntityFarmer farmer) {
        NonNullList drops = NonNullList.func_191196_a();
        Iterator<BlockPos> it = this.getChorusIterator((BlockPos)pos, world);
        while (it.hasNext()) {
            IBlockState state = world.func_180495_p(it.next());
            if (state.func_177230_c() == Blocks.field_185766_cS) {
                drops.add((Object)new ItemStack(Blocks.field_185766_cS, 1));
                continue;
            }
            state.func_177230_c().getDrops(drops, (IBlockAccess)world, (BlockPos)pos, state, 0);
        }
        return drops;
    }

    @Override
    public boolean canPlaceItem(ItemStack stack) {
        return stack.func_77969_a(new ItemStack(Blocks.field_185766_cS));
    }

    @Override
    public void harvest(IBlockState state, World world, BlockPos.MutableBlockPos pos, MetaTileEntityFarmer farmer) {
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        Iterator<BlockPos> it = this.getChorusIterator((BlockPos)pos, world);
        while (it.hasNext()) {
            blocks.add(it.next());
        }
        Collections.sort(blocks);
        for (int i = blocks.size() - 1; i >= 0; --i) {
            world.func_175718_b(2001, (BlockPos)blocks.get(i), Block.func_176210_f((IBlockState)state));
            world.func_175698_g((BlockPos)blocks.get(i));
        }
    }
}

