/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.machines;

import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.RecipeLogicEnergy;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.client.renderer.ICubeRenderer;
import gregtechfoodoption.client.GTFOClientHandler;
import gregtechfoodoption.item.GTFOSimpleMachineMetaTileEntity;
import gregtechfoodoption.recipe.GTFORecipeMaps;
import gregtechfoodoption.recipe.properties.CauseDamageProperty;
import gregtechfoodoption.recipe.properties.MobOnTopProperty;
import gregtechfoodoption.utils.GTFODamageSources;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.items.IItemHandlerModifiable;

public class MetaTileEntityMobExtractor
extends GTFOSimpleMachineMetaTileEntity {
    private AxisAlignedBB boundingBox;
    private EntityLivingBase attackableTarget;
    private List<Entity> nearbyEntities;

    public MetaTileEntityMobExtractor(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, ICubeRenderer renderer, int tier, boolean hasFrontFacing, Function<Integer, Integer> tankScalingFunction) {
        super(metaTileEntityId, recipeMap, renderer, tier, hasFrontFacing, tankScalingFunction);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity holder) {
        return new MetaTileEntityMobExtractor(this.metaTileEntityId, GTFORecipeMaps.MOB_EXTRACTOR_RECIPES, (ICubeRenderer)GTFOClientHandler.MOB_EXTRACTOR_OVERLAY, this.getTier(), this.hasFrontFacing(), this.getTankScalingFunction());
    }

    protected RecipeLogicEnergy createWorkable(RecipeMap<?> recipeMap) {
        return new MobExtractorRecipeLogic((MetaTileEntity)this, recipeMap, () -> this.energyContainer);
    }

    protected boolean checkRecipe(@Nonnull Recipe recipe) {
        ResourceLocation entityRequired = (ResourceLocation)recipe.getProperty((RecipeProperty)MobOnTopProperty.getInstance(), null);
        if (entityRequired == null) {
            return true;
        }
        if (this.attackableTarget == null || this.getOffsetTimer() % 5L == 0L) {
            this.nearbyEntities = this.getEntitiesInProximity();
            for (Entity entity : this.nearbyEntities) {
                if (!EntityList.func_180123_a((Entity)entity, (ResourceLocation)entityRequired)) continue;
                this.attackableTarget = entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
                return true;
            }
        }
        return this.attackableTarget != null;
    }

    protected List<Entity> getEntitiesInProximity() {
        if (this.boundingBox == null) {
            this.boundingBox = new AxisAlignedBB(this.getPos().func_177984_a());
        }
        return this.getWorld().func_72872_a(Entity.class, this.boundingBox);
    }

    protected void damageEntity(Recipe recipe) {
        float damage;
        if (this.attackableTarget != null && recipe.hasProperty((RecipeProperty)CauseDamageProperty.getInstance()) && (damage = ((Float)recipe.getProperty((RecipeProperty)CauseDamageProperty.getInstance(), (Object)Float.valueOf(0.0f))).floatValue()) > 0.0f) {
            this.attackableTarget.func_70097_a(GTFODamageSources.EXTRACTION, damage);
            if (this.attackableTarget.field_70128_L) {
                this.attackableTarget = null;
            }
        }
    }

    private static class MobExtractorRecipeLogic
    extends RecipeLogicEnergy {
        public MobExtractorRecipeLogic(MetaTileEntity metaTileEntity, RecipeMap<?> recipeMap, Supplier<IEnergyContainer> energyContainer) {
            super(metaTileEntity, recipeMap, energyContainer);
        }

        protected boolean checkPreviousRecipe() {
            return super.checkPreviousRecipe() && this.checkRecipe(this.previousRecipe);
        }

        public boolean checkRecipe(Recipe recipe) {
            return ((MetaTileEntityMobExtractor)this.metaTileEntity).checkRecipe(recipe);
        }

        protected boolean setupAndConsumeRecipeInputs(Recipe recipe, IItemHandlerModifiable importInventory) {
            ((MetaTileEntityMobExtractor)this.metaTileEntity).damageEntity(recipe);
            return super.setupAndConsumeRecipeInputs(recipe, importInventory);
        }
    }
}

