/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.machines;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IUIHolder;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.widgets.ToggleButtonWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.TieredMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.client.renderer.texture.cube.OrientedOverlayRenderer;
import gregtechfoodoption.client.GTFOClientHandler;
import gregtechfoodoption.client.GTFOGuiTextures;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MetaTileEntityMobAgeSorter
extends TieredMetaTileEntity {
    private static final int BASE_EU_CONSUMPTION = 8;
    private boolean isWorking;
    private AxisAlignedBB areaBoundingBox;
    private final int suckingRange;
    private boolean movesAdults;
    private BlockPos areaCenterPos;

    public MetaTileEntityMobAgeSorter(ResourceLocation metaTileEntityId, int tier, int suckingRange) {
        super(metaTileEntityId, tier);
        this.suckingRange = suckingRange;
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity holder) {
        return new MetaTileEntityMobAgeSorter(this.metaTileEntityId, this.getTier(), this.suckingRange);
    }

    public void update() {
        boolean isWorkingNow;
        super.update();
        if (this.getWorld().field_72995_K) {
            return;
        }
        boolean bl = isWorkingNow = this.energyContainer.getEnergyStored() >= (long)this.getEnergyConsumedPerTick() && this.isBlockRedstonePowered();
        if (isWorkingNow) {
            this.energyContainer.removeEnergy((long)this.getEnergyConsumedPerTick());
            BlockPos selfPos = this.getPos();
            if (this.areaCenterPos == null || this.areaBoundingBox == null) {
                this.areaCenterPos = selfPos.func_177967_a(this.getFrontFacing(), this.suckingRange);
                this.areaBoundingBox = new AxisAlignedBB(this.areaCenterPos).func_72314_b((double)(this.suckingRange - 1), 1.0, (double)(this.suckingRange - 1));
            }
            List animals = this.getWorld().func_72872_a(EntityLivingBase.class, this.areaBoundingBox);
            animals.removeIf(animal -> animal.func_70631_g_() != this.movesAdults);
            if (!animals.isEmpty()) {
                BlockPos pos = this.getPos().func_177972_a(this.getFrontFacing().func_176734_d());
                ((EntityLivingBase)animals.get(0)).func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            }
        }
        if (isWorkingNow != this.isWorking) {
            this.isWorking = isWorkingNow;
            this.writeCustomData(GregtechDataCodes.IS_WORKING, buffer -> buffer.writeBoolean(isWorkingNow));
        }
    }

    protected int getEnergyConsumedPerTick() {
        return 8 * (1 << (this.getTier() - 1) * 2);
    }

    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isWorking);
        buf.writeBoolean(this.movesAdults);
    }

    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.isWorking = buf.readBoolean();
        this.movesAdults = buf.readBoolean();
    }

    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.IS_WORKING) {
            this.isWorking = buf.readBoolean();
            this.getHolder().scheduleRenderUpdate();
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("MovesChildren", this.movesAdults);
        return data;
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.movesAdults = data.func_74767_n("MovesChildren");
    }

    protected ModularUI createUI(EntityPlayer entityPlayer) {
        ModularUI.Builder builder = ModularUI.builder((IGuiTexture)GuiTextures.BACKGROUND, (int)150, (int)50).label(10, 6, this.getMetaFullName());
        builder.widget((Widget)new ToggleButtonWidget(10, 20, 20, 20, this::getAgeFilter, data -> this.invertFilter()).setButtonTexture(GTFOGuiTextures.BUTTON_MOB_SORTER_MODE).setTooltipText("gregtechfoodoption.gui.mob_age_sorter_mode", new Object[0]));
        return builder.build((IUIHolder)this.getHolder(), entityPlayer);
    }

    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        OrientedOverlayRenderer renderer = GTFOClientHandler.MOB_AGE_SORTER_OVERLAY;
        renderer.renderOrientedState(renderState, translation, pipeline, Cuboid6.full, this.getFrontFacing(), this.isWorking, true);
    }

    private void invertFilter() {
        this.movesAdults = !this.movesAdults;
    }

    private boolean getAgeFilter() {
        return this.movesAdults;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtechfoodoption.machine.mob_age_sorter.range", (Object[])new Object[]{this.suckingRange, this.suckingRange}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.max_voltage_in", (Object[])new Object[]{this.energyContainer.getInputVoltage(), GTValues.VNF[this.getTier()]}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{this.energyContainer.getEnergyCapacity()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.requires_redstone", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.uses_per_tick", (Object[])new Object[]{this.getEnergyConsumedPerTick()}));
    }
}

