/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.machines;

import gregtech.api.GTValues;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.RecipeLogicEnergy;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.client.renderer.ICubeRenderer;
import gregtechfoodoption.client.GTFOClientHandler;
import gregtechfoodoption.item.GTFOSimpleMachineMetaTileEntity;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;

public class MetaTileEntityMicrowave
extends GTFOSimpleMachineMetaTileEntity {
    public MetaTileEntityMicrowave(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, ICubeRenderer renderer, int tier) {
        super(metaTileEntityId, recipeMap, renderer, tier, true);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityMicrowave(this.metaTileEntityId, this.workable.getRecipeMap(), this.renderer, this.getTier());
    }

    public void update() {
        if (this.energyContainer.getEnergyStored() > GTValues.V[this.getTier()]) {
            MaterialStack materialIn = OreDictUnifier.getMaterial((ItemStack)this.importItems.getStackInSlot(0));
            if (materialIn != null && (materialIn.material.hasProperty(PropertyKey.INGOT) || materialIn.material.hasFlag(MaterialFlags.FLAMMABLE) || materialIn.material.hasFlag(MaterialFlags.EXPLOSIVE))) {
                this.doExplosion(this.getTier() * 4);
                return;
            }
            if (TileEntityFurnace.func_145952_a((ItemStack)this.importItems.getStackInSlot(0)) > 0) {
                this.doExplosion(this.getTier() * 4);
                return;
            }
        }
        super.update();
    }

    protected RecipeLogicEnergy createWorkable(RecipeMap<?> recipeMap) {
        return new RecipeLogicMicrowave((MetaTileEntity)this, recipeMap, () -> this.energyContainer);
    }

    public class RecipeLogicMicrowave
    extends RecipeLogicEnergy {
        public RecipeLogicMicrowave(MetaTileEntity tileEntity, RecipeMap<?> recipeMap, Supplier<IEnergyContainer> energyContainer) {
            super(tileEntity, recipeMap, energyContainer);
        }

        protected void trySearchNewRecipe() {
            super.trySearchNewRecipe();
            if (this.wasActiveAndNeedsUpdate) {
                MetaTileEntityMicrowave.this.getWorld().func_184148_a(null, (double)MetaTileEntityMicrowave.this.getPos().func_177958_n() + 0.5, (double)MetaTileEntityMicrowave.this.getPos().func_177956_o() + 0.5, (double)MetaTileEntityMicrowave.this.getPos().func_177952_p() + 0.5, GTFOClientHandler.MICROWAVE_FINISH, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
    }
}

