/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.item;

import gregtech.api.items.metaitem.stats.IFoodBehavior;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.util.RandomPotionEffect;
import gregtechfoodoption.integration.applecore.GTFOAppleCoreCompat;
import gregtechfoodoption.potion.LacingEntry;
import gregtechfoodoption.utils.GTFOUtils;
import it.unimi.dsi.fastutil.objects.Object2FloatArrayMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.Loader;

public class GTFOFoodStats
implements IFoodBehavior,
IItemBehaviour {
    protected int foodLevel;
    protected float saturation;
    protected boolean isDrink;
    protected boolean alwaysEdible;
    public RandomPotionEffect[] potionEffects;
    public Supplier<ItemStack> stackSupplier;
    public Object2FloatMap<String> nutrients = new Object2FloatArrayMap();
    protected int eatingDuration = 32;

    public GTFOFoodStats(int foodLevel, float saturation, boolean isDrink, boolean alwaysEdible, Supplier<ItemStack> itemStackSupplier, RandomPotionEffect ... potionEffects) {
        this.foodLevel = foodLevel;
        this.saturation = saturation;
        this.isDrink = isDrink;
        this.alwaysEdible = alwaysEdible;
        this.stackSupplier = itemStackSupplier;
        this.potionEffects = potionEffects;
    }

    public GTFOFoodStats(int foodLevel, float saturation, boolean isDrink, boolean alwaysEdible, ItemStack stack, RandomPotionEffect ... potionEffects) {
        this.foodLevel = foodLevel;
        this.saturation = saturation;
        this.isDrink = isDrink;
        this.alwaysEdible = alwaysEdible;
        this.stackSupplier = () -> stack;
        this.potionEffects = potionEffects;
    }

    public GTFOFoodStats(int foodLevel, float saturation, boolean isDrink, boolean alwaysEdible) {
        this(foodLevel, saturation, isDrink, alwaysEdible, ItemStack.field_190927_a, new RandomPotionEffect[0]);
    }

    public GTFOFoodStats(int foodLevel, float saturation) {
        this(foodLevel, saturation, false, false);
    }

    public EnumAction getFoodAction(ItemStack itemStack) {
        return this.isDrink ? EnumAction.DRINK : EnumAction.EAT;
    }

    public int getFoodLevel(ItemStack itemStack, EntityPlayer player) {
        return this.foodLevel;
    }

    public float getSaturation(ItemStack itemStack, EntityPlayer player) {
        return this.saturation;
    }

    public boolean alwaysEdible(ItemStack itemStack, EntityPlayer player) {
        return this.alwaysEdible;
    }

    public GTFOFoodStats setReturnStack(ItemStack stack) {
        this.stackSupplier = () -> stack;
        return this;
    }

    public ItemStack onFoodEaten(ItemStack itemStack, EntityPlayer player) {
        NBTTagCompound nbtStats = itemStack.func_179543_a("gtfoStats");
        if (nbtStats != null) {
            LacingEntry.LACING_REGISTRY.forEach(lacingEntry -> {
                if (nbtStats.func_74767_n(lacingEntry.getNbtKey())) {
                    player.func_70690_d(lacingEntry.getAppliedEffect());
                }
            });
        }
        if (Loader.isModLoaded((String)"applecore")) {
            itemStack.func_190917_f(1);
            GTFOAppleCoreCompat.sendEatenEvent(player, itemStack, this.getFoodLevel(itemStack, player), this.getSaturation(itemStack, player));
            itemStack.func_190918_g(1);
        }
        for (RandomPotionEffect potionEffect : this.potionEffects) {
            if (!(Math.random() * 100.0 > (double)potionEffect.chance)) continue;
            player.func_70690_d(new PotionEffect(potionEffect.effect));
        }
        if (player != null && !player.field_70170_p.field_72995_K && this.stackSupplier != null) {
            ItemStack containerItem = this.stackSupplier.get().func_77946_l();
            if (!player.field_71075_bZ.field_75098_d) {
                if (itemStack.func_190926_b()) {
                    return containerItem;
                }
                if (!player.field_71071_by.func_70441_a(containerItem)) {
                    player.func_146097_a(containerItem, false, false);
                }
            }
        }
        return itemStack;
    }

    public void addInformation(ItemStack itemStack, List<String> list) {
        if (this.potionEffects.length > 0) {
            GTFOUtils.addPotionTooltip(Arrays.asList(this.potionEffects), list);
        }
        list.add(new TextComponentTranslation("gregtechfoodoption.tooltip.food.lacing", new Object[0]).func_150254_d());
        if (this.eatingDuration != 32) {
            list.add(new TextComponentTranslation("gregtechfoodoption.tooltip.food.duration", new Object[]{this.eatingDuration}).func_150254_d());
        }
    }

    public GTFOFoodStats setEatingDuration(int duration) {
        this.eatingDuration = duration;
        return this;
    }

    public GTFOFoodStats setPotionEffects(RandomPotionEffect ... effects) {
        this.potionEffects = effects;
        return this;
    }

    public int getEatingDuration() {
        return this.eatingDuration;
    }

    public RandomPotionEffect[] getPotionEffects() {
        return this.potionEffects;
    }

    public Supplier<ItemStack> getStackSupplier() {
        return this.stackSupplier;
    }

    public GTFOFoodStats nutrients(float dairy, float fruit, float grain, float protein, float vegetable) {
        if (dairy > 0.0f) {
            this.nutrients.put((Object)"dairy", dairy);
        }
        if (fruit > 0.0f) {
            this.nutrients.put((Object)"fruit", fruit);
        }
        if (grain > 0.0f) {
            this.nutrients.put((Object)"grain", grain);
        }
        if (protein > 0.0f) {
            this.nutrients.put((Object)"protein", protein);
        }
        if (vegetable > 0.0f) {
            this.nutrients.put((Object)"vegetable", vegetable);
        }
        return this;
    }
}

