/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.item;

import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtechfoodoption.block.GTFOCrop;
import gregtechfoodoption.block.GTFORootCrop;
import gregtechfoodoption.block.GTFOWaterCrop;
import gregtechfoodoption.integration.sereneseasons.GTFOSSTooltipHandler;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;

public class GTFOCropSeedBehaviour
implements IItemBehaviour {
    protected final GTFOCrop crop;

    public GTFOCropSeedBehaviour(GTFOCrop cropBlock, ItemStack seed, ItemStack crop) {
        cropBlock.setSeed(seed);
        cropBlock.setCrop(crop);
        this.crop = cropBlock;
    }

    public ActionResult<ItemStack> onItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.crop instanceof GTFOWaterCrop && world.func_175623_d(pos.func_177981_b(2)) && this.crop.func_176223_P().func_177230_c().func_176196_c(world, pos.func_177981_b(2))) {
            world.func_175656_a(pos.func_177981_b(2), this.crop.func_176223_P());
            ItemStack heldItem = player.func_184586_b(hand);
            heldItem.func_190918_g(1);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        if (world.func_175623_d(pos.func_177984_a()) && this.crop.func_176223_P().func_177230_c().func_176196_c(world, pos.func_177984_a())) {
            world.func_175656_a(pos.func_177984_a(), this.crop.func_176223_P());
            ItemStack heldItem = player.func_184586_b(hand);
            heldItem.func_190918_g(1);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
    }

    public void addInformation(ItemStack itemStack, List<String> lines) {
        lines.add(I18n.func_135052_a((String)"gregtechfoodoption.seed.0", (Object[])new Object[0]));
        if (this.crop instanceof GTFORootCrop) {
            lines.add(I18n.func_135052_a((String)"gregtechfoodoption.seed.root_crop", (Object[])new Object[0]));
        }
        if (this.crop instanceof GTFOWaterCrop) {
            lines.add(I18n.func_135052_a((String)"gregtechfoodoption.seed.water_crop", (Object[])new Object[0]));
        }
        if (Loader.isModLoaded((String)"sereneseasons")) {
            GTFOSSTooltipHandler.addTooltip(this.crop, lines);
        }
    }
}

