/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.integration.jei;

import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.metaitem.stats.IFoodBehavior;
import gregtech.api.items.metaitem.stats.IItemUseManager;
import gregtech.api.metatileentity.SimpleMachineMetaTileEntity;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.category.GTRecipeCategory;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.integration.jei.utils.ModularUIGuiHandler;
import gregtechfoodoption.integration.jei.EatingRecipeCategory;
import gregtechfoodoption.integration.jei.EatingRecipeInfo;
import gregtechfoodoption.integration.jei.LacingCategory;
import gregtechfoodoption.integration.jei.LacingInfo;
import gregtechfoodoption.item.GTFOFoodStats;
import gregtechfoodoption.item.food.GTFOFoodUseManager;
import gregtechfoodoption.potion.LacingEntry;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

@JEIPlugin
public class JEIGTFOPlugin
implements IModPlugin {
    private IIngredientBlacklist itemBlacklist;
    private IIngredientRegistry iItemRegistry;
    private IRecipeTransferRegistry iRecipeTransferRegistry;
    public static final List<ItemStack> itemStacksToHide = new ArrayList<ItemStack>();
    public static final List<FluidStack> fluidsToHide = new ArrayList<FluidStack>();
    public static final List<ItemStack> FOOD_ITEMS = new ArrayList<ItemStack>();

    public void register(@Nonnull IModRegistry registry) {
        this.iRecipeTransferRegistry = registry.getRecipeTransferRegistry();
        ModularUIGuiHandler kitchenGuiHandler = new ModularUIGuiHandler(registry.getJeiHelpers().recipeTransferHandlerHelper());
        for (RecipeMap recipeMap : RecipeMap.getRecipeMaps()) {
            if (recipeMap.isHidden) continue;
            for (Map.Entry entry2 : recipeMap.getRecipesByCategory().entrySet()) {
                registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferHandler)kitchenGuiHandler, ((GTRecipeCategory)entry2.getKey()).getUniqueID());
            }
        }
        this.itemBlacklist = registry.getJeiHelpers().getIngredientBlacklist();
        this.iItemRegistry = registry.getIngredientRegistry();
        itemStacksToHide.forEach(arg_0 -> ((IIngredientBlacklist)this.itemBlacklist).addIngredientToBlacklist(arg_0));
        fluidsToHide.forEach(arg_0 -> ((IIngredientBlacklist)this.itemBlacklist).addIngredientToBlacklist(arg_0));
        LacingEntry.LACING_REGISTRY.forEach(entry -> registry.addRecipes((Collection)ObjectSets.singleton((Object)new LacingInfo((LacingEntry)entry)), "gregtechfoodoption:lacing_info"));
        for (SimpleMachineMetaTileEntity cannerTier : MetaTileEntities.CANNER) {
            if (cannerTier == null) continue;
            registry.addRecipeCatalyst((Object)cannerTier.getStackForm(), new String[]{"gregtechfoodoption:lacing_info"});
        }
        JEIGTFOPlugin.initializeFoodItems(registry);
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new LacingCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new EatingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public static void initializeFoodItems(IModRegistry registry) {
        for (MetaItem metaItem : MetaItem.getMetaItems()) {
            for (MetaItem.MetaValueItem metaValueItem : metaItem.getAllItems()) {
                IItemUseManager iItemUseManager = metaValueItem.getUseManager();
                if (!(iItemUseManager instanceof GTFOFoodUseManager)) continue;
                GTFOFoodUseManager manager = (GTFOFoodUseManager)iItemUseManager;
                FOOD_ITEMS.add(metaValueItem.getStackForm());
                IFoodBehavior iFoodBehavior = manager.getFoodStats();
                if (!(iFoodBehavior instanceof GTFOFoodStats)) continue;
                GTFOFoodStats stats = (GTFOFoodStats)iFoodBehavior;
                if (stats.stackSupplier.get() == ItemStack.field_190927_a) continue;
                registry.addRecipes((Collection)ObjectSets.singleton((Object)new EatingRecipeInfo(metaValueItem.getStackForm(), stats.stackSupplier.get())), "gregtechfoodoption:eating_recipe");
            }
        }
    }
}

