/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.integration.jei;

import gregtech.api.gui.GuiTextures;
import gregtechfoodoption.integration.jei.EatingRecipeInfo;
import gregtechfoodoption.item.GTFOMetaItem;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import org.jetbrains.annotations.Nullable;

public class EatingRecipeCategory
implements IRecipeCategory<EatingRecipeInfo> {
    private final IDrawable icon;
    protected final IDrawable slot;
    private final IDrawable arrow;
    private final IGuiHelper guiHelper;

    public EatingRecipeCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.icon = guiHelper.createDrawableIngredient((Object)GTFOMetaItem.DIRTY_PLATE.getStackForm());
        this.slot = guiHelper.drawableBuilder(GuiTextures.SLOT.imageLocation, 0, 0, 18, 18).setTextureSize(18, 18).build();
        this.arrow = guiHelper.drawableBuilder(GuiTextures.PROGRESS_BAR_ARROW.imageLocation, 0, 20, 20, 20).setTextureSize(20, 40).build();
    }

    public String getUid() {
        return "gregtechfoodoption:eating_recipe";
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"eating.output.name", (Object[])new Object[0]);
    }

    public String getModName() {
        return "GregTech Food Option";
    }

    public IDrawable getBackground() {
        return this.guiHelper.createBlankDrawable(176, 50);
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayout recipeLayout, EatingRecipeInfo recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        itemStackGroup.init(0, true, 54, 16);
        itemStackGroup.set(0, recipeWrapper.foodInput);
        itemStackGroup.init(1, true, 104, 16);
        itemStackGroup.set(1, recipeWrapper.substrateOutput);
    }

    public void drawExtras(Minecraft minecraft) {
        this.slot.draw(minecraft, 54, 16);
        this.slot.draw(minecraft, 104, 16);
        this.arrow.draw(minecraft, 77, 14);
    }
}

