/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.integration.appleskin;

import gregtechfoodoption.integration.appleskin.GTFOMetaFoodHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.FoodStats;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import squeek.appleskin.AppleSkin;
import squeek.appleskin.ModConfig;
import squeek.appleskin.client.HUDOverlayHandler;
import squeek.appleskin.helpers.AppleCoreHelper;
import squeek.appleskin.helpers.FoodHelper;

public class GTFOMetaHUDOverlay {
    private float flashAlpha = 0.0f;
    private byte alphaDir = 1;
    protected int foodIconsOffset;

    public static void init() {
        if (Loader.isModLoaded((String)"appleskin")) {
            MinecraftForge.EVENT_BUS.register((Object)new GTFOMetaHUDOverlay());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPreRender(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.FOOD) {
            return;
        }
        this.foodIconsOffset = GuiIngameForge.right_height;
    }

    @SubscribeEvent
    public void onRender(RenderGameOverlayEvent event) {
        if (Loader.isModLoaded((String)"appleskin")) {
            if (event.getType() != RenderGameOverlayEvent.ElementType.FOOD) {
                return;
            }
            if (!ModConfig.SHOW_FOOD_VALUES_OVERLAY && !ModConfig.SHOW_SATURATION_OVERLAY) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP player = mc.field_71439_g;
            ItemStack heldItem = player.func_184614_ca();
            if (!GTFOMetaFoodHelper.isFood(heldItem)) {
                this.flashAlpha = 0.0f;
                this.alphaDir = 1;
                return;
            }
            FoodStats stats = player.func_71024_bL();
            ScaledResolution scale = event.getResolution();
            int left = scale.func_78326_a() / 2 + 91;
            int top = scale.func_78328_b() - this.foodIconsOffset;
            if (ModConfig.SHOW_SATURATION_OVERLAY) {
                HUDOverlayHandler.drawSaturationOverlay((float)0.0f, (float)stats.func_75115_e(), (Minecraft)mc, (int)left, (int)top, (float)1.0f);
            }
            FoodHelper.BasicFoodValues foodValues = GTFOMetaFoodHelper.getModifiedFoodValues(heldItem, (EntityPlayer)player);
            if (AppleSkin.hasAppleCore) {
                foodValues = AppleCoreHelper.getFoodValuesForDisplay((FoodHelper.BasicFoodValues)foodValues, (EntityPlayer)player);
            }
            HUDOverlayHandler.drawHungerOverlay((int)foodValues.hunger, (int)stats.func_75116_a(), (Minecraft)mc, (int)left, (int)top, (float)this.flashAlpha);
            if (ModConfig.SHOW_SATURATION_OVERLAY) {
                int newFoodValue = stats.func_75116_a() + foodValues.hunger;
                float newSaturationValue = stats.func_75115_e() + foodValues.getSaturationIncrement();
                HUDOverlayHandler.drawSaturationOverlay((float)(newSaturationValue > (float)newFoodValue ? (float)newFoodValue - stats.func_75115_e() : foodValues.getSaturationIncrement()), (float)stats.func_75115_e(), (Minecraft)mc, (int)left, (int)top, (float)this.flashAlpha);
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.flashAlpha += (float)this.alphaDir * 0.25f;
        if (this.flashAlpha >= 1.5f) {
            this.flashAlpha = 1.0f;
            this.alphaDir = (byte)-1;
        } else if (this.flashAlpha <= -0.5f) {
            this.flashAlpha = 0.0f;
            this.alphaDir = 1;
        }
    }
}

