/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.integration.applecore;

import gregtechfoodoption.GTFOConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import squeek.applecore.api.food.FoodEvent;
import squeek.applecore.api.food.FoodValues;
import squeek.applecore.api.food.IEdible;
import stanhebben.zenscript.annotations.ZenMethod;

public class GTFOAppleCoreCompat {
    private static final ArrayList<Item> sparedItems = new ArrayList();
    private static final HashMap<Item, FoodValues> sparedItemsFoodValues = new HashMap();
    private static final TreeMap<Float, ResourceLocation> foodReductionMap = new TreeMap(){
        {
            this.put(Float.valueOf(1.25f), new ResourceLocation("gregtech", "low_voltage/lv_root"));
            this.put(Float.valueOf(1.5f), new ResourceLocation("gregtech", "low_voltage/23_lv_assembler"));
            this.put(Float.valueOf(2.0f), new ResourceLocation("gregtech", "high_voltage/41_vacuum_freezer"));
            this.put(Float.valueOf(3.0f), new ResourceLocation("gregtech", "extreme_voltage/47_nichrome_coil"));
            this.put(Float.valueOf(5.0f), new ResourceLocation("gregtech", "insane_voltage/57_tungstensteel_coil"));
        }
    };
    public static final Map<UUID, Float> clientDivisorsMap = new HashMap<UUID, Float>();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void setFoodValuesForEvent(FoodEvent.GetPlayerFoodValues event) {
        event.foodValues = this.getGTFOFoodValues(event.unmodifiedFoodValues, event.food, event.player);
    }

    public FoodValues getGTFOFoodValues(FoodValues originalValues, ItemStack food, EntityPlayer player) {
        Item sparedFood = food.func_77973_b();
        if (sparedItems.contains(sparedFood)) {
            if (sparedItemsFoodValues.containsKey(sparedFood)) {
                return sparedItemsFoodValues.get(sparedFood);
            }
            return originalValues;
        }
        if (GTFOConfig.gtfoOtherFoodModConfig.reduceForeignFoodStats) {
            ItemStack actualFood = food;
            float modifier = this.getFoodModifier(player, actualFood);
            return this.getModifiedFoodValues(originalValues, modifier);
        }
        return originalValues;
    }

    private FoodValues getModifiedFoodValues(FoodValues foodValues, float modifier) {
        return new FoodValues((int)Math.max(1.0f, (float)foodValues.hunger / modifier), (float)Math.max(0.1, (double)(foodValues.saturationModifier / modifier)));
    }

    private float getFoodModifier(EntityPlayer player, ItemStack actualFood) {
        return actualFood.func_77973_b().getRegistryName().func_110624_b().equals("gregtechfoodoption") ? 1.0f : this.getForeignFoodDivisor(player);
    }

    private float getForeignFoodDivisor(EntityPlayer player) {
        if (GTFOConfig.gtfoOtherFoodModConfig.useDefaultForeignFoodStatsReduction) {
            return clientDivisorsMap.get(player.func_110124_au()).floatValue();
        }
        return GTFOConfig.gtfoOtherFoodModConfig.constantFoodStatsDivisor;
    }

    public static float advancementLookup(EntityPlayer player) {
        Map.Entry<Float, ResourceLocation> highestAdvancement = foodReductionMap.lastEntry();
        EntityPlayerMP serverPlayer = (EntityPlayerMP)player;
        do {
            if (GTFOAppleCoreCompat.resourceLocationToAdvancement(highestAdvancement.getValue(), serverPlayer.func_130014_f_()) == null || !serverPlayer.func_192039_O().func_192747_a(GTFOAppleCoreCompat.resourceLocationToAdvancement(highestAdvancement.getValue(), serverPlayer.field_70170_p)).func_192105_a()) continue;
            return highestAdvancement.getKey().floatValue();
        } while ((highestAdvancement = foodReductionMap.lowerEntry(highestAdvancement.getKey())) != null);
        return 1.0f;
    }

    public static float getDivisorOnAdvancement(Advancement advancement) {
        for (Map.Entry<Float, ResourceLocation> entry : foodReductionMap.entrySet()) {
            if (!entry.getValue().equals((Object)advancement.func_192067_g())) continue;
            return entry.getKey().floatValue();
        }
        return 1.0f;
    }

    private static Advancement resourceLocationToAdvancement(ResourceLocation location, World world) {
        AdvancementManager advManager = (AdvancementManager)ObfuscationReflectionHelper.getPrivateValue(World.class, (Object)world, (String)"field_191951_C");
        return advManager.func_192778_a(location);
    }

    @ZenMethod
    public static void addToSparedItems(Item item) {
        sparedItems.add(item);
    }

    @ZenMethod
    public static void addToSparedItems(Item item, int hunger, float saturation) {
        sparedItems.add(item);
        if (GTFOConfig.gtfoOtherFoodModConfig.appleCoreCompat) {
            sparedItemsFoodValues.put(item, new FoodValues(hunger, saturation));
        }
    }

    @Optional.Method(modid="applecore")
    public static void sendEatenEvent(EntityPlayer player, ItemStack itemStack, int hunger, float sat) {
        MinecraftForge.EVENT_BUS.post((Event)new FoodEvent.FoodEaten(player, itemStack, new FoodValues(hunger, sat), hunger, sat));
    }

    public static boolean isAppleCoreEdible(ItemStack stack) {
        return stack.func_77973_b() instanceof IEdible;
    }
}

