/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.gui.widgets;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.widgets.AbstractWidgetGroup;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.PhantomFluidWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.util.Position;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class PhantomRecipeWidget
extends AbstractWidgetGroup {
    private ItemStackHandler inputs = new ItemStackHandler(9);
    private boolean[] nonConsumableItems = new boolean[9];
    private FluidTank[] fluidInputs = new FluidTank[9];
    private boolean[] nonConsumableFluids = new boolean[9];
    private ItemStackHandler outputs = new ItemStackHandler(9);
    private FluidTank[] fluidOutputs = new FluidTank[9];

    public PhantomRecipeWidget(int x, int y) {
        super(new Position(x, y));
        int i;
        this.addWidget((Widget)new LabelWidget(x - 16, y + 4, "IN:", new Object[0]));
        for (i = 0; i < this.inputs.getSlots(); ++i) {
            this.addWidget((Widget)new SlotWidget((IItemHandler)this.inputs, i, x + i * 18, y, false, false).setBackgroundTexture(new IGuiTexture[]{GuiTextures.SLOT}));
        }
        for (i = 0; i < this.fluidInputs.length; ++i) {
            this.fluidInputs[i] = new FluidTank(99999);
            this.addWidget((Widget)new PhantomFluidWidget(x + i * 18, y + 20, 18, 18, this.fluidInputs[i]){

                public void handleClientAction(int id, PacketBuffer buffer) {
                }
            });
        }
        this.addWidget((Widget)new LabelWidget(x - 24, y + 44, "OUT:", new Object[0]));
        for (i = 0; i < this.outputs.getSlots(); ++i) {
            this.addWidget((Widget)new SlotWidget((IItemHandler)this.outputs, i, x + i * 18, y + 40, false, false).setBackgroundTexture(new IGuiTexture[]{GuiTextures.SLOT}));
        }
        for (i = 0; i < this.fluidOutputs.length; ++i) {
            this.fluidOutputs[i] = new FluidTank(99999);
            this.addWidget((Widget)new PhantomFluidWidget(x + i * 18, y + 60, 18, 18, this.fluidOutputs[i]){

                public void handleClientAction(int id, PacketBuffer buffer) {
                }
            });
        }
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        int i;
        if (nbt == null) {
            return;
        }
        NBTTagCompound inputs = nbt.func_74775_l("inputs");
        NBTTagCompound fluidInputs = nbt.func_74775_l("fluidInputs");
        NBTTagCompound outputs = nbt.func_74775_l("outputs");
        NBTTagCompound fluidOutputs = nbt.func_74775_l("fluidOutputs");
        this.clearSlots();
        for (i = 0; i < this.inputs.getSlots(); ++i) {
            this.inputs.setStackInSlot(i, new ItemStack(inputs.func_74775_l("item" + i)));
            this.nonConsumableItems[i] = inputs.func_74767_n("nonConsumable" + i);
        }
        for (i = 0; i < this.fluidInputs.length; ++i) {
            this.fluidInputs[i].readFromNBT(fluidInputs.func_74775_l("fluid" + i));
            this.nonConsumableFluids[i] = fluidInputs.func_74767_n("nonConsumable" + i);
        }
        for (i = 0; i < this.outputs.getSlots(); ++i) {
            this.outputs.setStackInSlot(i, new ItemStack(outputs.func_74775_l("item" + i)));
        }
        for (i = 0; i < this.fluidOutputs.length; ++i) {
            this.fluidOutputs[i].readFromNBT(fluidOutputs.func_74775_l("fluid" + i));
        }
    }

    public void clearSlots() {
        int i;
        for (i = 0; i < this.inputs.getSlots(); ++i) {
            this.inputs.setStackInSlot(i, ItemStack.field_190927_a);
        }
        for (i = 0; i < this.outputs.getSlots(); ++i) {
            this.outputs.setStackInSlot(i, ItemStack.field_190927_a);
        }
        for (i = 0; i < this.fluidInputs.length; ++i) {
            this.fluidInputs[i].setFluid(null);
        }
        for (i = 0; i < this.fluidOutputs.length; ++i) {
            this.fluidOutputs[i].setFluid(null);
        }
        this.nonConsumableItems = new boolean[9];
        this.nonConsumableFluids = new boolean[9];
    }
}

