/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.covers;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.cover.CoverBase;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverableView;
import gregtech.api.unification.material.Material;
import gregtechfoodoption.GTFOMaterialHandler;
import gregtechfoodoption.GTFOValues;
import gregtechfoodoption.client.GTFOClientHandler;
import gregtechfoodoption.client.particle.GTFOSprinkleMaker;
import gregtechfoodoption.materials.FertilizerProperty;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class CoverSprinkler
extends CoverBase
implements ITickable {
    private int tier;
    public BlockPos.MutableBlockPos operationPosition;
    private int sprinkleColor;
    private AxisAlignedBB workingArea;
    private boolean wasWorking = false;
    private static final int LENGTH = 9;
    private boolean showsSprinkles = true;
    @SideOnly(value=Side.CLIENT)
    private GTFOSprinkleMaker sprinkleMaker;

    public CoverSprinkler(CoverDefinition definition, CoverableView coverHolder, EnumFacing attachedSide, int tier) {
        super(definition, coverHolder, attachedSide);
        this.tier = tier;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox, BlockRenderLayer blockRenderLayer) {
        if (this.sprinkleMaker == null || !this.sprinkleMaker.func_187113_k()) {
            this.sprinkleMaker = new GTFOSprinkleMaker(this.getWorld(), this.getCoverableView().getPos().func_177958_n(), this.getCoverableView().getPos().func_177956_o(), this.getCoverableView().getPos().func_177952_p(), this);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)this.sprinkleMaker);
        }
        GTFOClientHandler.SPRINKLER_OVERLAY.renderSided(this.getAttachedSide(), plateBox, renderState, pipeline, translation);
    }

    public void onRemoval() {
        super.onRemoval();
        this.writeCustomData(GTFOValues.UPDATE_SPRINKLER_EXISTENCE, packetBuffer -> packetBuffer.writeBoolean(false));
    }

    @SideOnly(value=Side.CLIENT)
    private void turnOffParticles() {
        if (this.sprinkleMaker != null) {
            this.sprinkleMaker.func_187112_i();
        }
    }

    public boolean canShowSprinkles() {
        return this.wasWorking && this.showsSprinkles;
    }

    public int getSprinkleColor() {
        return this.sprinkleColor;
    }

    public void func_73660_a() {
        IBlockState farmlandState;
        IBlockState cropState;
        IFluidHandler fluidHandler = (IFluidHandler)this.getCoverableView().getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getAttachedSide());
        if (fluidHandler == null) {
            return;
        }
        FluidStack fluid = fluidHandler.drain(1, true);
        boolean isWorkingNow = fluid != null;
        int percentageChance = 0;
        if (isWorkingNow) {
            Material mat = GregTechAPI.materialManager.getMaterial(fluid.getFluid().getName());
            if (mat != null) {
                FertilizerProperty property;
                int color = mat.getMaterialRGB();
                if (color != this.sprinkleColor) {
                    this.sprinkleColor = color;
                    this.syncAllData();
                }
                if ((property = (FertilizerProperty)mat.getProperty(GTFOMaterialHandler.FERTILIZER)) != null) {
                    percentageChance = property.getBoostPercentage();
                }
            } else {
                this.sprinkleColor = 255;
            }
        }
        if (this.operationPosition == null || this.workingArea == null) {
            this.setupWorkingArea();
        }
        this.updateOperationPosition();
        if (this.wasWorking != isWorkingNow) {
            this.wasWorking = isWorkingNow;
            this.syncAllData();
        }
        if ((cropState = this.getCoverableView().getWorld().func_180495_p((BlockPos)this.operationPosition)).func_177230_c() instanceof IGrowable && GTValues.RNG.nextInt(100) < percentageChance && ((IGrowable)cropState.func_177230_c()).func_176473_a(this.getCoverableView().getWorld(), (BlockPos)this.operationPosition, cropState, false)) {
            ((IGrowable)cropState.func_177230_c()).func_176474_b(this.getCoverableView().getWorld(), GTValues.RNG, (BlockPos)this.operationPosition, cropState);
        }
        if ((farmlandState = this.getCoverableView().getWorld().func_180495_p(this.operationPosition.func_177977_b())).func_177230_c() instanceof BlockFarmland) {
            this.getCoverableView().getWorld().func_175656_a(this.operationPosition.func_177977_b(), farmlandState.func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(Math.min(7, (Integer)farmlandState.func_177229_b((IProperty)BlockFarmland.field_176531_a) + 2))));
        }
    }

    public boolean canAttach(@NotNull CoverableView coverHolder, @NotNull EnumFacing attachedSide) {
        return this.getAttachedSide() == EnumFacing.DOWN && this.getCoverableView().getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getAttachedSide()) != null;
    }

    public void updateOperationPosition() {
        this.operationPosition.func_189536_c(EnumFacing.EAST);
        if (!this.isOperationPositionInsideWorkingArea()) {
            this.operationPosition.func_189534_c(EnumFacing.WEST, 9).func_189536_c(EnumFacing.SOUTH);
            if (!this.isOperationPositionInsideWorkingArea()) {
                this.setDefaultOperationPosition();
                if (!this.isOperationPositionInsideWorkingArea() && !this.getCoverableView().getWorld().field_72995_K) {
                    this.setupWorkingArea();
                }
            }
        }
    }

    private boolean isOperationPositionInsideWorkingArea() {
        return this.workingArea.func_72318_a(new Vec3d((double)this.operationPosition.func_177958_n(), (double)this.operationPosition.func_177956_o(), (double)this.operationPosition.func_177952_p()));
    }

    private void setupWorkingArea() {
        this.workingArea = new AxisAlignedBB(this.getPos().func_177967_a(EnumFacing.SOUTH, 4).func_177967_a(EnumFacing.EAST, 4), this.getPos().func_177967_a(EnumFacing.NORTH, 4).func_177967_a(EnumFacing.WEST, 4)).func_186662_g(0.1);
        if (this.operationPosition == null || !this.isOperationPositionInsideWorkingArea()) {
            this.setDefaultOperationPosition();
        }
    }

    private void setDefaultOperationPosition() {
        this.operationPosition = new BlockPos.MutableBlockPos(this.getPos().func_177967_a(EnumFacing.NORTH, 4).func_177967_a(EnumFacing.WEST, 4));
    }

    public BlockPos getPos() {
        return this.getCoverableView().getPos().func_177979_c(3);
    }

    private void syncAllData() {
        this.writeCustomData(GTFOValues.UPDATE_SPRINKLER_DATA, packetBuffer -> {
            packetBuffer.func_179255_a((BlockPos)this.operationPosition);
            packetBuffer.writeInt(this.sprinkleColor);
            packetBuffer.writeBoolean(this.wasWorking);
            packetBuffer.writeBoolean(this.showsSprinkles);
        });
    }

    public void readCustomData(int id, PacketBuffer packetBuffer) {
        super.readCustomData(id, packetBuffer);
        if (this.getWorld().field_72995_K) {
            if (id == GTFOValues.UPDATE_SPRINKLER_DATA) {
                this.operationPosition = new BlockPos.MutableBlockPos(packetBuffer.func_179259_c());
                this.sprinkleColor = packetBuffer.readInt();
                this.wasWorking = packetBuffer.readBoolean();
                this.showsSprinkles = packetBuffer.readBoolean();
                this.scheduleRenderUpdate();
            } else if (id == GTFOValues.UPDATE_SPRINKLER_EXISTENCE && !packetBuffer.readBoolean()) {
                this.turnOffParticles();
            }
        }
    }

    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        this.setupWorkingArea();
        buf.func_179255_a((BlockPos)this.operationPosition);
        buf.writeBoolean(this.wasWorking);
        buf.writeInt(this.sprinkleColor);
        buf.writeBoolean(this.showsSprinkles);
    }

    public void readInitialSyncData(PacketBuffer buf) {
        super.readInitialSyncData(buf);
        this.operationPosition = new BlockPos.MutableBlockPos(buf.func_179259_c());
        this.wasWorking = buf.readBoolean();
        this.sprinkleColor = buf.readInt();
        this.showsSprinkles = buf.readBoolean();
        this.setupWorkingArea();
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74772_a("operationPos", this.operationPosition.func_177986_g());
        tagCompound.func_74757_a("wasWorking", this.wasWorking);
        tagCompound.func_74768_a("sprinkleColor", this.sprinkleColor);
        tagCompound.func_74757_a("showsSprinkles", this.showsSprinkles);
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.operationPosition = new BlockPos.MutableBlockPos(BlockPos.func_177969_a((long)tagCompound.func_74763_f("operationPos")));
        this.wasWorking = tagCompound.func_74767_n("wasWorking");
        this.sprinkleColor = tagCompound.func_74762_e("sprinkleColor");
        this.showsSprinkles = tagCompound.func_74767_n("showsSprinkles");
    }

    public EnumActionResult onSoftMalletClick(EntityPlayer playerIn, EnumHand hand, CuboidRayTraceResult hitResult) {
        boolean bl = this.showsSprinkles = !this.showsSprinkles;
        if (!this.getWorld().field_72995_K) {
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation(this.showsSprinkles ? "gregtechfoodoption.sprinkler.particles.on" : "gregtechfoodoption.sprinkler.particles.off", new Object[0]));
        }
        return EnumActionResult.SUCCESS;
    }
}

